<?php

namespace Modules\Sc\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class MaterialRequisitionDataOther extends Model
{
    use HasFactory,LogsActivity;

    protected $fillable = [];
    protected $table = 'sc_material_requisition_data_others';
    protected $primaryKey = 'material_requisition_data_other_id';
    protected static $logAttributes = [
        'material_requisition_data_other_id',
        'internal_id',
        'external_id',
        'description',
        'quantity',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "sc_material_requisition_data_others";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
