<?php

namespace Modules\Sc\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class OrderType extends Model
{
    use HasFactory,LogsActivity;
    protected $table = 'sc_order_types';
    protected $primaryKey = 'order_type_id';
    protected $fillable = [];
    protected static $logAttributes = [
        'order_type_id',
        'order_type',
        'status',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "sc_order_types";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
    /*protected static function newFactory()
    {
        return \Modules\Sc\Database\factories\OrderTypeFactory::new();
    }*/
}
