<?php

namespace Modules\Sc\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class PurchaseRequestHeader extends Model
{
    use HasFactory,LogsActivity;
    protected $table = 'sc_purchase_request_headers';
    protected $primaryKey = 'internal_id';
    protected $fillable = [];
    protected static $logAttributes = [
        'internal_id',
        'external_id',
        'ref_internal_id',
        'ref_external_id',
        'trans_date',
        'dept_id',
        'store_id',
        'request_by',
        'employee_name',
        'mr_internal_id',
        'mr_extenal_id',
        'mi_type',
        'manufacturing_order_number',
        'project_code',
        'remarks',
        'status',
        'user_id',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "sc_purchase_request_headers";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
    /*protected static function newFactory()
    {
        return \Modules\Sc\Database\factories\PurchaseRequestHeaderFactory::new();
    }*/
}
