<?php

namespace Modules\Sc\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\Employee;
use Modules\Hr\Entities\EmployeeDepartment;
use Modules\Pd\Entities\ScheduleCustomerOrderPlan;
use Modules\PJ\Entities\Project;
use Modules\Pp\Entities\CustomerPlan;
use Modules\Pp\Entities\Machinary;
use Modules\Sc\Entities\Department;
use Modules\Sc\Entities\DocumentNumber;
use Modules\Sc\Entities\GrnData;
use Modules\Sc\Entities\GrnHeader;
use Modules\Sc\Entities\MaterialRequisitionHeader;
use Modules\Sc\Entities\MaterialRequisitionData;
use Modules\Sc\Entities\MiData;
use Modules\Sc\Entities\MiHeader;
use Modules\Sc\Entities\ProductHistory;
use Modules\Sc\Entities\ProductHistorySetoff;
use Modules\Sc\Entities\StoreLocation;
use Modules\St\Entities\Product;
use Modules\St\Entities\ProductUnit;
use Modules\St\Entities\Suppliers;
use Modules\St\Entities\Uom;

class MiHeaderControllrController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        return view('sc::index');
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('sc::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('sc::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('sc::edit');
    }



    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
    }

    public function allEmployees()
    {
        try {
            $employees = Employee::all();
            $result = array();
            foreach ($employees as $emp) {
                array_push($result, [
                    "img" => "",
                    "id" => $emp->employee_id,
                    "value" => $emp->name_withinitial,
                ]);
            }
            $responseBody = $this->responseBody(true, "MiHeaderController", "allEmployees", $result);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MiHeaderController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    public function allProjects()
    {
        try {
            $projects = Project::all();
            $responseBody = $this->responseBody(true, "MiHeaderController", "allProjects", $projects);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnReturnController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function allDepartment()
    {
        try {
            $department =  EmployeeDepartment::all();
            $responseBody = $this->responseBody(true, "MiHeaderController", "allDepartment", $department);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MiHeaderController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function allMachinery()
    {
        try {
            $machinery =  Machinary::all();
            $responseBody = $this->responseBody(true, "MiHeaderController", "allMachinery", $machinery);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MiHeaderController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function allProduct()
    {
        try {
            $products =  Product::select('product_primary_id As id', 'product_id As value0', 'product_name As value1')->get();
            return $this->responseBody(true, "MiHeaderController", "allProduct", $products);
        } catch (Exception $exception) {
            return $this->responseBody(false, "MiHeaderController", "error", $exception);
        }
    }


    public function maxID($store_id)
    {
        try {
            $id = DB::select('SELECT AUTO_INCREMENT  AS id FROM information_schema.TABLES WHERE TABLE_SCHEMA = "erp_riococo_salary3" AND TABLE_NAME = "sc_grn_headers"')[0]->id;
            $store = StoreLocation::find($store_id);
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
            }
            $responseBody = $this->responseBody(true, "MiHeaderController", "allProductUnit", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MiHeaderController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function allProductUnit()
    {
        try {
            $products =  ProductUnit::all();
            $responseBody = $this->responseBody(true, "MiHeaderController", "allProductUnit", $products);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MiHeaderController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    public function allStores()
    {
        try {
            $stores =  StoreLocation::all();
            $responseBody = $this->responseBody(true, "MiHeaderController", "allStores", $stores);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MiHeaderController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function allProductCustomer()
    {
        try {
            $query = 'SELECT pp_customer_order_plans.customer_order_plan_id,
            pp_customer_orders.factory_po_num,
            st_products.product_name,
            pp_customer_order_plans_data.customer_order_plan_data_id
            FROM pp_customer_order_plans
            LEFT JOIN pp_customer_orders ON pp_customer_order_plans.order_id = pp_customer_orders.order_id
            LEFT JOIN pp_customer_order_plans_data ON pp_customer_order_plans.customer_order_plan_id = pp_customer_order_plans_data.customer_order_plan_id
            LEFT JOIN st_products ON pp_customer_order_plans_data.product_id = st_products.product_primary_id
			ORDER BY pp_customer_order_plans.customer_order_plan_id DESC';
            $orderPlan =  DB::select($query);
            $responseBody = $this->responseBody(true, "MiHeaderController", "allProductCustomer", $orderPlan);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MiHeaderController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function save(Request $request)
    {
        try {
            $prefix = $this->getPrefix('200');
            $material_request_id = $request->get('mr_internal_id');

            $material_request_header = MaterialRequisitionHeader::find($material_request_id);
            $material_request_data = MaterialRequisitionData::where('internal_id', '=', $material_request_id)->get();
            
            $mi = new MiHeader();
            $mi->external_id = $prefix . "" . $request->get('external_id');
            $mi->ref_external_id = $prefix . "" . $request->get('ref_external_id');
            $mi->ref_mr_id = $request->get('ref_mr_no');
            $mi->trans_date = $request->get('trans_date');
            $mi->dept_id = $request->get('dept_id');
            $mi->machine_id = $request->get('machine_id');
            $mi->store_id = $request->get('store_id');
            $mi->supervisor_id = "0";
            $mi->employee_name = $request->get('employee_name');
            $mi->mr_internal_id = $request->get('mr_internal_id');
            $mi->mr_extenal_id = $request->get('mr_extenal_id');
            $mi->mi_type = $request->get('mi_type');
            $mi->document_no = 200;
            $mi->manufacturing_order_number = $request->get('manufacturing_order_number');
            if($material_request_header){
                $mi->manufacturing_order_number = $material_request_header->manufacturing_order_number;
            }
            $mi->customer_order_plan_data_id = $request->get('customer_order_plan_data_id');
            $mi->project_code = $request->get('project_code');
            $mi->remarks = $request->get('remarks');
            $mi->vehicle_no = $request->get('vehicle_no');
            $mi->to_store = $request->get('to_store');
            $mi->user_id = Auth::user()->id;
            $mi->Status = 0;
            if ($mi->save()) {
                $mi = MiHeader::find($mi->internal_id);
                $mi->ref_internal_id = $mi->internal_id;
                $mi->update();
                $mi_arr = $request->get("mi_data");
                for ($i = 0; $i < count($mi_arr); $i++) {
                    $miData = json_decode($mi_arr[$i]);
                    $mi_data = new MiData();
                    $mi_data->internal_id = $mi->internal_id;
                    $mi_data->external_id = $mi->external_id;
                    $mi_data->product_id =  $miData->product_id;
                    $mi_data->unit_id =  $miData->unit_id;
                    $mi_data->quantity =  $miData->qty;
                    $mi_data->comments =  $miData->comments;
                    if ($mi_data->save()) {

                        foreach ($material_request_data as $data) {
                            if ($data->product_id == $miData->product_id) {
                                $mrItem = MaterialRequisitionData::find($data->mr_data_id);
                                if ($mrItem) {
                                    $mrItem->issues_quantity = ($mrItem->issues_quantity + $miData->qty);
                                    $mrItem->update();
                                }
                            }
                        }


                        $this->addProductToHistory($mi, $mi_data);
                    }
                }
            }
            $responseBody = $this->responseBody(true, "MiHeaderController", "saveGrnHeaderTemp", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "MiHeaderController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }






    public function getMaterialIssue($id)
    {
        try {
            $mi = MiHeader::find($id);
            if (count(array_filter(explode("-", $mi->external_id))) == 2) {
                $mi->external_id = explode("-", $mi->external_id)[1];
            }
            //$supervisor = Employee::find($mi->supervisor_id);
            $received = Employee::find($mi->received_by);
            //$mi->supervisor = $supervisor->name_withinitial;
            $mi_data = MiData::where('internal_id', '=', $id)->get();
            foreach ($mi_data as $data) {
                $product = Product::where('product_primary_id', '=', $data->product_id)->first();
                $data->product = $product->product_name;
                $uom = ProductUnit::find($product->uom_id);
                $uom_arr = [];
                if ($uom) {
                    array_push($uom_arr, ["value" => $uom->id, "text" => $uom->name]);
                }
                $data->uom = $uom_arr;
                $data->product_primary_id = $product->product_primary_id;
                $data->product_id = $product->product_id;
            }
            $mi->data = $mi_data;
            $responseBody = $this->responseBody(true, "MiHeaderController", "getGrn", $mi);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MiHeaderController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function getQty($product_id, $store_id)
    {
        try {
            $query = "SELECT SUM(quantity) AS quantity 
                        FROM sc_product_histories 
                        WHERE product_id = '" . $product_id . "' AND store_id = '" . $store_id . "'";
            $result = DB::select($query);
            $quantity = 0;
            foreach ($result as $data) {
                if ($data->quantity) {
                    $quantity = $data->quantity;
                }
            }
            $responseBody = $this->responseBody(true, "MiHeaderController", "getQty", $quantity);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MiHeaderController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function updatexx(Request $request, $id)
    {

        try {
            $mi_header = MiHeader::find($id);
            if ($mi_header) {
                if ($this->delete($mi_header->external_id)) {
                    $this->removeProductHistory($mi_header);
                    $this->removeProductFromSetoff($mi_header);
                    if ($mi_header->delete()) {
                        $bool =  $this->save($request);
                    }
                }
            }
            $responseBody = $this->responseBody(true, "MiHeaderController", "saveGrnHeaderTemp", $bool);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "MiHeaderController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }






    public function update(Request $request, $id)
    {
        try {
            if ($this->delete($id)) {
                $prefix = $this->getPrefix('200');
                $mi = MiHeader::find($id);
                $material_request_id = $mi->mr_internal_id;
                $material_request_data = MaterialRequisitionData::where('internal_id', '=', $material_request_id)->get();

                $mi->external_id = $prefix . "" . $request->get('external_id');
                $mi->ref_external_id = $prefix . "" . $request->get('ref_external_id');
                $mi->trans_date = $request->get('trans_date');
                $mi->dept_id = $request->get('dept_id');
                $mi->machine_id = $request->get('machine_id');
                $mi->store_id = $request->get('store_id');
                $mi->supervisor_id = "0";
                $mi->employee_name = $request->get('employee_name');
                //$mi->mr_internal_id = $request->get('mr_internal_id');
                //$mi->mr_extenal_id = $request->get('mr_extenal_id');
                $mi->mi_type = $request->get('mi_type');
                $mi->manufacturing_order_number = $request->get('manufacturing_order_number');
                $mi->customer_order_plan_data_id = $request->get('customer_order_plan_data_id');
                $mi->project_code = $request->get('project_code');
                $mi->remarks = $request->get('remarks');
                $mi->vehicle_no = $request->get('vehicle_no');
                $mi->to_store = $request->get('to_store');
                $mi->user_id = Auth::user()->id;
                $mi->Status = 0;
                if ($mi->update()) {
                    $this->removeProductHistory($mi);
                    $this->removeProductHistorySetoff($mi);
                    $mi_arr = $request->get("mi_data");
                    for ($i = 0; $i < count($mi_arr); $i++) {
                        $miData = json_decode($mi_arr[$i]);
                        $mi_data = new MiData();
                        $mi_data->internal_id = $mi->internal_id;
                        $mi_data->external_id = $mi->external_id;
                        $mi_data->product_id =  $miData->product_id;
                        $mi_data->unit_id =  $miData->unit_id;
                        $mi_data->quantity =  $miData->qty;
                        $mi_data->comments =  $miData->comments;
                        if ($mi_data->save()) {

                            foreach ($material_request_data as $data) {
                                if ($data->product_id == $miData->product_id) {
                                    $mrItem = MaterialRequisitionData::find($data->mr_data_id);
                                    if ($mrItem) {
                                        $mrItem->issues_quantity = $miData->qty;
                                        $mrItem->update();
                                    }
                                }
                            }


                            $this->updateProductHistory($mi, $mi_data);
                        }
                    }
                }
            }
            $responseBody = $this->responseBody(true, "MiHeaderController", "saveGrnHeaderTemp", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "MiHeaderController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    public function deleteMaterialIssue($id)
    {

        try {
            $mi_header = MiHeader::find($id);
            if ($mi_header) {
                if ($this->delete($mi_header->external_id)) {
                    $this->removeProductHistory($mi_header);
                    $this->removeProductHistorySetoff($mi_header);
                    $mi_header->delete();
                }
            }
            $responseBody = $this->responseBody(true, "MiHeaderController", "deleteMaterialIssue", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "MiHeaderController", "deleteMaterialIssue", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }






    public function delete($id)
    {
        try {
            MiData::where('internal_id', '=', $id)->delete();
            return true;
        } catch (Exception $exception) {
            return false;
        }
    }







    private function updateProductHistorySetOff($ref_internal_id, $product_id, $store_id, $setoff_quantity)
    {

        $product_history = ProductHistory::where([['product_id', '=', $product_id], ['store_id', '=', $store_id], ['document_no', '=', '100']])->get();

        $setoff = $setoff_quantity;

        foreach ($product_history as $data) {
            $setoff += $data->set_off;
            if ($setoff >= $data->quantity) {
                $data->set_off = $data->quantity;
                $data->update();
                $setoff = ($setoff - $data->quantity);
            } else {
                $data->set_off = $setoff;
                $data->update();
                $setoff = ($setoff - $setoff_quantity);
            }
        }
    }



    public function change_status(Request $request, $id)
    {

        try {

            $mi_header = MiHeader::find($id);
            $mi_header->status = $request->get('status');
            $updated = $mi_header->update();
            if ($request->get('status') == 2 && $updated) {
                //$deleed =  MiData::where('internal_id','=',$id)->delete();
                //MiHeader::find($id)->delete();
                //$this->removeProductToHistory($id);
                $this->removeProductHistory($mi_header);
                $this->removeProductHistorySetoff($mi_header);
            }

            $responseBody = $this->responseBody(true, "MiHeaderController", "approve", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "MiHeaderController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    private function addProductToHistory($header, $data)
    {


        $product_history_setoff = new ProductHistorySetOffController();

        $product_history = new ProductHistory();
        $product_history->internal_id = $data->internal_id;
        $product_history->external_id = $data->external_id;
        $product_history->document_no = "200";
        $product_history->description = "Material Issue";
        $product_history->product_id = $data->product_id;
        $product_history->unit_id = $data->unit_id;
        $product_history->quantity = ($data->quantity * -1);
        $product_history->set_off = 0;
        $product_history->cost_price = 0;
        $product_history->store_id = $header->store_id;
        $product_history->user_id = Auth::user()->id;
        $product_history->transaction_date = $header->trans_date;
        if ($product_history->save()) {
            $product_history_setoff->saveMaterialIssue($product_history);
        }
    }




    private function removeProductToHistory($internal_id)
    {

        $mi_data = MiData::where('internal_id', '=', $internal_id)->get();
        foreach ($mi_data as $data) {
            $product_primary_id = $data->product_id;
            ProductHistory::where([['internal_id', '=', $internal_id], ['document_no', '=', "200"], ['product_id', '=', $product_primary_id]])->delete();
            ProductHistorySetoff::where([['internal_id', '=', $internal_id], ['document_no', '=', "200"], ['product_id', '=', $product_primary_id]])->delete();
        }
    }





    private function updateProductHistory($header, $new_data)
    {



        $product_history_setoff = new ProductHistorySetOffController();

        $product_history = new ProductHistory();
        $product_history->internal_id = $header->internal_id;
        $product_history->external_id = $header->external_id;
        $product_history->document_no = $header->document_no;
        $product_history->description = "Material Issue";
        $product_history->product_id = $new_data->product_id;
        $product_history->unit_id = $new_data->unit_id;
        $product_history->quantity = ($new_data->quantity * -1);
        $product_history->set_off = 0;
        $product_history->cost_price = 0;
        $product_history->store_id = $header->store_id;
        $product_history->user_id = Auth::user()->id;
        $product_history->transaction_date = $header->trans_date;
        if ($product_history->save()) {
            $product_history_setoff->updateMaterialIssue($product_history);
        }
    }







    public function getUom($id)
    {
        try {
            $product =  Product::where('product_primary_id', '=', $id)->first();

            $data = [
                "id" => "0",
                "value" => "",
            ];
            if ($product) {
                $uom =  ProductUnit::find($product->uom_id);
                if ($uom) {
                    $data["id"] = $uom->id;
                    $data["value"] = $uom->name;
                }
            }

            $responseBody = $this->responseBody(true, "MiHeaderController", "getUom", $data);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MiHeaderController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    private function removeProductHistory($mi)
    {
        $document_no = $mi->document_no;
        $internal_no = $mi->internal_id;
        $external_no = $mi->external_id;
        ProductHistory::where([['document_no', '=', $document_no], ['internal_id', '=', $internal_no], ['external_id', '=', $external_no]])->delete();
    }

    private function removeProductHistorySetoff($mi)
    {
        $document_no = $mi->document_no;
        $internal_no = $mi->internal_id;
        $external_no = $mi->external_id;
        $store = $mi->store_id;
        $setoff_array = ProductHistorySetoff::where([['document_no', '=', $document_no], ['internal_id', '=', $internal_no], ['external_id', '=', $external_no], ['store_id', '=', $store]])->get();
        foreach ($setoff_array as $obj) {
            //$obj = ProductHistorySetoff::find($setoff->transaction_id);
            if ($obj) {
                if ($obj->quantity < 0) {
                    $ref_document_no = $obj->ref_document_no;
                    $ref_internal_no = $obj->ref_internal_id;
                    $ref_external_no = $obj->ref_external_id;
                    //$ref_external_no = $obj->ref_external_id;
                    $result = ProductHistorySetoff::where([['document_no', '=', $ref_document_no], ['internal_id', '=', $ref_internal_no], ['external_id', '=', $ref_external_no], ['store_id', '=', $store]])->first();
                    $obj2 = ProductHistorySetoff::find($result->transaction_id);
                    if ($obj2) {
                        $qty = ($obj2->setoff_quantity - abs($obj->quantity));
                        $obj2->setoff_quantity = abs($qty);
                        if ($obj2->update()) {
                            $mr_data = MaterialRequisitionData::where('product_id', '=', $obj2->product_id)->get();
                            $remainQty = 0;
                            foreach ($mr_data as $mr_item) {
                                if ($mr_item->issues_quantity > 0 && $mr_item->issues_quantity >= abs($obj->quantity)) {
                                    $mr_item->issues_quantity = ($mr_item->issues_quantity - abs($obj->quantity));
                                } else {
                                    $remainQty += abs($obj->quantity) - $mr_item->issues_quantity;
                                    $mr_item->issues_quantity = ($mr_item->issues_quantity - abs($remainQty));
                                }
                                $mr_item->issues_quantity = 0;
                                $mr_item->update();
                            }
                        }
                    }
                }
                $obj->delete();
            }
        }
    }



    public function isApproved($id)
    {
        try {
            $mi_header = MiHeader::find($id);
            if ($mi_header) {
                $responseBody = $this->responseBody(true, "MiHeaderController", "isApproved", $mi_header->status);
            }
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MiHeaderController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    private function getPrefix($document_no)
    {
        $document_no = DocumentNumber::where('document_number', '=', $document_no)->first();
        $prefix = "";
        if ($document_no) {
            $prefix = $document_no->prefix;
        }

        return $prefix;
    }



    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
