<?php

namespace Modules\Sc\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\EmployeeSite;
use Modules\Sc\Entities\StoreLocation;
use Modules\St\Entities\GroupLevel1;
use Modules\St\Entities\GroupLevel2;
use Modules\St\Entities\GroupLevel3;
use Modules\St\Entities\Product;
use Modules\St\Entities\ProductType;

class ProductListReportController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        return view('sc::index');
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('sc::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('sc::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('sc::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
    }

    public function allSettings()
    {

        try {
            $settings = [

                "producttype" => $this->producttype(),
                "grouplevel1" => $this->grouplevel1(),
                "grouplevel2" => $this->grouplevel2(),
                "grouplevel3" => $this->grouplevel3(),

            ];
            $responseBody = $this->responseBody(true, "AllSettings", "all", ["settings" => $settings]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "AllSettings", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }









    public function producttype()
    {

        try {
            $type = ProductType::all();
            $collection = [];
            for ($i = 0; $i < count($type); $i++) {
                array_push($collection, ["id" => $type[$i]['product_type_id'], "value" => $type[$i]['product_type']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }



    public function grouplevel1()
    {

        try {
            $groupLevel = GroupLevel1::all();
            $collection = [];
            for ($i = 0; $i < count($groupLevel); $i++) {
                array_push($collection, ["id" => $groupLevel[$i]['group_level_1_id'], "value" => $groupLevel[$i]['group_level_1']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }


    public function grouplevel2()
    {

        try {
            $groupLevel = GroupLevel2::all();
            $collection = [];
            for ($i = 0; $i < count($groupLevel); $i++) {
                array_push($collection, ["id" => $groupLevel[$i]['group_level_2_id'], "value" => $groupLevel[$i]['group_level_2']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }



    public function grouplevel3()
    {

        try {
            $groupLevel = GroupLevel3::all();
            $collection = [];
            for ($i = 0; $i < count($groupLevel); $i++) {
                array_push($collection, ["id" => $groupLevel[$i]['group_level_3_id'], "value" => $groupLevel[$i]['group_level_3']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }







    function productListReport($setting, $date_form, $date_to)
    {
        try {
            $title = '';
            $setting_aaray =  json_decode($setting);

            $producttype = $setting_aaray->producttype;
            $grouplevel1 = $setting_aaray->grouplevel1;
            $grouplevel2 = $setting_aaray->grouplevel2;
            $grouplevel3 = $setting_aaray->grouplevel3;


            ini_set('max_execution_time', '0'); // for infinite time of execution

            $query = "SELECT DISTINCT P.product_id,P.product_name,P.`uom_id` AS unit,GP1.group_level_1,GP2.group_level_2,GP3.group_level_3 FROM st_products P
            INNER JOIN st_group_level_1 GP1 ON GP1.group_level_1_id =P.group_id_level_1
            INNER JOIN  st_group_level_2 GP2  ON GP2.group_level_2_id =P.group_id_level_2
             INNER JOIN  st_group_level_3 GP3  ON GP3.group_level_3_id =P.group_id_level_3 WHERE 1 ";




            if ($producttype != '') {
                $query .= " AND P.product_type_id = '" . $producttype . "' ";
                $title = '';
            }

            if ($grouplevel1 != '') {
                $query .= " AND P.group_id_level_1 = '" . $grouplevel1 . "'  ";
                $title = '';
            }

            if ($grouplevel2 != '') {
                $query .= " AND P.group_id_level_2 = '" . $grouplevel2 . "' ";
                $title = '';
            }

            if ($grouplevel3 != '') {
                $query .= " AND P.group_id_level_3 = '" . $grouplevel3 . "'  ";
                $title = '';
            }


            // $query = preg_replace('/\W\w+\s*(\W*)$/', '$1', $query);


            $productlist = DB::select($query);
            $responseBody = $this->responseBody(true, $query, "Report", [
                'body' => $productlist,
                'title' => $title,
                "report_date" => "(" . $date_form . " - " . $date_to . ")",
            ]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "productListController", "Report", $query);
        }
        return response()->json(["data" => $responseBody]);
    }



    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
