<?php

namespace Modules\Sc\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Hr\Entities\Employee;
use Modules\Sc\Entities\OrderType;
use Modules\Sc\Entities\PayTerm;
use Modules\Sc\Entities\PurchaseOrderData;
use Modules\Sc\Entities\PurchaseOrderDataOther;
use Modules\Sc\Entities\PurchaseOrderHeader;
use Modules\Sc\Entities\StoreLocation;
use Modules\St\Entities\Product;
use Modules\St\Entities\ProductUnit;
use Modules\St\Entities\Suppliers;
use Modules\St\Entities\Uom;
use Modules\St\Entities\Currency;

class PurchaseOrderListController extends Controller
{
    public function allPurchaseOrder()
    {
        try {
            $purchaseList = PurchaseOrderHeader::select('*')->orderBy('internal_id', 'DESC')->get();
            $responseBody = $this->responseBody(true, "PurchaseOrderListController", "allPurchaseOrder", $purchaseList);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseOrderListController", "allPurchaseOrder", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    public function purchaseOrderReport($id)
    {
        try {
            $purchase_header = PurchaseOrderHeader::find($id);

            $header = [
                "referance_no" => "",
                "date" => "",
                "deliver_before" => "",
                "store" => "",
                "pay_term" => "",
                "order_type" => "",
                "supplier" => "",
                "order_by" => "",
                "employee_name" => "",
                "discount_overall" => "0.00",
                "gross_value" => "0.00",
                "discount" => "0.00",
                "net_value" => "0.00",
                "remarks" => "",
                "ref_purchase_request_no" => "",
                "exchange_rate" => "",
                "currency" => "",
            ];


            if ($purchase_header) {
                $header["referance_no"] = $purchase_header->external_id;
                $header["date"] = $purchase_header->trans_date;
                $header["deliver_before"] = $purchase_header->deliver_before;
                $header["supplier"] = $this->getSupplier($purchase_header->supplier_id);
                $header["order_by"] = $this->getOrderBy($purchase_header->order_by);
                $header["employee_name"] = $purchase_header->employee_name;
                $header["store"] = $this->getStore($purchase_header->store_id);
                $header["pay_term"] = $this->getPayTerm($purchase_header->pay_term_id);
                $header["order_type"] = $this->getOrderType($purchase_header->order_type_id);
                $header["discount_overall"] = $purchase_header->discount_overall;
                $header["gross_value"] = $purchase_header->gross_value;
                $header["discount"] = $purchase_header->discount;
                $header["net_value"] = $purchase_header->net_value;
                $header["remarks"] = $purchase_header->remarks ?? "";
                $header["ref_purchase_request_no"] = $purchase_header->ref_pr_id ?? "";
                $header["exchange_rate"] = $purchase_header->exchange_rate;
                $header["currency"] = $this->getCurrencyType($purchase_header->currency_id);
            }

            $data = PurchaseOrderData::where('internal_id', '=', $id)->get();
            foreach ($data as $dd) {
                $product = Product::find($dd->product_id);
                $dd->product = $product->product_name;
                $dd->product_id = $product->product_id;
                $uom = ProductUnit::find($dd->unit_id);
                if ($uom) {
                    $dd->unit = $uom->name;
                } else {
                    $dd->unit = "";
                }
            }
            $other = PurchaseOrderDataOther::where('internal_id', '=', $id)->get();

            $responseBody = $this->responseBody(true, "PurchaseOrderListController", "allPurchaseOrder", ["header" => $header, "body" => ["data" => $data, "other" => $other]]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseOrderListController", "allPurchaseOrder", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    private function getSupplier($id)
    {

        $supplier = Suppliers::find($id);
        if ($supplier) {
            return $supplier->supplier_name;
        }
        return "";
    }

    private function getCurrencyType($id){
        $currency = Currency::find($id);
        if ($currency) {
            return $currency->iso_code;
        }
        return "";
    }

    private function getOrderBy($id)
    {
        $orderby = Employee::find($id);
        if ($orderby) {
            return $orderby->name_withinitial;
        }
        return "";
    }


    private function getStore($id)
    {
        $store = StoreLocation::find($id);
        if ($store) {
            return $store->name;
        }
        return "";
    }


    private function getPayTerm($id)
    {
        $payterm = PayTerm::find($id);
        if ($payterm) {
            return $payterm->pay_term;
        }
        return "";
    }


    private function getOrderType($id)
    {
        $ordertype = OrderType::find($id);
        if ($ordertype) {
            return $ordertype->order_type;
        }
        return "";
    }




    public function deletePurchaseOrder($id)
    {
        try {

            $purchase_data = PurchaseOrderData::where('internal_id', '=', $id)->get();
            foreach ($purchase_data as $data) {
                $data->delete();
            }

            $purchase_data = PurchaseOrderData::where('internal_id', '=', $id)->get();
            if (count($purchase_data) == 0) {
                $purchase = PurchaseOrderHeader::find($id);
                $purchase->delete();
            }

            $responseBody = $this->responseBody(true, "PurchaseOrderListController", "deletePurchaseOrder", true);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseOrderListController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function change_status(Request $request,$id)
    {

        try {

            $po_header = PurchaseOrderHeader::find($id);
            $po_header->status = $request->get('status');
            $po_header->update();
      

            $responseBody = $this->responseBody(true, "PurchaseOrderListController", "change_status", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseOrderListController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }

    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
