<?php

namespace Modules\Sc\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\Employee;
use Modules\Hr\Entities\EmployeeDepartment;
use Modules\PJ\Entities\Project;
use Modules\Pp\Entities\CustomerPlan;
use Modules\Pp\Entities\Machinary;
use Modules\Sc\Entities\Department;
use Modules\Sc\Entities\DocumentNumber;
use Modules\Sc\Entities\GrnData;
use Modules\Sc\Entities\GrnHeader;
use Modules\Sc\Entities\MiData;
use Modules\Sc\Entities\MiHeader;
use Modules\Sc\Entities\ProductHistory;
use Modules\Sc\Entities\ProductHistorySetoff;
use Modules\Sc\Entities\PurchaseRequestAttachment;
use Modules\Sc\Entities\PurchaseRequestData;
use Modules\Sc\Entities\PurchaseRequestDataOther;
use Modules\Sc\Entities\PurchaseRequestHeader;
use Modules\Sc\Entities\StoreLocation;
use Modules\St\Entities\Product;
use Modules\St\Entities\ProductUnit;
use Modules\St\Entities\Uom;

class PurchaseRequestController extends Controller
{
    public function allEmployees()
    {
        try {
            $employees = Employee::all();
            $result = array();
            foreach ($employees as $emp) {
                array_push($result, [
                    "img" => "",
                    "id" => $emp->employee_id,
                    "value" => $emp->name_withinitial,
                ]);
            }
            $responseBody = $this->responseBody(true, "PurchaseRequestController", "allEmployees", $result);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseRequestController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }

 
    public function allProjects()
    {
        try {
            $projects = Project::all();
            $responseBody = $this->responseBody(true, "PurchaseRequestController", "allProjects", $projects);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnReturnController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function allDepartment()
    {
        try {
            $department =  EmployeeDepartment::all();
            $responseBody = $this->responseBody(true, "PurchaseRequestController", "allDepartment", $department);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseRequestController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }





    public function allProduct()
    {
        try {
            $products =  Product::select('product_primary_id As id', 'product_id As value0', 'product_name As value1')->get();
            return $this->responseBody(true, "PurchaseRequestController", "allProduct", $products);
        } catch (Exception $exception) {
            return $this->responseBody(false, "PurchaseRequestController", "error", $exception);
        }
    }




    public function allProductUnit()
    {
        try {
            $products =  ProductUnit::all();
            $responseBody = $this->responseBody(true, "PurchaseRequestController", "allProductUnit", $products);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseRequestController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    public function allStores()
    {
        try {
            $stores =  StoreLocation::all();
            $responseBody = $this->responseBody(true, "PurchaseRequestController", "allStores", $stores);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseRequestController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function allProductCustomer()
    {
        try {
            $orderPlan =  CustomerPlan::all();
            $responseBody = $this->responseBody(true, "PurchaseRequestController", "allProductCustomer", $orderPlan);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseRequestController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function save(Request $request)
    {
        try {
            $prefix = $this->getPrefix('300');
            $purchase = new PurchaseRequestHeader();
            $purchase->external_id = $prefix . "" . $request->get('external_id');
            $purchase->ref_external_id = $prefix . "" . $request->get('ref_external_id');
            $purchase->trans_date = $request->get('trans_date');
            $purchase->dept_id = $request->get('dept_id');
            $purchase->store_id = $request->get('store_id');
            $purchase->request_by = 0;
            $purchase->employee_name = $request->get('request_by');
            $purchase->mr_internal_id = $request->get('mr_internal_id');
            $purchase->mr_extenal_id = $request->get('mr_extenal_id');
            $purchase->mi_type = $request->get('mi_type');
            $purchase->manufacturing_order_number = $request->get('manufacturing_order_number');
            $purchase->project_code = $request->get('project_code');
            $purchase->remarks = $request->get('remarks');
            $purchase->Status = 0;
            $purchase->user_id = Auth::user()->id;
            if ($purchase->save()) {
                $purchase = PurchaseRequestHeader::find($purchase->internal_id);
                $purchase->ref_internal_id = $purchase->internal_id;
                $purchase->update();
                $purchase_arr = $request->get("request_data");
                
                if (!empty($purchase_arr) && !empty($purchase_arr[0]["product_id"])) {
                    for ($i = 0; $i < count($purchase_arr); $i++) {
                        $prh_data = new PurchaseRequestData();
                        $prh_data->internal_id = $purchase->internal_id;
                        $prh_data->external_id = $purchase->external_id;
                        $prh_data->product_id =  $purchase_arr[$i]["product_id"];
                        $prh_data->unit_id =  $purchase_arr[$i]["unit_id"];
                        $prh_data->quantity =  $purchase_arr[$i]["qty"];
                        $prh_data->comments =  $purchase_arr[$i]["comments"];
                        $prh_data->save();
                    }
                }


                $purchase__other_arr = $request->get("request_other");
                if (!empty($purchase__other_arr) && !empty($purchase__other_arr[0]["description"])) {
                    for ($i = 0; $i < count($purchase__other_arr); $i++) {
                        $prh_other = new PurchaseRequestDataOther();
                        $prh_other->internal_id = $purchase->internal_id;
                        $prh_other->external_id = $purchase->external_id;
                        $prh_other->description = $purchase__other_arr[$i]["description"];
                        $prh_other->quantity = $purchase__other_arr[$i]["quantity"];
                        $prh_other->save();
                    }
                
                }


                $attachmnet_token = $request->get("attachment_token");
                $attachments = PurchaseRequestAttachment::where('token', '=', $attachmnet_token)->get();
                foreach ($attachments as $attachmnet) {
                    if ($attachmnet) {
                        $attachmnet->purchase_request_id = $purchase->internal_id;
                        $attachmnet->update();
                    }
                }
            }
            $responseBody = $this->responseBody(true, "PurchaseRequestController", "saveGrnHeaderTemp", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseRequestController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }






    public function getPurchaseRequest($id)
    {
        try {
            $purchase = PurchaseRequestHeader::find($id);
            if (count(array_filter(explode("-", $purchase->external_id))) == 2) {
                $purchase->external_id = explode("-", $purchase->external_id)[1];
            }
            $purchase_data = PurchaseRequestData::where('internal_id', '=', $id)->get();
            foreach ($purchase_data as $data) {
                $product = Product::where('product_primary_id', '=', $data->product_id)->first();
                $data->product = $product->product_name;
                $uom = ProductUnit::find($product->uom_id);
                $uom_arr = [];
                if ($uom) {
                    array_push($uom_arr, ["value" => $uom->id, "text" => $uom->name]);
                }
                $data->uom = $uom_arr;
                $data->product_primary_id = $product->product_primary_id;
                $data->product_id = $product->product_id;
            }
            $purchase->request_data = $purchase_data;
            $purchase_other = PurchaseRequestDataOther::where('internal_id', '=', $id)->get();
            $purchase->request_other = $purchase_other;
            $responseBody = $this->responseBody(true, "PurchaseRequestController", "getGrn", $purchase);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseRequestController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    public function getPurchaseRequestByExternalID($id)
    {
        try {
            $purchase = PurchaseRequestHeader::where('external_id', '=', $id)->first();
            if (count(array_filter(explode("-", $purchase->external_id))) == 2) {
                $purchase->external_id = explode("-", $purchase->external_id)[1];
            }
            $purchase_data = PurchaseRequestData::where('external_id', '=', $id)->get();
            foreach ($purchase_data as $data) {
                $product = Product::where('product_primary_id', '=', $data->product_id)->first();
                $data->product = $product->product_name;
                $uom = ProductUnit::find($product->uom_id);
                $uom_arr = [];
                if ($uom) {
                    array_push($uom_arr, ["value" => $uom->id, "text" => $uom->name]);
                }
                $data->uom = $uom_arr;
                $data->product_primary_id = $product->product_primary_id;
                $data->product_id = $product->product_id;
            }
            $purchase->request_data = $purchase_data;
            $purchase_other = PurchaseRequestDataOther::where('external_id', '=', $id)->get();
            $purchase->request_other = $purchase_other;
            $responseBody = $this->responseBody(true, "PurchaseRequestController", "getGrn", $purchase);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseRequestController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function update(Request $request, $id)
    {

        try {

            if ($this->delete($id)) {
                $prefix = $this->getPrefix('300');
                $purchase =  PurchaseRequestHeader::find($id);
                $purchase->external_id = $prefix . "" . $request->get('external_id');
                $purchase->ref_external_id = $prefix . "" . $request->get('ref_external_id');
                $purchase->trans_date = $request->get('trans_date');
                $purchase->dept_id = $request->get('dept_id');
                $purchase->store_id = $request->get('store_id');
                $purchase->request_by = 0;
                $purchase->employee_name = $request->get('request_by');
                $purchase->mr_internal_id = $request->get('mr_internal_id');
                $purchase->mr_extenal_id = $request->get('mr_extenal_id');
                $purchase->mi_type = $request->get('mi_type');
                $purchase->manufacturing_order_number = $request->get('manufacturing_order_number');
                $purchase->project_code = $request->get('project_code');
                $purchase->remarks = $request->get('remarks');
                if ($purchase->update()) {
                    $purchase_arr = $request->get("request_data");
                    if ($purchase_arr) {
                        for ($i = 0; $i < count($purchase_arr); $i++) {
                            $prh_data = new PurchaseRequestData();
                            $prh_data->internal_id = $purchase->internal_id;
                            $prh_data->external_id = $purchase->external_id;
                            $prh_data->product_id =  $purchase_arr[$i]["product_id"];
                            if ($purchase_arr[$i]["unit_id"]) {
                                $prh_data->unit_id =  $purchase_arr[$i]["unit_id"];
                            }
                            $prh_data->quantity =  $purchase_arr[$i]["qty"];
                            $prh_data->comments =  $purchase_arr[$i]["comments"];
                            $prh_data->save();
                        }
                    }


                    $purchase__other_arr = $request->get("request_other");
                    if ($purchase__other_arr) {
                        for ($i = 0; $i < count($purchase__other_arr); $i++) {
                            $prh_other = new PurchaseRequestDataOther();
                            $prh_other->internal_id = $purchase->internal_id;
                            $prh_other->external_id = $purchase->external_id;
                            $prh_other->description = $purchase__other_arr[$i]["description"];
                            $prh_other->quantity = $purchase__other_arr[$i]["quantity"];
                            $prh_other->save();
                        }
                    }


                    $attachmnet_token = $request->get("attachment_token");
                    $attachments = PurchaseRequestAttachment::where('token', '=', $attachmnet_token)->get();
                    foreach ($attachments as $attachmnet) {
                        if ($attachmnet) {
                            $attachmnet->purchase_request_id = $purchase->internal_id;
                            $attachmnet->update();
                        }
                    }
                }
            }

            $responseBody = $this->responseBody(true, "PurchaseRequestController", "saveGrnHeaderTemp", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseRequestController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function delete($id)
    {
        try {
            $purchase_data = PurchaseRequestData::where('internal_id', '=', $id)->get();
            foreach ($purchase_data as $data) {
                $data->delete();
            }
            $purchase_other = PurchaseRequestDataOther::where('internal_id', '=', $id)->get();
            foreach ($purchase_other as $data) {
                $data->delete();
            }
            return true;
        } catch (Exception $exception) {
            return false;
        }
    }






    public function uploadAttachment(Request $request)
    {

        //$id = $request->get('att_id');
        $token = $request->get('attachmnet_token');
        $file = $request->file('file');
        $file_name = $file->getClientOriginalName();
        $filename = uniqid() . '_' . time() . '.' . $file_name;
        $filename = str_replace(' ','',str_replace('\'','',$filename));
        $file->move(public_path('purchase_request'), $filename);

        $purchase_request_attachment = new PurchaseRequestAttachment();
        $purchase_request_attachment->purchase_request_id = 0;
        $purchase_request_attachment->path = $filename;
        $purchase_request_attachment->token = $token;
        return $purchase_request_attachment->save();
    }



    public function allAttachment($id, $token)
    {
        try {

            $attachment = DB::select('SELECT *FROM sc_purchase_request_attachments WHERE  purchase_request_id = "' . $id . '" OR token = "' . $token . '"');
            $responseBody = $this->responseBody(true, "allAttachment", "found", $attachment);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "allAttachment", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function deleteAttachment($id)
    {
        try {
            $attachment = PurchaseRequestAttachment::find($id);
            if ($attachment) {
                $attachment->delete();
            }
            $responseBody = $this->responseBody('PurcahseRequestController', "deleteAttachment", "delete", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody('PurcahseRequestController', "deleteAttachment", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    private function getPrefix($document_no)
    {
        $document_no = DocumentNumber::where('document_number', '=', $document_no)->first();
        $prefix = "";
        if ($document_no) {
            $prefix = $document_no->prefix;
        }

        return $prefix;
    }


    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
