$(document).ready(function () {

    var dataChooser = $('#dataChooser').dataChooser({
        title: 'GRN Product List',
        action: 'Select',

    });

    $('#btnSearch').on('click', function () {
        dataChooser.showChooser();
    });

    $('#btnAdd').on('click', function () {
        $('#btnSearch').focus();
        addProduct();
    });


    $('#btnSearch').on('keyup', function (e) {
        if (e.which == 9) {
            dataChooser.showChooser();
        }
    });

    dataChooser.on('select', function (event, id, value) {
        $('#dataChooser').hideChooser();
        $('#txtCode').val(id);
        $('#txtProduct').val(value);
        $('#txtUnit').focus();
    });


    $('#txtUnit').bind("change paste keyup", function () {
        price();
    });

    $('#txtQty').bind("change paste keyup", function () {
        price();
    });

    loadData();

});




function loadData() {
    $.ajax({
        type: "GET",
        url: "/sc/grn/product/getProduct",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            $('#dataChooser').setDatasource(response.result);
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}



function price() {

    var unit = $('#txtUnit').val().trim();
    var qty = $('#txtQty').val().trim();
    var price = 0.0;

    if (isNaN(unit)) unit = 0;
    if (isNaN(qty)) qty = 0;

    price = price + (unit * qty);

    $('#txtPrice').val(price.toFixed(2));
    if (price < 0) {
        $('#txtPrice').css("color", "red");
    } else {
        $('#txtPrice').css("color", "black");
    }

}


function addProduct() {
    
    
}