$(document).ready(function () {
    var table = $('#myTable').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "reference_no" },
            { "data": "supplier" },
            { "data": "date" },
            { "data": "approve", className: "approve" },
            { "data": "approve_status", className: "approve_status" },
        ],
        columnDefs: [
            { width: 200, targets: 0 },
            { width: 200, targets: 2 },
            { width: 30, targets: 3 },
            { width: 30, targets: 4 },
        ],
    });
    // table.column(5).visible(false);

    allGrn();

});


function allGrn() {
    $.ajax({
        type: "GET",
        url: "/sc/grnListController/allGrn",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {},
        success: function (response) {
            if (response.data.success) {
                var data = [];

                for (i = 0; i < response.data.result.length; i++) {
                    var id = response.data.result[i]['internal_id'];
                    var reference_no = response.data.result[i]['external_id'];
                    var name = response.data.result[i]['supplier'];
                    var designation = response.data.result[i]['trans_date'];
                    var status = response.data.result[i]['status'];
                    var string_id = "'" + id + "'";

                    var approve_icon = '';
                    var disabled = "";
                    if (status == 1) {
                        approve_icon = '<i class="fa fa-check-circle-o fa-3x text-success" aria-hidden="true"></i>';
                        disabled = "disabled";
                    } else if (status == 2) {
                        approve_icon = '<i class="fa fa-times-circle-o fa-3x text-danger" aria-hidden="true"></i>';
                        disabled = "disabled";
                    }

                    data.push({
                        "reference_no": reference_no,
                        "supplier": name,
                        "date": designation,
                        "approve": `<button class="btn btn-success" onclick="change_status_confirmation('${id}', 1, 'Are you sure want to approve?')" ${disabled}>
                            Approve <i class="fa fa-pencil-square-o" aria-hidden="true"></i>
                        </button>`,
                        "approve_status": approve_icon,
                    });
                   
                }
                var table = $('#myTable').DataTable();
                table.clear();
                table.rows.add(data).draw();
            }
        },

        error: function (error) {
            console.log(error);
        },
        complete: function () {}
    });
}

function change_status_confirmation(id, status, msg) {
    swal({
        title: msg,
        //text: "Once deleted, you will not be able to recover this record!",
        icon: "warning",
        buttons: {
            yes: {
                text: "Yes",
                value: true,
                className: 'btn btn-danger',
            },
            no: {
                text: "No",
                value: false,
                className: 'btn btn-primary',
            }
        },

    })
        .then((willDelete) => {
            if (willDelete) {
                change_status(id, status);
            }
        });

}

function change_status(id, status) {

    $.ajax({
        type: "PUT",
        url: '/sc/grnHeaderController/change_status/' + id,
        data: {
            status: status,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
            // document.getElementById('btnApproveGrn').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                if (status == 1) {
                    toastr.success("GRN approved.");
                } else if (status == 2) {
                    toastr.success("GRN rejected.");
                }

            } else {
                showErrorMessage();
            }
            location.href = '/sc/grnApproval';
        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {}

    });
}
