
var action = "save";
var tableData = undefined;
var tableOther = undefined;
var PO_ID = undefined;
const TOKEN = Math.floor(Math.random() * 212345);
$(document).ready(function () {
    $('.status_btn').hide();

    $('#tblPOAttachment').DataTable({
        responsive: true,
        "order": [],
        "columns": [
            { "data": "file" },
            { "data": "view" },
            { "data": "download" },
            { "data": "delete" },
        ],
        columnDefs: [
            { width: 80, targets: 1 },
            { width: 80, targets: 2 },
            { width: 80, targets: 3 },
        ],
    });


    $('#btnAttachment').on('click', function () {
        $('#attachmentAddModal').modal('toggle');
        //showWarningMessage('Please save purchase order to before upload attachmnet...!');
    });




    $('#attachmnet_token').val(TOKEN);

    var supplierChooser = $('#supplierChooser').dataChooser({
        "columns": [
            { "data": "id" },
            { "data": "value0" },
        ],
        columnDefs: [
            { width: 200, targets: 0 },
            { width: 300, targets: 1 },
        ],
    });

    var supplier_data = allSuppliers();
    console.log(supplier_data);
    supplierChooser.setDataSource(supplier_data);


    supplierChooser.on('select', function (event, data) {
        $('#txtSupplier').val(data[1]);
        $('#txtSupplier').attr("data-id", data[0]);
        var input = supplierChooser.getInput();
        input.focus();
    });




    var productChooser = $('#productChooser').dataChooser({
        "columns": [
            { "data": "id" },
            { "data": "value0" },
            { "data": "value1" },
        ],
        columnDefs: [
            { width: 50, targets: 0 },
            { width: 200, targets: 1 },
            { width: 300, targets: 2 },
        ],
    });

    var product_data = allProduct();
    console.log(product_data);
    productChooser.setDataSource(product_data);




    tableData = $('#tblData').transactionTable({
        thead: ['ProductPrimaryID', 'ProductID', 'Product Name', 'Unit', 'Qty', 'Price', 'Discount', 'Value', 'Remove'],
        data_chooser: [{ 'col': 2 }],
        chooser: productChooser,
        //column_def: { 0: 100 },
        auto_focus: 2,
        row_type: [
            { 'type': 'string', 'value': '', 'align': 'left', 'width': '100px' },
            { 'type': 'string', 'value': '', 'align': 'left', 'width': '100px' },
            { 'type': 'text', 'value': '', 'align': 'left', 'width': '100%' },
            {
                'type': 'select', 'value': [], 'align': 'left', 'width': '100px'
            },
            { 'type': 'text', 'value': '', 'align': 'right', 'width': '100px' },
            { 'type': 'text', 'value': '', 'align': 'right', 'width': '100px' },
            { 'type': 'text', 'value': '0', 'align': 'right', 'width': '100px' },
            { 'type': 'string', 'value': '', 'align': 'right', 'width': '100px' },
            { 'type': 'remove', 'value': 'X', 'align': 'center', 'width': '50px' }],
    });




    productChooser.on('select', function (event, data) {
        var selected_row = tableData.getSelectedRow();
        var cells = selected_row.getElementsByTagName('td');
        cells[0].childNodes[0].value = data[0];
        cells[1].childNodes[0].value = data[1];
        cells[2].childNodes[0].value = data[2];
        var input = productChooser.getInput();
        input.focus();

        var product_id = data[0];
        var uom = getProduct_Uom(product_id);
        $('#' + cells[3].childNodes[0].id).empty();
        $('#' + cells[3].childNodes[0].id).append('<option value="' + uom.id + '">' + uom.value + '</option>');
    });






    tableOther = $('#tblOther').transactionTable({
        thead: ['', 'Description', 'Quantity', 'Price', 'Discount', 'Value', 'Remove'],
        //data_chooser: [{ 'col': 1 }],
        //chooser : supplerChooser,
        //column_def: { 1: 200, 2: 200 },
        auto_focus: 0,
        row_type: [
            { 'type': 'text', 'value': '', 'align': 'left', 'width': '100%' },
            { 'type': 'text', 'value': '', 'align': 'left', 'width': '100%' },
            { 'type': 'text', 'value': '', 'align': 'right', 'width': '100px' },
            { 'type': 'text', 'value': '', 'align': 'right', 'width': '100px' },
            { 'type': 'text', 'value': '0', 'align': 'right', 'width': '100px' },
            { 'type': 'string', 'value': '', 'align': 'right', 'width': '100px' },
            { 'type': 'remove', 'value': 'X', 'align': 'center', 'width': '50px' }],
    });


    $('input[name="trans_date"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });


    $('input[name="deliverBeforeDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });

    //allEmployees();
    allDepartment();
    allStores();
    allPayTerms();
    allOrderType();
    allCurrency();
    newReferanceID($('#cmbStores').val());




    $('#cmbMiType').on('change', function () {
        if ($(this).val() == 1) {
            $('#cmbManufacturingOrder').prop("disabled", false);
            allManufacturingOrder();
        } else {
            $('#cmbManufacturingOrder').prop("disabled", true);
            $('#cmbManufacturingOrder').empty();
        }
    });



    $('#btnSave').on('click', function () {


        if ($(this).text() == 'Save') {
            savePurchaseOrderHeader();
        } else {
            updatePurchaseOrderHeader();
        }
    });




    if (window.location.search.length > 0) {
        var sPageURL = window.location.search.substring(1);
        var param = sPageURL.split('?');
        var id = param[0].split('=')[1].split('&')[0];
        action = param[0].split('=')[2].split('&')[0];
        PO_ID = id;
        getPurchaseOrder(id);
        if (action == 'edit') {
            $('#btnSave').text('Update');
            $('.status_btn').hide();
        } else if (action == 'view') {
            $('#btnSave').hide();
            $('.status_btn').show();
        }

    } else {
        tableData.add_empty_row();
        tableOther.add_empty_row();
    }

    var mrChooser = $('#mrChooser').dataChooser({
        "columns": [
            { "data": "reference" },
            { "data": "request" },
            { "data": "date" },
        ],
        columnDefs: [
            { width: 100, targets: 0 },
            { width: 300, targets: 1 },
            { width: 100, targets: 2 },
        ],
    });

    var mi_data = all_PR();
    mrChooser.setDataSource(mi_data);

    $('#txt_pr_id').on('input', function () {
        mrChooser.showChooser($(this));
    });

    mrChooser.on('select', function (event, data) {
        getPurchaseRequest(data[0]);
        $('#txt_pr_id').val(data[0]);
        $('#txt_pr_id').attr("data-id", data[0]);
        var input = mrChooser.getInput();
        input.focus();
    });
   


    $('#txtSupplier').on('input', function () {
        supplierChooser.showChooser($('#txtSupplier'));
    });


    $('#txtDiscountPresentage').on('input', function () {
        overallCalculation();
    });


    $('#cmbCurrency').on('change', function () {
        if ($(this).val() == 1) {//SLR
            $('#txtExchangeRate').val(1);
            $('#txtExchangeRate').prop("disabled", true);
        } else {
            $('#txtExchangeRate').val(0);
            $('#txtExchangeRate').prop("disabled", false);
        }
    });


    $('#cmbStores').on('change', function () {
        newReferanceID($(this).val());
    });

    $('#btnApprove').on('click', function () {
        change_status_confirmation(PO_ID, 1, "Are you sure want to approve?");
    });
    $('#btnReject').on('click', function () {
        change_status_confirmation(PO_ID, 2, "Are you sure want to reject?");
    });


});


Dropzone.options.myDropzone = {
    dictDefaultMessage: 'Drop file here or click to upload!!!!!!!!',
    addRemoveLinks: true,
    init: function () {
        this.on("complete", function (file) {
            allAttachment(1, TOKEN);
        });
    }
};

function all_PR() {
    var grn_data = [];
    $.ajax({
        type: "GET",
        url: "/sc/purchaseRequestListController/allPr",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            grn_data = response.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });

    return grn_data;
}

function getPurchaseRequest(id) {
    
    $.ajax({
        type: "GET",
        url: "/sc/perchaseRequestHeaderController/getPurchaseRequestByExternalID/" + id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            grn_id = res.internal_id
            referanceID = res.external_id;

            // $('#txtExternal_id').val(res.external_id);
            // $('#txtGrnDate').val(res.trans_date);
            // $('#txtGrnDate').prop('readonly', true);
            $('#txtGrnDate').prop('disabled', true);

            $('#txtSupplier').attr('data-id', res.supplier_id);
            $('#txtSupplier').val(res.supplier);
            //$('#txtRequestBy').attr("data-id", res.order_by);
            $('#txtOrderBy').val(res.employee_name);
            $('#txtOrderBy').prop('readonly', true);

            $('#txtRemarks').val(res.remarks);
            $('#txtDeliverBeforeDate').val(res.deliver_before);
            // $('#txtDiscountPresentage').val(parseFloat(res.discount_overall).toFixed(2));
            // $('#txtGrossValue').val(parseFloat(res.gross_value).toFixed(2));
            // $('#txtDiscount').val(parseFloat(res.discount).toFixed(2));
            // $('#txtNetValue').val(parseFloat(res.net_value).toFixed(2));
            if (!isNaN(parseFloat(res.exchange_rate).toFixed(2))) {
                $('#txtExchangeRate').val(parseFloat(res.exchange_rate).toFixed(2));
            }

            var mr_internal_id = res.mr_internal_id;
            var mr_extenal_id = res.mr_extenal_id;
            setSelectedOption('cmbStores', res.store_id);
            $('#cmbStores').prop('disabled', true);

            setSelectedOption('cmbPayTerm', res.pay_term_id);
            setSelectedOption('cmbOrderType', res.order_type_id);
            setSelectedOption('cmbCurrency', res.currency_id);

            if (res.currency_id == '1') {
                $('#txtExchangeRate').prop("disabled", true);
            }
            var request_data = res.request_data;
            tableData.clear();
            for (var i = 0; i < request_data.length; i++) {
                tableData.addRow(
                    [
                        { 'type': 'string', 'val': request_data[i].product_primary_id, 'align': 'left', 'width': '100px' },
                        { 'type': 'string', 'val': request_data[i].product_id, 'align': 'left', 'width': '100px' },
                        { 'type': 'text', 'val': request_data[i].product, 'align': 'left', 'width': '100p%' },
                        { 'type': 'select', 'val': request_data[i].uom, 'align': 'left', 'width': '100px'},
                        { 'type': 'text', 'val': request_data[i].quantity, 'align': 'right', 'width': '100px' },
                        { 'type': 'text', 'val': "", 'align': 'right', 'width': '100px' },
                        { 'type': 'text', 'val':0, 'align': 'right', 'width': '100px' },
                        { 'type': 'string', 'val': "", 'align': 'right', 'width': '100px' },
                        { 'type': 'remove', 'val': 'X', 'align': 'center', 'width': '50px' }]
                );
            }
            var request_other = res.request_other;
            console.log(request_other);
            tableOther.clear();
            for (var i = 0; i < request_other.length; i++) {
                tableOther.addRow(
                    [
                        { 'type': 'text', 'val': '', 'align': 'left', 'width': '100%' },
                        { 'type': 'text', 'val': request_other[i].description, 'align': 'left', 'width': '100%' },
                        { 'type': 'text', 'val': request_other[i].quantity, 'align': 'right', 'width': '100px' },
                        { 'type': 'text', 'val': 0, 'align': 'right', 'width': '100px' },
                        { 'type': 'text', 'val': 0, 'align': 'right', 'width': '100px' },
                        { 'type': 'string', 'val': 0, 'align': 'right', 'width': '100px' },
                        { 'type': 'remove', 'val': 'X', 'align': 'center', 'width': '50px' }]
                );
            }

            allAttachment(id, 0);
        },
        error: function (error) {
            console.log(error);
        },
        complete: function () {}
    });
}


/*function allUnit() {
    var data = [];
    $.ajax({
        type: "GET",
        url: "/sc/perchaseOrderController/allProductUnit",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response.data.result);
            for (var i = 0; i < response.data.result.length; i++) {
                data.push({ 'value': response.data.result[i].id, 'text': response.data.result[i].name });
            }

        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
    return data;
}*/




function allEmployees() {
    $.ajax({
        type: "GET",
        url: "/sc/perchaseOrderController/allEmployees",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            //$('#txtRequestBy').setData(res);
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}

function allDepartment() {
    $.ajax({
        type: "GET",
        url: "/sc/perchaseOrderController/allDepartment",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            var res = response.data.result;
            console.log(res);
            for (var i = 0; i < res.length; i++) {
                $('#cmbDepartment').append('<option value="' + res[i].id + '">' + res[i].department + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}

function allStores() {
    $.ajax({
        type: "GET",
        url: "/sc/perchaseOrderController/allStores",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            for (var i = 0; i < res.length; i++) {
                $('#cmbStores').append('<option value="' + res[i].id + '">' + res[i].name + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}

function allPayTerms() {
    $.ajax({
        type: "GET",
        url: "/sc/perchaseOrderController/allPayTerms",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            for (var i = 0; i < res.length; i++) {
                $('#cmbPayTerm').append('<option value="' + res[i].pay_term_id + '">' + res[i].pay_term + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}

function allOrderType() {
    $.ajax({
        type: "GET",
        url: "/sc/perchaseOrderController/allOrderType",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            for (var i = 0; i < res.length; i++) {
                $('#cmbOrderType').append('<option value="' + res[i].order_type_id + '">' + res[i].order_type + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}

function allCurrency() {
    $.ajax({
        type: "GET",
        url: "/sc/perchaseOrderController/allCurrency",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            $('#cmbCurrency').append('<option selected="true" disabled="disabled">-- Select Currency --</option>');
            for (var i = 0; i < res.length; i++) {
                $('#cmbCurrency').append('<option value="' + res[i].currency_id + '">' + res[i].currency + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}

function newReferanceID(storeID) {
    var referanceID = newID("/sc/ReferenceIDController/purchaseOrderMaxID", storeID);
    $('#txtExternal_id').val(referanceID);
}


function allManufacturingOrder() {
    $.ajax({
        type: "GET",
        url: "/sc/perchaseOrderController/allProductCustomer",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            for (var i = 0; i < res.length; i++) {
                $('#cmbManufacturingOrder').append('<option value="' + res[i].customer_order_plan_id + '">' + res[i].manufacturing_order_number + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}

function allProduct() {
    var product_data = [];
    $.ajax({
        type: "GET",
        url: "/sc/perchaseOrderController/allProduct",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            product_data = response.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });

    return product_data;
}

function allSuppliers() {
    var supplier_data = [];
    $.ajax({
        type: "GET",
        url: "/sc/grnHeaderController/allSuppliers",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            supplier_data = response.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
    return supplier_data;
}

function savePurchaseOrderHeader() {

    newReferanceID($('#cmbStores').val());
    if ($('#txtSupplier').attr("data-id") == '' || $('#txtSupplier').val() == '') {
        showWarningMessage("Please Select Supplier");
        return;
    }
    if ($('#txtOrderBy').val() == '') {
        showWarningMessage("Please Enter Order By");
        return;
    }
    if (!$('#cmbCurrency').val()) {
        showWarningMessage("Please Select Currency");
        return;
    }

    if (isNaN(parseFloat($('#txtDiscountPresentage').val()))) {
        $('#txtDiscountPresentage').val('0.0');
    }

    var order_data = {};
    var order_data_arr = tableData.dataSource();
    if (order_data_arr.length == 0) {
        showWarningMessage("Invalied Purchase order (Empty list)");
        return;
    }
    for (var i = 0; i < order_data_arr.length; i++) {
        if (!order_data_arr[i][0]) {
            showWarningMessage("You shuld fill empty row in The list");
            return;
        }
        if (!order_data_arr[i][3]) {
            showWarningMessage(order_data_arr[i][1] + " Invalied Quantity");
            return;
        }
        if (!order_data_arr[i][4]) {
            showWarningMessage(order_data_arr[i][1] + " Invalied Price");
            return;
        }
        if (!order_data_arr[i][5]) {
            showWarningMessage(order_data_arr[i][1] + " Invalied Discount");
            return;
        }
        order_data[i] = { "product_id": order_data_arr[i][0], "product_name": order_data_arr[i][2], "unit_id": order_data_arr[i][3], "qty": order_data_arr[i][4], "price": order_data_arr[i][5], "discount": order_data_arr[i][6], "value": order_data_arr[i][7], };
    }
    var order_other = {};
    var order_other_arr = tableOther.dataSource();
    for (var i = 0; i < order_other_arr.length; i++) {
        order_other[i] = { "description": order_other_arr[i][1], "quantity": order_other_arr[i][2], "price": order_other_arr[i][3], "discount": order_other_arr[i][4], "value": order_other_arr[i][5], };
    }

    $.ajax({
        type: "POST",
        url: '/sc/perchaseOrderController/save',
        data: {
            'external_id': $('#txtExternal_id').val(),
            'ref_external_id': $('#txtExternal_id').val(),
            'trans_date': $('#txtGrnDate').val(),
            'supplier_id': $('#txtSupplier').attr('data-id'),
            'store_id': $('#cmbStores').val(),
            'order_by': $('#txtOrderBy').val(),
            'mr_internal_id': '0',
            'mr_extenal_id': '0',
            'remarks': $('#txtRemarks').val(),
            'deliver_before': $('#txtDeliverBeforeDate').val(),
            'pay_term': $('#cmbPayTerm').val(),
            'order_type': $('#cmbOrderType').val(),
            'discount_overall': $('#txtDiscountPresentage').val(),
            'gross_value': $('#txtGrossValue').val(),
            'discount': $('#txtDiscount').val(),
            'net_value': $('#txtNetValue').val(),
            'currency': $('#cmbCurrency').val(),
            'exchange_rate': $('#txtExchangeRate').val(),
            'project_code': $('#cmbProjectCode').val(),
            'purchase_request_no': $('#txt_pr_id').val(),
            'attachment_token': TOKEN,
            'order_data': order_data,
            'order_other': order_other,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                toastr.success('data saved');
                location.href = '/sc/PurchaseOrder';
            } else {
                showErrorMessage();
            }


        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}



function getPurchaseOrder(id) {
    $.ajax({
        type: "GET",
        url: "/sc/perchaseOrderController/getPurchaseOrder/" + id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            grn_id = res.internal_id
            referanceID = res.external_id;

            $('#txtExternal_id').val(res.external_id);
            $('#txtGrnDate').val(res.trans_date);
            $('#txtSupplier').attr('data-id', res.supplier_id);
            $('#txtSupplier').val(res.supplier);
            //$('#txtRequestBy').attr("data-id", res.order_by);
            $('#txtOrderBy').val(res.employee_name);
            $('#txtRemarks').val(res.remarks);
            $('#txtDeliverBeforeDate').val(res.deliver_before);
            $('#txtDiscountPresentage').val(parseFloat(res.discount_overall).toFixed(2));
            $('#txtGrossValue').val(parseFloat(res.gross_value).toFixed(2));
            $('#txtDiscount').val(parseFloat(res.discount).toFixed(2));
            $('#txtNetValue').val(parseFloat(res.net_value).toFixed(2));
            if (!isNaN(parseFloat(res.exchange_rate).toFixed(2))) {
                $('#txtExchangeRate').val(parseFloat(res.exchange_rate).toFixed(2));
            }

            var mr_internal_id = res.mr_internal_id;
            var mr_extenal_id = res.mr_extenal_id;
            setSelectedOption('cmbStores', res.store_id);
            setSelectedOption('cmbPayTerm', res.pay_term_id);
            setSelectedOption('cmbOrderType', res.order_type_id);
            setSelectedOption('cmbCurrency', res.currency_id);

            if (res.currency_id == '1') {
                $('#txtExchangeRate').prop("disabled", true);
            }

            var request_data = res.request_data;

            for (var i = 0; i < request_data.length; i++) {
                tableData.addRow(
                    [
                        { 'type': 'string', 'val': request_data[i].product_primary_id, 'align': 'left', 'width': '100px' },
                        { 'type': 'string', 'val': request_data[i].product_id, 'align': 'left', 'width': '100px' },
                        { 'type': 'text', 'val': request_data[i].product, 'align': 'left', 'width': '100p%' },
                        { 'type': 'select', 'val': request_data[i].uom, 'align': 'left', 'width': '100px'},
                        { 'type': 'text', 'val': request_data[i].quantity, 'align': 'right', 'width': '100px' },
                        { 'type': 'text', 'val': request_data[i].price, 'align': 'right', 'width': '100px' },
                        { 'type': 'text', 'val': request_data[i].discount, 'align': 'right', 'width': '100px' },
                        { 'type': 'string', 'val': request_data[i].value, 'align': 'right', 'width': '100px' },
                        { 'type': 'remove', 'val': 'X', 'align': 'center', 'width': '50px' }]
                );
            }

            var request_other = res.request_other;
            console.log(request_other);
            for (var i = 0; i < request_other.length; i++) {
                tableOther.addRow(
                    [
                        { 'type': 'text', 'val': '', 'align': 'left', 'width': '100%' },
                        { 'type': 'text', 'val': request_other[i].description, 'align': 'left', 'width': '100%' },
                        { 'type': 'text', 'val': request_other[i].quantity, 'align': 'right', 'width': '100px' },
                        { 'type': 'text', 'val': request_other[i].price, 'align': 'right', 'width': '100px' },
                        { 'type': 'text', 'val': request_other[i].discount, 'align': 'right', 'width': '100px' },
                        { 'type': 'string', 'val': request_other[i].value, 'align': 'right', 'width': '100px' },
                        { 'type': 'remove', 'val': 'X', 'align': 'center', 'width': '50px' }]
                );
            }

            allAttachment(id, 0);
        },
        error: function (error) {
            console.log(error);
        },
        complete: function () {}
    });
}





function updatePurchaseOrderHeader() {

    if ($('#txtSupplier').attr("data-id") == '' || $('#txtSupplier').val() == '') {
        showWarningMessage("Please Select Supplier");
        return;
    }
    if ($('#txtOrderBy').val() == '') {
        showWarningMessage("Please Enter Order By");
        return;
    }
    if (!$('#cmbCurrency').val()) {
        showWarningMessage("Please Select Currency");
        return;
    }
    if (isNaN(parseFloat($('#txtDiscountPresentage').val()))) {
        $('#txtDiscountPresentage').val('0.0');
    }

    var order_data = {};
    var order_data_arr = tableData.dataSource();
    if (order_data_arr.length == 0) {
        showWarningMessage("Invalied Purchase order (Empty list)");
        return;
    }
    for (var i = 0; i < order_data_arr.length; i++) {
        if (!order_data_arr[i][0]) {
            showWarningMessage("You shuld fill empty row in The list");
            return;
        }
        if (!order_data_arr[i][3]) {
            showWarningMessage(order_data_arr[i][1] + " Invalied Quantity");
            return;
        }
        if (!order_data_arr[i][4]) {
            showWarningMessage(order_data_arr[i][1] + " Invalied Price");
            return;
        }
        if (!order_data_arr[i][5]) {
            showWarningMessage(order_data_arr[i][1] + " Invalied Discount");
            return;
        }
        order_data[i] = { "product_id": order_data_arr[i][0], "product_name": order_data_arr[i][2], "unit_id": order_data_arr[i][3], "qty": order_data_arr[i][4], "price": order_data_arr[i][5], "discount": order_data_arr[i][6], "value": order_data_arr[i][7], };
    }
    var order_other = {};
    var order_other_arr = tableOther.dataSource();
    for (var i = 0; i < order_other_arr.length; i++) {
        order_other[i] = { "description": order_other_arr[i][1], "quantity": order_other_arr[i][2], "price": order_other_arr[i][3], "discount": order_other_arr[i][4], "value": order_other_arr[i][5], };
    }

    $.ajax({
        type: "PUT",
        url: '/sc/perchaseOrderController/update/' + grn_id,
        data: {
            'external_id': $('#txtExternal_id').val(),
            'ref_external_id': $('#txtExternal_id').val(),
            'trans_date': $('#txtGrnDate').val(),
            'supplier_id': $('#txtSupplier').attr('data-id'),
            'store_id': $('#cmbStores').val(),
            'order_by': $('#txtOrderBy').val(),
            'mr_internal_id': '0',
            'mr_extenal_id': '0',
            'remarks': $('#txtRemarks').val(),
            'deliver_before': $('#txtDeliverBeforeDate').val(),
            'pay_term': $('#cmbPayTerm').val(),
            'order_type': $('#cmbOrderType').val(),
            'discount_overall': $('#txtDiscountPresentage').val(),
            'gross_value': $('#txtGrossValue').val(),
            'discount': $('#txtDiscount').val(),
            'net_value': $('#txtNetValue').val(),
            'currency': $('#cmbCurrency').val(),
            'exchange_rate': $('#txtExchangeRate').val(),
            'attachment_token': TOKEN,
            'order_data': order_data,
            'order_other': order_other,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                toastr.success('data updated');
                location.href = '/sc/PurchaseOrderList';
            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}





function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}


function triggerRowInputs(id, selected_row) {



    if (id == "tblOther") {
        var cells = selected_row.getElementsByTagName('td');
        var quantity = $('#' + cells[2].childNodes[0].id);
        var price = $('#' + cells[3].childNodes[0].id);
        var discount = $('#' + cells[4].childNodes[0].id);
        var value = $('#' + cells[5].childNodes[0].id);
        quantity.on('input', function () {
            var qty = parseFloat(quantity.val());
            var prc = parseFloat(price.val());
            var disc = parseFloat(discount.val());
            var amount = (qty * prc);
            var disc_amount = (amount * disc) / 100.0;
            var val = (amount - disc_amount);
            if (!isNaN(val)) {
                value.val(val);
            }
            overallCalculation();

        });
        price.on('input', function () {
            var qty = parseFloat(quantity.val());
            var prc = parseFloat(price.val());
            var disc = parseFloat(discount.val());
            var amount = (qty * prc);
            var disc_amount = (amount * disc) / 100.0;
            var val = (amount - disc_amount);
            if (!isNaN(val)) {
                value.val(val);
            }
            overallCalculation();
        });
        discount.on('input', function () {
            var qty = parseFloat(quantity.val());
            var prc = parseFloat(price.val());
            var disc = parseFloat(discount.val());
            var amount = (qty * prc);
            var disc_amount = (amount * disc) / 100.0;
            var val = (amount - disc_amount);
            if (!isNaN(val)) {
                value.val(val);
            }
            overallCalculation();
        });
    } else if (id == "tblData") {
        var cells = selected_row.getElementsByTagName('td');
        var quantity = $('#' + cells[4].childNodes[0].id);
        var price = $('#' + cells[5].childNodes[0].id);
        var discount = $('#' + cells[6].childNodes[0].id);
        var value = $('#' + cells[7].childNodes[0].id);
        quantity.on('input', function () {
            var qty = parseFloat(quantity.val());
            var prc = parseFloat(price.val());
            var disc = parseFloat(discount.val());
            var amount = (qty * prc);
            var disc_amount = (amount * disc) / 100.0;
            var val = (amount - disc_amount);
            if (!isNaN(val)) {
                value.val(val);
            }

            overallCalculation();
        });
        price.on('input', function () {
            var qty = parseFloat(quantity.val());
            var prc = parseFloat(price.val());
            var disc = parseFloat(discount.val());
            var amount = (qty * prc);
            var disc_amount = (amount * disc) / 100.0;
            var val = (amount - disc_amount);
            if (!isNaN(val)) {
                value.val(val);
            }
            overallCalculation();
        });
        discount.on('input', function () {
            var qty = parseFloat(quantity.val());
            var prc = parseFloat(price.val());
            var disc = parseFloat(discount.val());
            var amount = (qty * prc);
            var disc_amount = (amount * disc) / 100.0;
            var val = (amount - disc_amount);
            if (!isNaN(val)) {
                value.val(val);
            }
            overallCalculation();
        });
    }




}


function overallCalculation() {

    var gross_value = 0.0;
    var discount_value = 0.0;
    var net_value = 0.0;
    var discount_header = parseFloat($('#txtDiscountPresentage').val());
    if (isNaN(discount_header)) {
        discount_header = 0;
        //$('#txtDiscountPresentage').val(parseFloat(discount_header).toFixed(2));
    }
    $('#tblData tr').each(function () {
        var qty = parseFloat($(this).find("td").eq(4).children().val());
        var price = parseFloat($(this).find("td").eq(5).children().val());
        var discount = parseFloat($(this).find("td").eq(6).children().val());

        if (!isNaN(qty) && !isNaN(price)) {
            gross_value += (qty * price);
        }

        if (!isNaN(qty) && !isNaN(price) && !isNaN(discount)) {
            discount_value += ((qty * price) * discount) / 100.0;
        }


    });
    $('#tblOther tr').each(function () {
        var qty = parseFloat($(this).find("td").eq(2).children().val());
        var price = parseFloat($(this).find("td").eq(3).children().val());
        var discount = parseFloat($(this).find("td").eq(4).children().val());

        if (!isNaN(qty) && !isNaN(price)) {
            gross_value += (qty * price);
        }

        if (!isNaN(qty) && !isNaN(price) && !isNaN(discount)) {
            discount_value += ((qty * price) * discount) / 100.0;
        }


    });
    if (!isNaN(gross_value)) {
        $('#txtGrossValue').val(parseFloat(gross_value).toFixed(2));
    }

    if (!isNaN(gross_value) && !isNaN(discount_value)) {
        var net_val = parseFloat(gross_value - discount_value);
        var dis = (net_val * discount_header) / 100.0;

        $('#txtDiscount').val(parseFloat(discount_value + dis).toFixed(2));
        $('#txtNetValue').val(parseFloat(net_val - dis).toFixed(2));
    }


}



function transactionTableUpdate(table_id) { // override function from transaction_table.js
    overallCalculation();
}



function getProduct_Uom(id) {
    var unit = undefined;
    $.ajax({
        type: "GET",
        url: "/sc/perchaseOrderController/getUom/" + id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            unit = response.data.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
    return unit;
}



function allAttachment(purchase_order_id, token) {
    $.ajax({
        type: "GET",
        url: "/sc/perchaseOrderController/allAttachment/" + purchase_order_id + "/" + token,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                var result = response.data.result;
                var data = [];
                for (var i = 0; i < result.length; i++) {
                    var path = "'" + result[i].path + "'";
                    var id = "'" + result[i].purchase_order_attachment_id + "'";
                    data.push({
                        "file": result[i].path,
                        "view": '<button type= "button" class="btn btn-primary" onclick="viewAttachment(' + path + ');"><i class="fa fa-eye" aria-hidden="true"></i></button> ',
                        "download": '<button type= "button" class="btn btn-success" onclick="downloadAttachment(' + path + ');"><i class="fa fa-download" aria-hidden="true"></i></button> ',
                        "delete": '<button type= "button" class="btn btn-danger" onclick="deleteAttachment(' + id + ');"><i class="fa fa-trash" aria-hidden="true"></i></button> ',
                    });
                }
                var table = $('#tblPOAttachment').DataTable();
                //table.clear();
                table.rows.add(data).draw();
            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);

        },

    });
}


function viewAttachment(file) {
    window.open('/purchase_order/' + file);

}


function downloadAttachment(file) {
    var link = document.createElement("a");
    link.download = file;
    link.href = "/purchase_order/" + file;
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
    delete link;
}




function change_status_confirmation(id, status, msg) {
    swal({
        title: msg,
        //text: "Once deleted, you will not be able to recover this record!",
        icon: "warning",
        buttons: {
            yes: {
                text: "Yes",
                value: true,
                className: 'btn btn-danger',
            },
            no: {
                text: "No",
                value: false,
                className: 'btn btn-primary',
            }
        },

    })
        .then((willDelete) => {
            if (willDelete) {
                change_status(id, status);
            }
        });

}

function change_status(id, status) {

    $.ajax({
        type: "PUT",
        url: '/sc/purchaseOrderListController/change_status/' + id,
        data: {
            status: status,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
            // document.getElementById('btnApproveGrn').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                if (status == 1) {
                    toastr.success("Purchase Order approved.");
                } else if (status == 2) {
                    toastr.success("Purchase Order rejected.");
                }

            } else {
                showErrorMessage();
            }
            location.href = '/sc/PurchaseOrderList';
        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
            // document.getElementById('approve'+id).innerHTML = '<i class="fa fa-times" aria-hidden="true"></i>';
        }

    });
}



/**
* generateID
* This function is used to generate id
* @param id This is the paramter to require id
*/
function generateID(id) {

    let pattern = {
        1: "0000",
        2: "000",
        3: "00",
        4: "0",
    };
    var length = Math.ceil(Math.log(id + 1) / Math.LN10);
    return pattern[length] + id;
}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}