<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMaterialRequisitionHeadersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sc_material_requisition_headers', function (Blueprint $table) {
            $table->id('internal_id');
            $table->string('external_id', 100);
            $table->string('ref_internal_id', 100);
            $table->string('ref_external_id', 100);
            $table->date('trans_date');
            $table->integer('dept_id');
            $table->integer('machine_id')->nullable();
            $table->integer('store_id');
            $table->integer('supervisor_id');
            $table->string('employee_name',100);
            $table->integer('mi_type');
            $table->integer('customer_order_plan_data_id')->nullable();
            $table->string('manufacturing_order_number', 100)->nullable();
            $table->string('vehicle_no', 45)->nullable();
            $table->integer('material_request_reason_id');
            $table->string('project_code', 100)->nullable();
            $table->string('remarks', 200)->nullable();
            $table->integer('status');
            $table->integer('user_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('material_requisition_headers');
    }
}
