<?php

namespace Modules\Sc\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class DocumentNumber extends Model
{
    use HasFactory,LogsActivity;
    protected $table = 'document_numbers';
    protected $primaryKey = 'document_number_id';
    protected $fillable = [];
    protected static $logAttributes = [
        'document_number_id',
        'document_number',
        'name',
        'prefix',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "document_numbers";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
 
}
