<?php

namespace Modules\Sc\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class GoodsTransferData extends Model
{
    use HasFactory,LogsActivity;

    protected $fillable = [];
    protected $table = 'sc_goods_transfer_data';
    protected $primaryKey = 'internal_id';
    protected static $logAttributes = [
        'goods_transfer_data_id',
        'internal_id',
        'external_id',
        'product_id',
        'unit_id',
        'quantity',
        'comments',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "sc_goods_transfer_data";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
