<?php

namespace Modules\Sc\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class GoodsTransferDataMR extends Model
{
    use HasFactory,LogsActivity;
    protected $table = 'sc_goods_transfer_data_m_rs';
    protected $primaryKey = 'goods_transfer_data_mr_id';
    protected $fillable = [];
    protected static $logAttributes = [
        'goods_transfer_data_mr_id',
        'internal_id',
        'external_id',
        'product_id',
        'unit_id',
        'quantity',
        'comments',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "sc_goods_transfer_data_m_rs";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
    
    /*protected static function newFactory()
    {
        return \Modules\Sc\Database\factories\GoodsTransferDataMRFactory::new();
    }*/
}
