<?php

namespace Modules\Sc\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class PayTerm extends Model
{
    use HasFactory, LogsActivity;
    protected $table = 'sc_pay_terms';
    protected $primaryKey = 'pay_term_id';
    protected $fillable = [];
    protected static $logAttributes = [
        'pay_term_id',
        'pay_term',
        'status',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "sc_pay_terms";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
    /*protected static function newFactory()
    {
        return \Modules\Sc\Database\factories\PayTermFactory::new();
    }*/
}
