<?php

namespace Modules\Sc\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class ProductHistory extends Model
{
    use HasFactory,LogsActivity;
    protected $table = 'sc_product_histories';
    protected $primaryKey = 'transaction_id';
    protected $fillable = [];
    protected static $logAttributes = [
        'transaction_id',
        'internal_id',
        'external_id',
        'document_no',
        'description',
        'product_id',
        'unit_id',
        'quantity',
        'set_off',
        'cost_price',
        'store_id',
        'user_id',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "sc_product_histories";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
    /*protected static function newFactory()
    {
        return \Modules\Sc\Database\factories\ProductHistoryFactory::new();
    }*/
}
