<?php

namespace Modules\Sc\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class StoreLocation extends Model
{
    use HasFactory, LogsActivity;
    protected $table = 'sc_store_locations';
    protected $fillable = [];
    protected static $logAttributes = [
        'id',
        'name',
        'prefix',
        'site_id',
        'store_code',
        'status',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "sc_store_locations";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
    /*protected static function newFactory()
    {
        return \Modules\Sc\Database\factories\StoreLocationFactory::new();
    }*/
}
