<?php

namespace Modules\Sc\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Sc\Entities\GoodsReceivedMr;

class GoodsReceivedMrListController extends Controller
{


    public function allGoodsReceivedMR()
    {
        try {
            $gr_mr =  DB::select('SELECT sc_goods_received_mrs.internal_id,sc_goods_received_mrs.refferance_no,sc_goods_received_mrs.status,
            st_suppliers.supplier_name,
            sc_goods_received_mrs.trans_date,
            st_products.product_name,
            sc_goods_received_mrs.wastage
            FROM sc_goods_received_mrs INNER JOIN st_suppliers ON sc_goods_received_mrs.supplier_id = st_suppliers.supplier_id
            INNER JOIN st_products ON sc_goods_received_mrs.product_primary_id = st_products.product_primary_id  ORDER BY sc_goods_received_mrs.internal_id DESC');
            $responseBody = $this->responseBody(true, "GoodsReceivedMrListController", "allGoodsReceivedMR", $gr_mr);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsReceivedMrListController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function delete($id)
    {
        try {
            $gr_mr = GoodsReceivedMr::find($id);
            if ($gr_mr) {
                $gr_mr->delete();
            }
            $responseBody = $this->responseBody(true, "GoodsReceivedMrListController", "delete", true);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsReceivedMrListController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }









    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
