<?php

namespace Modules\Sc\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\Employee;
use Modules\PJ\Entities\Project;
use Modules\Pp\Entities\CustomerPlan;
use Modules\Pp\Entities\Machinary;
use Modules\Sc\Entities\Department;
use Modules\Sc\Entities\DocumentNumber;
use Modules\Sc\Entities\GrnData;
use Modules\Sc\Entities\GrnHeader;
use Modules\Sc\Entities\MiData;
use Modules\Sc\Entities\MiHeader;
use Modules\Sc\Entities\ProductHistory;
use Modules\Sc\Entities\ProductHistorySetoff;
use Modules\Sc\Entities\StoreLocation;
use Modules\St\Entities\Product;
use Modules\St\Entities\ProductUnit;
use Modules\St\Entities\Uom;

class MaterialReturnController extends Controller
{




    public function allEmployees()
    {
        try {
            $employees = Employee::all();
            $result = array();
            foreach ($employees as $emp) {
                array_push($result, [
                    "img" => "",
                    "id" => $emp->employee_id,
                    "value" => $emp->name_withinitial,
                ]);
            }
            $responseBody = $this->responseBody(true, "MaterialReturnController", "allEmployees", $result);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialReturnController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function allDepartment()
    {
        try {
            $department =  Department::all();
            $responseBody = $this->responseBody(true, "MaterialReturnController", "allDepartment", $department);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialReturnController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function allMachinery()
    {
        try {
            $machinery =  Machinary::all();
            $responseBody = $this->responseBody(true, "MaterialReturnController", "allMachinery", $machinery);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialReturnController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function allProduct()
    {
        try {
            $products =  Product::select('product_primary_id As id', 'product_id As value0', 'product_name As value1')->get();
            return $this->responseBody(true, "GrnReturnController", "allProduct", $products);
        } catch (Exception $exception) {
            return $this->responseBody(false, "GrnReturnController", "error", $exception);
        }
    }


    public function allProjects()
    {
        try {
            $projects = Project::all();
            $responseBody = $this->responseBody(true, "MaterialReturnController", "allProjects", $projects);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialReturnController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    public function maxID($store_id)
    {
        try {
            $id = DB::select('SELECT AUTO_INCREMENT  AS id FROM information_schema.TABLES WHERE TABLE_SCHEMA = "erp_riococo_salary3" AND TABLE_NAME = "sc_grn_headers"')[0]->id;
            $store = StoreLocation::find($store_id);
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
            }
            $responseBody = $this->responseBody(true, "MaterialReturnController", "allProductUnit", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialReturnController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function allProductUnit()
    {
        try {
            $products =  ProductUnit::all();
            $responseBody = $this->responseBody(true, "MaterialReturnController", "allProductUnit", $products);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialReturnController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    public function allStores()
    {
        try {
            $stores =  StoreLocation::all();
            $responseBody = $this->responseBody(true, "MaterialReturnController", "allStores", $stores);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialReturnController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function allProductCustomer()
    {
        try {
            $orderPlan =  CustomerPlan::all();
            $responseBody = $this->responseBody(true, "MaterialReturnController", "allProductCustomer", $orderPlan);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialReturnController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function allMi()
    {
        try {
            $miheader =  MiHeader::where('status', '=', 1)->get();
            foreach ($miheader as $mi) {
                $supervisor = Employee::find($mi->supervisor_id);
                $mi->id = $mi->external_id;
                $mi->value0 = $mi->employee_name;
                $mi->value1 = "0";
            }
            return $this->responseBody(true, "MaterialReturnController", "allMi", $miheader);
        } catch (Exception $exception) {
            return $this->responseBody(false, "MaterialReturnController", "error", $exception);
        }
    }


    public function getMaterialIssue($id)
    {

        try {
            $material_issue = MiHeader::where('external_id', '=', $id)->first();
            //$supervisor = Employee::find($material_issue->supervisor_id);
            //$material_issue->supervisor = $supervisor->name_withinitial;
            //$material_issue->supervisor_id = $supervisor->employee_id;
            $grn_data = MiData::where('internal_id', '=', $material_issue->internal_id)->get();
            foreach ($grn_data as $data) {
                $product = Product::find($data->product_id);
                $data->product = $product->product_name;
                $uom = ProductUnit::find($product->uom_id);
                $uom_arr = [];
                if ($uom) {
                    array_push($uom_arr, ["value" => $uom->id, "text" => $uom->name]);
                }
                $data->uom = $uom_arr;
                $data->product_primary_id = $product->product_primary_id;
                $data->product_id = $product->product_id;
                //$product_history = ProductHistory::where([['internal_id', '=', $material_issue->internal_id], ['product_id', '=', $data->product_id]])->first();
                //$data->quantity = ($product_history->quantity - $product_history->set_off);
            }
            $material_issue->data = $grn_data;
            $responseBody = $this->responseBody(true, "MaterialReturnController", "getMaterialIssue", $material_issue);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialReturnController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function getQty($product_id, $store_id)
    {
        try {
            $query = "SELECT ABS(SUM(quantity)) AS quantity FROM sc_product_histories WHERE product_id = '" . $product_id . "' AND document_no = '200' AND store_id = '" . $store_id . "'";
            $result = DB::select($query);
            $quantity = 0;
            foreach ($result as $data) {
                if ($data->quantity) {
                    $quantity = $data->quantity;
                }
            }
            $responseBody = $this->responseBody(true, "MaterialReturnController", "getQty", $quantity);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialReturnController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }





    public function save(Request $request)
    {
        try {
            $return_arr = $request->get("return_data");
            $this->removeProductHistory($request->get('internal_id'));
            $this->removeProductFromSetoff($request->get('internal_id'));
            for ($i = 0; $i < count($return_arr); $i++) {
                $returnData = json_decode($return_arr[$i]);

                $id = $request->get('internal_id');
                $query = "SELECT sc_mi_headers.store_id,sc_mi_headers.trans_date,sc_mi_data.*FROM sc_mi_data INNER JOIN sc_mi_headers
                ON sc_mi_data.internal_id = sc_mi_headers.internal_id WHERE sc_mi_data.internal_id = '" . $id . "' AND sc_mi_data.product_id = '" . $returnData->product_id . "'";

                $result = DB::select($query);
                $product_history_setoff = new ProductHistorySetOffController();
                foreach ($result as $data) {
                    $product_history = new ProductHistory();
                    $product_history->internal_id = $data->internal_id;
                    $product_history->external_id = $data->external_id;
                    $product_history->document_no = 230;
                    $product_history->description = "Material Return";
                    $product_history->product_id = $data->product_id;
                    $product_history->unit_id = $returnData->unit_id;
                    $product_history->quantity = $returnData->qty;
                    $product_history->set_off = 0;
                    $product_history->cost_price = 0;
                    $product_history->store_id = $data->store_id;
                    $product_history->user_id = Auth::user()->id;
                    $product_history->transaction_date = $data->trans_date;
                    if ($product_history->save()) {
                        $product_history_setoff->saveMaterialReturn($product_history);
                    }
                }
            }
            $responseBody = $this->responseBody(true, "MaterialReturnController", "saveGrnHeaderTemp", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialReturnController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    private function addReturnToSetoff($internal_id, $external_id, $ref_internal_id, $ref_external_id, $product_id, $quantity, $store_id, $transaction_id)
    {


        //$product_history = ProductHistory::where([['internal_id', '=', $ref_internal_id], ['product_id', '=', $product_id], ['store_id', '=', $store_id]])->first();

        $setoff = new ProductHistorySetoff();
        $setoff->internal_id = $internal_id;
        $setoff->external_id = $external_id;
        $setoff->ref_internal_id = $ref_internal_id;
        $setoff->ref_external_id = $ref_external_id;
        $setoff->document_no = 210;
        $setoff->product_history_transaction_id = $transaction_id;
        $setoff->product_id = $product_id;
        $setoff->setoff_quantity = $quantity;
        $setoff->cost_price = 0;
        $setoff->store_id = $store_id;
        $setoff->user_id = Auth::user()->id;
        if ($setoff->save()) {
            $this->updateProductHistorySetOff($setoff->ref_internal_id, $setoff->product_id, $setoff->store_id, $setoff->setoff_quantity);
        }
    }



    private function updateProductHistorySetOff($ref_internal_id, $product_id, $store_id, $setoff_quantity)
    {

        $product_history = ProductHistory::where([['product_id', '=', $product_id], ['store_id', '=', $store_id], ['document_no', '=', '100']])->get();

        $setoff = $setoff_quantity;

        foreach ($product_history as $data) {
            $setoff -= $data->set_off;
            if ($setoff >= $data->quantity) {
                $data->set_off = abs($data->quantity);
                $data->update();
                $setoff = ($setoff - $data->quantity);
            } else {
                $data->set_off = abs($setoff);
                $data->update();
                $setoff = ($setoff - $setoff_quantity);
            }
        }
    }


    public function getMaterialReturn($id)
    {

        try {
            $material_return = MiHeader::find($id);
            if (count(array_filter(explode("-", $material_return->external_id))) == 2) {
                $material_return->external_id = explode("-", $material_return->external_id)[1];
            }
            $grn_data = ProductHistory::where([['internal_id', '=', $material_return->internal_id], ['document_no', '=', '230']])->get();
            foreach ($grn_data as $data) {
                $product = Product::find($data->product_id);
                $data->product = $product->product_name;
                $uom = ProductUnit::find($product->uom_id);
                $uom_arr = [];
                if ($uom) {
                    array_push($uom_arr, ["value" => $uom->id, "text" => $uom->name]);
                }
                $data->comments = "";
                $data->uom = $uom_arr;
                $data->product_primary_id = $product->product_primary_id;
                $data->product_id = $product->product_id;
                //$product_history = ProductHistory::where([['internal_id', '=', $material_issue->internal_id], ['product_id', '=', $data->product_id]])->first();
                //$data->quantity = ($product_history->quantity - $product_history->set_off);
            }
            $material_return->data = $grn_data;
            $responseBody = $this->responseBody(true, "MaterialReturnController", "getMaterialIssue", $material_return);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialReturnController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function getUom($id)
    {
        try {
            $product =  Product::where('product_primary_id', '=', $id)->first();

            $data = [
                "id" => "0",
                "value" => "",
            ];
            if ($product) {
                $uom =  ProductUnit::find($product->uom_id);
                if ($uom) {
                    $data["id"] = $uom->id;
                    $data["value"] = $uom->name;
                }
            }

            $responseBody = $this->responseBody(true, "PurchaseRequestController", "getUom", $data);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseRequestController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    private function removeProductHistory($internal_id)
    {
        ProductHistory::where([['document_no', '=', '210'], ['internal_id', '=', $internal_id]])->delete();
    }

    private function removeProductFromSetoff($internal_id)
    {

        ProductHistorySetoff::where([['document_no', '=', '210'], ['internal_id', '=', $internal_id]])->delete();
    }


    private function getPrefix($document_no)
    {
        $document_no = DocumentNumber::where('document_number', '=', $document_no)->first();
        $prefix = "";
        if ($document_no) {
            $prefix = $document_no->prefix;
        }

        return $prefix;
    }




    /*private function addProductToHistory($header, $data)
    {


        $product_history_setoff = new ProductHistorySetOffController();

        $product_history = new ProductHistory();
        $product_history->internal_id = $data->internal_id;
        $product_history->external_id = $data->external_id;
        $product_history->document_no = "200";
        $product_history->description = "Material Issue";
        $product_history->product_id = $data->product_id;
        $product_history->unit_id = $data->unit_id;
        $product_history->quantity = ($data->quantity * -1);
        $product_history->set_off = 0;
        $product_history->cost_price = 0;
        $product_history->store_id = $header->store_id;
        $product_history->user_id = Auth::user()->id;
        if ($product_history->save()) {
            $product_history_setoff->saveMaterialReturn($product_history);
        }
    }*/


    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
