<?php

namespace Modules\Sc\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Am\Entities\PurchaceRequest;
use Modules\Sc\Entities\DocumentNumber;
use Modules\Sc\Entities\GoodsReceivedMr;
use Modules\Sc\Entities\GoodsTransferHeader;
use Modules\Sc\Entities\GrnHeader;
use Modules\Sc\Entities\MaterialRequisitionHeader;
use Modules\Sc\Entities\MiHeader;
use Modules\Sc\Entities\PurchaseOrderHeader;
use Modules\Sc\Entities\PurchaseRequestHeader;
use Modules\Sc\Entities\StoreLocation;

class ReferenceIDController extends Controller
{
    public function grnHeaderMaxID($store_id)
    {
        try {
            $store = StoreLocation::find($store_id);
            $id = 0;
            $prefix = "";
            if ($store) {
                $prefix =  $store->prefix;
                $result = DB::select('SELECT MAX(external_id) AS id FROM sc_grn_headers WHERE document_no = "100" AND external_id LIKE "%' . $prefix . '%"');
                foreach ($result as $res) {
                    if ($res->id) {
                        $id = $res->id;
                        $id = preg_replace('/\D/', '', $id);
                    }
                }
                $id += 1;
            }
            $responseBody = $this->responseBody(true, "ReferenceIDController", "grnHeaderMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function grnReturnMaxID($store_id)
    {
        try {
            $store = StoreLocation::find($store_id);
            $id = 0;
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
                $result = DB::select('SELECT MAX(external_id) AS id FROM sc_grn_headers WHERE document_no = "110" AND external_id LIKE "%' . $prefix . '%"');
                foreach ($result as $res) {
                    if ($res->id) {
                        $id = $res->id;
                        $id = preg_replace('/\D/', '', $id);
                    }
                }
                $id += 1;
            }
            $responseBody = $this->responseBody(true, "ReferenceIDController", "grnReturnMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function miHeaderMaxID($store_id)
    {
        try {
            $store = StoreLocation::find($store_id);
            $id = 0;
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
                $result = DB::select('SELECT MAX(external_id) AS id FROM sc_mi_headers WHERE external_id LIKE "%' . $prefix . '%"');
                foreach ($result as $res) {
                    if ($res->id) {
                        $id = $res->id;
                        $id = preg_replace('/\D/', '', $id);
                    }
                }
                $id += 1;
            }
            $responseBody = $this->responseBody(true, "ReferenceIDController", "miHeaderMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function purchaseRequestMaxID($store_id)
    {
        try {

            $store = StoreLocation::find($store_id);
            $id = 0;
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
                $result = DB::select('SELECT MAX(external_id) AS id FROM sc_purchase_request_headers WHERE external_id LIKE "%' . $prefix . '%"');
                foreach ($result as $res) {
                    if ($res->id) {
                        $id = $res->id;
                        $id = preg_replace('/\D/', '', $id);
                    }
                }
                $id += 1;
            }
            $responseBody = $this->responseBody(true, "ReferenceIDController", "purchaseRequestMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function purchaseOrderMaxID($store_id)
    {
        try {

            $store = StoreLocation::find($store_id);
            $id = 0;
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
                $result = DB::select('SELECT MAX(external_id) AS id FROM sc_purchase_order_headers WHERE external_id LIKE "%' . $prefix . '%"');
                foreach ($result as $res) {
                    if ($res->id) {
                        $id = $res->id;
                        $id = preg_replace('/\D/', '', $id);
                    }
                }
                $id += 1;
            }
            $responseBody = $this->responseBody(true, "ReferenceIDController", "purchaseOrderMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function materialRequisitionMaxIDMaxID($store_id)
    {
        try {
            $store = StoreLocation::find($store_id);
            $id = 0;
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
                $result = DB::select('SELECT MAX(external_id) AS id FROM sc_material_requisition_headers WHERE external_id LIKE "%' . $prefix . '%"');
                foreach ($result as $res) {
                    if ($res->id) {
                        $id = $res->id;
                        $id = preg_replace('/\D/', '', $id);
                    }
                }
                $id += 1;
            }
            $responseBody = $this->responseBody(true, "ReferenceIDController", "materialRequisitionMaxIDMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "error", $result);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function goodsReceivedMrMaxID($store_id)
    {
        try {

            $store = StoreLocation::find($store_id);
            $id = 0;
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
                $result = DB::select('SELECT MAX(refferance_no) AS id FROM sc_goods_received_mrs WHERE refferance_no LIKE "%' . $prefix . '%"');
                foreach ($result as $res) {
                    if ($res->id) {
                        $id = $res->id;
                        $id = preg_replace('/\D/', '', $id);
                    }
                }
                $id += 1;
            }
            $responseBody = $this->responseBody(true, "ReferenceIDController", "goodsReceivedMrMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function goodsTransferMaxID($store_id)
    {
        try {
            $store = StoreLocation::find($store_id);
            $id = 0;
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
                $result = DB::select('SELECT MAX(external_id) AS id FROM sc_goods_transfer_headers WHERE external_id LIKE "%' . $prefix . '%"');
                foreach ($result as $res) {
                    if ($res->id) {
                        $id = $res->id;
                        $id = preg_replace('/\D/', '', $id);
                    }
                }
                $id += 1;
            }
            $responseBody = $this->responseBody(true, "ReferenceIDController", "goodsTransferMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function goodsTransferMRMaxID($store_id)
    {
        try {
            $store = StoreLocation::find($store_id);
            $id = 0;
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
                $result = DB::select('SELECT MAX(external_id) AS id FROM sc_goods_transfer_header_m_rs WHERE external_id LIKE "%' . $prefix . '%"');
                foreach ($result as $res) {
                    if ($res->id) {
                        $id = $res->id;
                        $id = preg_replace('/\D/', '', $id);
                    }
                }
                $id += 1;
            }
            $responseBody = $this->responseBody(true, "ReferenceIDController", "goodsTransferMRMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function materialIssueMaxID($store_id)
    {
        try {
            $store = StoreLocation::find($store_id);
            $id = 0;
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
                $result = DB::select('SELECT MAX(external_id) AS id FROM sc_mi_headers WHERE external_id LIKE "%' .$prefix . '%"');
                foreach ($result as $res) {
                    if ($res->id) {
                        $id = $res->id;
                        $id = preg_replace('/\D/', '', $id);
                    }
                }
                $id += 1;
            }
            $responseBody = $this->responseBody(true, "ReferenceIDController", "materialIssueMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "materialIssueMaxID", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    /*public function materialReturnMaxID($store_id)
    {
        try {
            $tbl = MiHeader::all();
            $id = 1;
            if (count($tbl) > 0) {
                $id = $tbl[count($tbl) - 1]['internal_id'] + 1;
            }
            $store = StoreLocation::find($store_id);
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
            }
            $responseBody = $this->responseBody(true, "ReferenceIDController", "materialReturnMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "materialReturnMaxID", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }*/


    private function getDocumentPrefix($document_no)
    {
        $document_no = DocumentNumber::where('document_number', '=', $document_no)->first();
        $prefix = "";
        if ($document_no) {
            $prefix = $document_no->prefix;
        }

        return $prefix;
    }



    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
