<?php

namespace Modules\Sc\Http\Controllers;

use App\Models\User;
use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\EmployeeSite;
use Modules\Sc\Entities\ProductHistory;
use Modules\Sc\Entities\StoreLocation;
use Modules\St\Entities\GroupLevel1;
use Modules\St\Entities\GroupLevel2;
use Modules\St\Entities\GroupLevel3;
use Modules\St\Entities\Product;
use Modules\St\Entities\ProductType;
use Modules\St\Entities\SupplierType;
use PdfReport;

class StockValuationReportController extends Controller
{
    public function allSettings()
    {

        try {
            $settings = [
                "site" => $this->site(),
                "stores" => $this->stores(),
                "producttype" => $this->producttype(),
                "grouplevel1" => $this->grouplevel1(),
                "grouplevel2" => $this->grouplevel2(),
                "grouplevel3" => $this->grouplevel3(),
                "productname" => $this->productname(),
            ];
            $responseBody = $this->responseBody(true, "AllSettings", "all", ["settings" => $settings]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "AllSettings", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function site()
    {

        try {
            $site = EmployeeSite::all();
            $collection = [];
            for ($i = 0; $i < count($site); $i++) {
                array_push($collection, ["id" => $site[$i]['site_id'], "value" => $site[$i]['site']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }


    public function stores()
    {

        try {
            $store = StoreLocation::all();
            $collection = [];
            for ($i = 0; $i < count($store); $i++) {
                array_push($collection, ["id" => $store[$i]['id'], "value" => $store[$i]['name']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }


    public function producttype()
    {

        try {
            $type = ProductType::all();
            $collection = [];
            for ($i = 0; $i < count($type); $i++) {
                array_push($collection, ["id" => $type[$i]['product_type_id'], "value" => $type[$i]['product_type']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }



    public function grouplevel1()
    {

        try {
            $groupLevel = GroupLevel1::all();
            $collection = [];
            for ($i = 0; $i < count($groupLevel); $i++) {
                array_push($collection, ["id" => $groupLevel[$i]['group_level_1_id'], "value" => $groupLevel[$i]['group_level_1']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }


    public function grouplevel2()
    {

        try {
            $groupLevel = GroupLevel2::all();
            $collection = [];
            for ($i = 0; $i < count($groupLevel); $i++) {
                array_push($collection, ["id" => $groupLevel[$i]['group_level_2_id'], "value" => $groupLevel[$i]['group_level_2']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }



    public function grouplevel3()
    {

        try {
            $groupLevel = GroupLevel3::all();
            $collection = [];
            for ($i = 0; $i < count($groupLevel); $i++) {
                array_push($collection, ["id" => $groupLevel[$i]['group_level_3_id'], "value" => $groupLevel[$i]['group_level_3']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }



    public function supplier_type()
    {

        try {
            $supplier_type = SupplierType::all();
            return $supplier_type;
        } catch (\Exception $exception) {
            return $exception;
        }
    }



    public function productname()
    {

        try {
            $product = Product::all();
            $collection = [];
            for ($i = 0; $i < count($product); $i++) {
                array_push($collection, ["id" => $product[$i]['product_id'], "value" => $product[$i]['product_name']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }











    public function showStockValuationAverageReport($setting, $fromDate, $toDate)
    {
        try {
            $title = '';
            $setting_aaray =  json_decode($setting);
            $site = $setting_aaray->site;
            $stores = $setting_aaray->stores;
            $producttype = $setting_aaray->producttype;
            $grouplevel1 = $setting_aaray->grouplevel1;
            $grouplevel2 = $setting_aaray->grouplevel2;
            $grouplevel3 = $setting_aaray->grouplevel3;
            $without0 = $setting_aaray->without0;
            $productname = $setting_aaray->productname;

            ini_set('max_execution_time', '0'); // for infinite time of execution

            $query = "SELECT st_products.product_id,
            sc_product_histories.external_id,
            st_products.product_name,
            st_group_level_1.group_level_1 AS group1,
            st_group_level_2.group_level_2 AS group2,
            st_product_units.`name` AS unit_of_mesurment,
            (SUM(sc_product_histories.quantity) - SUM(sc_product_histories.set_off)) AS balance,
            (SUM(sc_product_histories.quantity) - SUM(sc_product_histories.set_off)) * sc_product_histories.cost_price AS value
            FROM sc_product_histories 
            INNER JOIN st_products ON sc_product_histories.product_id = st_products.product_primary_id
            INNER JOIN st_product_units ON sc_product_histories.unit_id = st_product_units.id
            INNER JOIN st_group_level_1 ON st_products.group_id_level_1 = st_group_level_1.group_level_1_id
            INNER JOIN st_group_level_2 ON st_products.group_id_level_2 = st_group_level_2.group_level_2_id WHERE  ";



            if ($stores != '') {
                $query .= "sc_product_histories.store_id = '" . $stores . "' AND ";
                $title = '';
            }

            if ($producttype != '') {
                $query .= "st_products.product_type_id = '" . $producttype . "' AND ";
                $title = '';
            }

            if ($grouplevel1 != '') {
                $query .= "st_products.group_id_level_1 = '" . $grouplevel1 . "' AND ";
                $title = '';
            }

            if ($grouplevel2 != '') {
                $query .= "st_products.group_id_level_2 = '" . $grouplevel2 . "' AND ";
                $title = '';
            }

            if ($grouplevel3 != '') {
                $query .= "st_products.group_id_level_3 = '" . $grouplevel3 . "' AND ";
                $title = '';
            }

            if ($productname != '') {
                $query .= "st_products.product_id = '" . $productname . "' AND ";
                $title = '';
            }



            $query = preg_replace('/\W\w+\s*(\W*)$/', '$1', $query);
            $query .= " GROUP BY sc_product_histories.product_id";

            $stockBalance = DB::select($query);
            $responseBody = $this->responseBody(true, $query, "Report", [
                'body' => $stockBalance,
                'title' => $title,
                "query" => $query,
            ]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "StockReportController", "Report", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    public function showStockValuationAverageAsAtReport($setting, $fromDate, $toDate)
    {
        try {
            $title = '';
            $setting_aaray =  json_decode($setting);
            $site = $setting_aaray->site;
            $stores = $setting_aaray->stores;
            $producttype = $setting_aaray->producttype;
            $grouplevel1 = $setting_aaray->grouplevel1;
            $grouplevel2 = $setting_aaray->grouplevel2;
            $grouplevel3 = $setting_aaray->grouplevel3;
            $without0 = $setting_aaray->without0;
            $productname = $setting_aaray->productname;

            ini_set('max_execution_time', '0'); // for infinite time of execution

            $query = "SELECT st_products.product_id,
            sc_product_histories.external_id,
            st_products.product_name,
            st_group_level_1.group_level_1 AS group1,
            st_group_level_2.group_level_2 AS group2,
            st_product_units.`name` AS unit_of_mesurment,
            (SUM(sc_product_histories.quantity) - SUM(sc_product_histories.set_off)) AS balance,
            (SUM(sc_product_histories.quantity) - SUM(sc_product_histories.set_off)) * sc_product_histories.cost_price AS value
            FROM sc_product_histories 
            INNER JOIN st_products ON sc_product_histories.product_id = st_products.product_primary_id
            INNER JOIN st_product_units ON sc_product_histories.unit_id = st_product_units.id
            INNER JOIN st_group_level_1 ON st_products.group_id_level_1 = st_group_level_1.group_level_1_id
            INNER JOIN st_group_level_2 ON st_products.group_id_level_2 = st_group_level_2.group_level_2_id WHERE  ";



            if ($stores != '') {
                $query .= "sc_product_histories.store_id = '" . $stores . "' AND ";
                $title = '';
            }

            if ($producttype != '') {
                $query .= "st_products.product_type_id = '" . $producttype . "' AND ";
                $title = '';
            }

            if ($grouplevel1 != '') {
                $query .= "st_products.group_id_level_1 = '" . $grouplevel1 . "' AND ";
                $title = '';
            }

            if ($grouplevel2 != '') {
                $query .= "st_products.group_id_level_2 = '" . $grouplevel2 . "' AND ";
                $title = '';
            }

            if ($grouplevel3 != '') {
                $query .= "st_products.group_id_level_3 = '" . $grouplevel3 . "' AND ";
                $title = '';
            }

            if ($productname != '') {
                $query .= "st_products.product_id = '" . $productname . "' AND ";
                $title = '';
            }

            if ($toDate != '') {
                $query .= "sc_product_histories.transaction_date <= '" . $toDate . "' AND ";
                $title = '';
            }



            $query = preg_replace('/\W\w+\s*(\W*)$/', '$1', $query);
            $query .= " GROUP BY sc_product_histories.product_id";

            //dd($query);
            $stockBalance = DB::select($query);
            $responseBody = $this->responseBody(true, $query, "Report", [
                'body' => $stockBalance,
                'title' => $title,
                "query" => $query,
            ]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "StockReportController", "Report", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    public function showStockValuationBatchWiseReport($setting, $fromDate, $toDate)
    {
        try {
            $title = '';
            $setting_aaray =  json_decode($setting);
            $site = $setting_aaray->site;
            $stores = $setting_aaray->stores;
            $producttype = $setting_aaray->producttype;
            $grouplevel1 = $setting_aaray->grouplevel1;
            $grouplevel2 = $setting_aaray->grouplevel2;
            $grouplevel3 = $setting_aaray->grouplevel3;
            $without0 = $setting_aaray->without0;
            $productname = $setting_aaray->productname;

            ini_set('max_execution_time', '0'); // for infinite time of execution

            $query = "SELECT st_products.product_id,
            sc_product_history_setoffs.external_id,
            st_products.product_name,
            st_group_level_1.group_level_1 AS group1,
            st_group_level_2.group_level_2 AS group2,
            st_product_units.`name` AS unit_of_mesurment,
            (SUM(sc_product_history_setoffs.quantity) - SUM(sc_product_history_setoffs.setoff_quantity)) AS balance,
            (SUM(sc_product_history_setoffs.quantity) - SUM(sc_product_history_setoffs.setoff_quantity)) * sc_product_history_setoffs.cost_price AS value
            FROM sc_product_history_setoffs 
            INNER JOIN st_products ON sc_product_history_setoffs.product_id = st_products.product_primary_id
            INNER JOIN st_product_units ON st_products.uom_id = st_product_units.id
            INNER JOIN st_group_level_1 ON st_products.group_id_level_1 = st_group_level_1.group_level_1_id
            INNER JOIN st_group_level_2 ON st_products.group_id_level_2 = st_group_level_2.group_level_2_id WHERE sc_product_history_setoffs.document_no = '100' AND ";



            if ($stores != '') {
                $query .= "sc_product_history_setoffs.store_id = '" . $stores . "' AND ";
                $title = '';
            }

            if ($producttype != '') {
                $query .= "st_products.product_type_id = '" . $producttype . "' AND ";
                $title = '';
            }

            if ($grouplevel1 != '') {
                $query .= "st_products.group_id_level_1 = '" . $grouplevel1 . "' AND ";
                $title = '';
            }

            if ($grouplevel2 != '') {
                $query .= "st_products.group_id_level_2 = '" . $grouplevel2 . "' AND ";
                $title = '';
            }

            if ($grouplevel3 != '') {
                $query .= "st_products.group_id_level_3 = '" . $grouplevel3 . "' AND ";
                $title = '';
            }

            if ($productname != '') {
                $query .= "st_products.product_id = '" . $productname . "' AND ";
                $title = '';
            }



            $query = preg_replace('/\W\w+\s*(\W*)$/', '$1', $query);
            $query .= " GROUP BY sc_product_history_setoffs.product_id";

            $stockBalance = DB::select($query);
            $responseBody = $this->responseBody(true, $query, "Report", [
                'body' => $stockBalance,
                'title' => $title,
                "query" => $query,
            ]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "StockReportController", "Report", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function grnReport($setting, $fromDate, $toDate)
    {
        try {
            $title = '';
            $setting_aaray =  json_decode($setting);
            $site = $setting_aaray->site;
            $stores = $setting_aaray->stores;
            $producttype = $setting_aaray->producttype;
            $grouplevel1 = $setting_aaray->grouplevel1;
            $grouplevel2 = $setting_aaray->grouplevel2;
            $grouplevel3 = $setting_aaray->grouplevel3;
            $without0 = $setting_aaray->without0;
            $productname = $setting_aaray->productname;

            ini_set('max_execution_time', '0'); // for infinite time of execution

            $query = "SELECT sc_grn_headers.trans_date AS date,
            '' AS pr_no,
            sc_grn_headers.purchase_order_no AS po_number,
            sc_grn_headers.external_id AS grn_number,
            st_products.product_id AS product_code,
            st_products.product_name,
            st_group_level_1.group_level_1 AS group1,
            st_group_level_2.group_level_2 AS group2,
            st_suppliers.supplier_id AS supplier_code,
            st_suppliers.supplier_name,
            st_uom.uom,
            sc_grn_data.quantity,
            (sc_grn_data.quantity * sc_grn_data.price) AS value
            FROM sc_grn_headers
            INNER JOIN sc_grn_data ON sc_grn_headers.internal_id = sc_grn_data.internal_id
            INNER JOIN st_products ON sc_grn_data.product_id = st_products.product_primary_id
            INNER JOIN st_group_level_1 ON st_products.group_id_level_1 = st_group_level_1.group_level_1_id
            INNER JOIN st_group_level_2 ON st_products.group_id_level_2 = st_group_level_2.group_level_2_id
            INNER JOIN st_suppliers ON sc_grn_headers.supplier_Id = st_suppliers.supplier_id
            LEFT JOIN st_uom ON st_products.uom_id = st_uom.uom_id WHERE ";
            // INNER JOIN st_uom ON st_products.uom_id = st_uom.uom_id WHERE 

            if ($stores != '') {
                //$query .= "sc_product_histories.store_id = '" . $stores . "' AND ";
                $title = '';
            }

            if ($producttype != '') {
                $query .= "st_products.product_type_id = '" . $producttype . "' AND ";
                $title = '';
            }

            if ($grouplevel1 != '') {
                $query .= "st_products.group_id_level_1 = '" . $grouplevel1 . "' AND ";
                $title = '';
            }

            if ($grouplevel2 != '') {
                $query .= "st_products.group_id_level_2 = '" . $grouplevel2 . "' AND ";
                $title = '';
            }

            if ($grouplevel3 != '') {
                $query .= "st_products.group_id_level_3 = '" . $grouplevel3 . "' AND ";
                $title = '';
            }

            if ($productname != '') {
                $query .= "st_products.product_id = '" . $productname . "' AND ";
                $title = '';
            }

            if ($toDate != '' && $fromDate != '') {
                $query .= "sc_grn_headers.trans_date BETWEEN '" . $fromDate . "' AND '" . $toDate . "' AND ";
                $title = '';
            }



            $query = preg_replace('/\W\w+\s*(\W*)$/', '$1', $query);
            //$query .= " GROUP BY sc_product_histories.product_id";

            //dd($query);
            $grnReport = DB::select($query);
            $responseBody = $this->responseBody(true, "StockReportController", "data", $grnReport);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "StockReportController", "Report", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function ginReport($setting, $fromDate, $toDate)
    {
        try {
            $title = '';
            $setting_aaray =  json_decode($setting);
            $site = $setting_aaray->site;
            $stores = $setting_aaray->stores;
            $producttype = $setting_aaray->producttype;
            $grouplevel1 = $setting_aaray->grouplevel1;
            $grouplevel2 = $setting_aaray->grouplevel2;
            $grouplevel3 = $setting_aaray->grouplevel3;
            $without0 = $setting_aaray->without0;
            $productname = $setting_aaray->productname;

            ini_set('max_execution_time', '0'); // for infinite time of execution

            // $query = "SELECT sc_mi_headers.trans_date AS date,
            // sc_departments.department,
			// (SELECT hr_employees.name_withinitial FROM hr_employees WHERE hr_employees.employee_id = sc_mi_headers.supervisor_id) AS person,
			// sc_mi_headers.ref_external_id AS gin_number,
            // st_products.product_id AS product_code,
            // st_products.product_name,
            // st_group_level_1.group_level_1 AS group1,
            // st_group_level_2.group_level_2 AS group2,
            // st_uom.uom,
            // sc_mi_data.quantity
            // FROM sc_mi_headers
            // INNER JOIN sc_mi_data ON sc_mi_headers.internal_id = sc_mi_data.internal_id
            // INNER JOIN st_products ON sc_mi_data.product_id = st_products.product_primary_id
            // INNER JOIN st_group_level_1 ON st_products.group_id_level_1 = st_group_level_1.group_level_1_id
            // INNER JOIN st_group_level_2 ON st_products.group_id_level_2 = st_group_level_2.group_level_2_id
            // INNER JOIN st_uom ON st_products.uom_id = st_uom.uom_id
			// INNER JOIN sc_departments ON sc_mi_headers.dept_id = sc_departments.id WHERE ";

            $query = "SELECT sc_mi_headers.trans_date AS date,
            hr_employee_departments.department,
			(SELECT hr_employees.name_withinitial FROM hr_employees WHERE hr_employees.employee_id = sc_mi_headers.supervisor_id) AS person,
			sc_mi_headers.ref_external_id AS gin_number,
            st_products.product_id AS product_code,
            st_products.product_name,
            st_group_level_1.group_level_1 AS group1,
            st_group_level_2.group_level_2 AS group2,
            st_uom.uom,
            sc_mi_data.quantity
            FROM sc_mi_headers
            INNER JOIN sc_mi_data ON sc_mi_headers.internal_id = sc_mi_data.internal_id
            INNER JOIN st_products ON sc_mi_data.product_id = st_products.product_primary_id
            INNER JOIN st_group_level_1 ON st_products.group_id_level_1 = st_group_level_1.group_level_1_id
            INNER JOIN st_group_level_2 ON st_products.group_id_level_2 = st_group_level_2.group_level_2_id
            INNER JOIN st_uom ON st_products.uom_id = st_uom.uom_id
			INNER JOIN hr_employee_departments ON sc_mi_headers.dept_id = hr_employee_departments.department_id WHERE ";



            if ($stores != '') {
                //$query .= "sc_product_histories.store_id = '" . $stores . "' AND ";
                $title = '';
            }

            if ($producttype != '') {
                $query .= "st_products.product_type_id = '" . $producttype . "' AND ";
                $title = '';
            }

            if ($grouplevel1 != '') {
                $query .= "st_products.group_id_level_1 = '" . $grouplevel1 . "' AND ";
                $title = '';
            }

            if ($grouplevel2 != '') {
                $query .= "st_products.group_id_level_2 = '" . $grouplevel2 . "' AND ";
                $title = '';
            }

            if ($grouplevel3 != '') {
                $query .= "st_products.group_id_level_3 = '" . $grouplevel3 . "' AND ";
                $title = '';
            }

            if ($productname != '') {
                $query .= "st_products.product_id = '" . $productname . "' AND ";
                $title = '';
            }

            if ($toDate != '' && $fromDate != '') {
                $query .= "sc_mi_headers.trans_date BETWEEN '" . $fromDate . "' AND '" . $toDate . "' AND ";
                $title = '';
            }



            $query = preg_replace('/\W\w+\s*(\W*)$/', '$1', $query);
            //$query .= " GROUP BY sc_product_histories.product_id";

            //dd($query);
            $grnReport = DB::select($query);
            $responseBody = $this->responseBody(true, "StockReportController", "data", $grnReport);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "StockReportController", "Report", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function goodTransferReport($setting, $fromDate, $toDate)
    {
        try {
            $title = '';
            $setting_aaray =  json_decode($setting);
            $site = $setting_aaray->site;
            $stores = $setting_aaray->stores;
            $producttype = $setting_aaray->producttype;
            $grouplevel1 = $setting_aaray->grouplevel1;
            $grouplevel2 = $setting_aaray->grouplevel2;
            $grouplevel3 = $setting_aaray->grouplevel3;
            $without0 = $setting_aaray->without0;
            $productname = $setting_aaray->productname;

            ini_set('max_execution_time', '0'); // for infinite time of execution

            $query = "SELECT sc_goods_transfer_headers.trans_date AS date,
            sc_store_locations.`name` AS location,
			'' AS person,
			sc_goods_transfer_headers.ref_external_id AS reference_number,
            '' AS po_number,
            st_products.product_id AS product_code,
            st_products.product_name,
            st_group_level_1.group_level_1 AS group1,
            st_group_level_2.group_level_2 AS group2,
            st_uom.uom,
            sc_goods_transfer_data.quantity
            FROM sc_goods_transfer_headers
            INNER JOIN sc_goods_transfer_data ON sc_goods_transfer_headers.internal_id = sc_goods_transfer_data.internal_id
            INNER JOIN st_products ON sc_goods_transfer_data.product_id = st_products.product_primary_id
            INNER JOIN st_group_level_1 ON st_products.group_id_level_1 = st_group_level_1.group_level_1_id
            INNER JOIN st_group_level_2 ON st_products.group_id_level_2 = st_group_level_2.group_level_2_id
            INNER JOIN st_uom ON st_products.uom_id = st_uom.uom_id
			INNER JOIN sc_store_locations ON sc_goods_transfer_headers.store_to_id = sc_store_locations.id WHERE ";



            if ($stores != '') {
                //$query .= "sc_product_histories.store_id = '" . $stores . "' AND ";
                $title = '';
            }

            if ($producttype != '') {
                $query .= "st_products.product_type_id = '" . $producttype . "' AND ";
                $title = '';
            }

            if ($grouplevel1 != '') {
                $query .= "st_products.group_id_level_1 = '" . $grouplevel1 . "' AND ";
                $title = '';
            }

            if ($grouplevel2 != '') {
                $query .= "st_products.group_id_level_2 = '" . $grouplevel2 . "' AND ";
                $title = '';
            }

            if ($grouplevel3 != '') {
                $query .= "st_products.group_id_level_3 = '" . $grouplevel3 . "' AND ";
                $title = '';
            }

            if ($productname != '') {
                $query .= "st_products.product_id = '" . $productname . "' AND ";
                $title = '';
            }

            if ($toDate != '' && $fromDate != '') {
                $query .= "sc_goods_transfer_headers.trans_date BETWEEN '" . $fromDate . "' AND '" . $toDate . "' AND ";
                $title = '';
            }



            $query = preg_replace('/\W\w+\s*(\W*)$/', '$1', $query);
            //$query .= " GROUP BY sc_product_histories.product_id";

            //dd($query);
            $grnReport = DB::select($query);
            $responseBody = $this->responseBody(true, "StockReportController", "data", $grnReport);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "StockReportController", "Report", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function supplierListReport($setting)
    {
        try {
            $title = '';
            $setting_aaray =  json_decode($setting);
            $supplier_type = $setting_aaray->supplier_type;
            /* $stores = $setting_aaray->stores;
            $producttype = $setting_aaray->producttype;
            $grouplevel1 = $setting_aaray->grouplevel1;
            $grouplevel2 = $setting_aaray->grouplevel2;
            $grouplevel3 = $setting_aaray->grouplevel3;
            $without0 = $setting_aaray->without0;
            $productname = $setting_aaray->productname;*/

            ini_set('max_execution_time', '0'); // for infinite time of execution

            $query = "SELECT st_suppliers.supplier_name,
            st_countries.country_name AS country,
            st_suppliers.address,
            st_districts.district,
            st_towns.town,
            st_supplier_types.supplier_type AS type
            FROM st_suppliers
            INNER JOIN st_countries ON st_suppliers.country_id = st_countries.country_id
            INNER JOIN st_supplier_types ON st_suppliers.supplier_type_id = st_supplier_types.supplier_type_id
            LEFT JOIN st_districts ON st_suppliers.district_id = st_districts.district_id
            LEFT JOIN st_towns ON st_suppliers.town_id = st_towns.town_id WHERE ";


            if ($supplier_type != '') {
                $query .= "st_suppliers.supplier_type_id = '" . $supplier_type . "' AND ";
                $title = '';
            }




            $query = preg_replace('/\W\w+\s*(\W*)$/', '$1', $query);
            //$query .= " GROUP BY sc_product_histories.product_id";

            //dd($query);
            $grnReport = DB::select($query);
            $responseBody = $this->responseBody(true, "StockReportController", "data", $grnReport);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "StockReportController", "Report", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
