class BomModal {

    constructor(parent) {

        $.ajax({
            url: 'BomModal',
            type: 'GET',
            async: false,
            success: function (data) {
                parent.html($(data).find('#modal').html());
            }
        });


    }



    show() {

        $('#materialModal').modal('show');
    }

    hide() {
        $('#materialModal').modal('hide');
    }




    getSelectedModalData(order_id, product_id, machine_id) {
        $.ajax({
            type: 'GET',
            url: '/pd/ProductionScheduleCreateController/getSelectedProductData/' + order_id + "/" + product_id + "/" + machine_id,
            async: false,
            success: function (response) {
                console.log(response.data.result);
                if (response.data.success) {
                    $('#lblBOMProductCode').text(": " + response.data.result.product_code);
                    $('#lblBOMProductName').text(": " + response.data.result.product_name);
                    $('#lblBOMFactoryPO').text(": " + response.data.result.factory_po);
                    $('#lblBOMCustomerPO').text(": " + response.data.result.customer_po);
                    $('#lblBOMProductionQty').text(": " + response.data.result.quantity);
                    $('#lblBOMAllocateQty').text(": " + response.data.result.allocated_quantity);
                    BomModal.getSavedAllocatedBOMSummaryDataToMaterial(order_id, product_id);
                }

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();
            },
            complete: function () {

            }
        });
    }





    static getSavedAllocatedBOMSummaryDataToMaterial(order_id, product_primary_id) {


        $.ajax({
            type: 'GET',
            url: "/pd/ProductionScheduleCreateController/getSavedAllocatedBOMData/" + order_id + "/" + product_primary_id,
            async: false,
            beforeSend: function () {
                //progress(true);
            },
            success: function (response) {
                console.log(response.data.result);
                if (response.data.success) {
                    $('#tblMaterialBOM').empty();
                    for (i = 0; i < response.data.result.length; i++) {
                        var material_id = response.data.result[i]['product_id'];
                        var material = response.data.result[i]['product_name'];
                        var uom = response.data.result[i]['uom_name'];
                        var requirment = parseFloat(response.data.result[i]['quantity']).toFixed(2);
                        if (isNaN(requirment)) {
                            requirment = 0.00;
                        }
                        var stock_in_hand = parseFloat(response.data.result[i]['stock_in_h']).toFixed(2);
                        if (isNaN(stock_in_hand)) {
                            stock_in_hand = 0.00;
                        }
                        var pending_order = 0;
                        var field_operation = 0;
                        var shortage = 0;

                        var row = '<tr><td>' + material_id + '</td>';
                        row += '<td>' + material + '</td>';
                        row += '<td>' + uom + '</td>';
                        row += '<td style="text-align:right;">' + requirment + '</td>';
                        row += '<td style="text-align:right;">' + stock_in_hand + '</td>';
                        row += '<td style="text-align:right;">' + pending_order + '</td>';
                        //row += '<td style="text-align:right;">' + field_operation + '</td>';
                        row += '<td>' + shortage + '</td></tr>';
                        if (material) {
                            $('#tblMaterialBOM').append(row);
                        }

                    }

                }


            },
            error: function (data) {

            },
            complete: function () {
                //progress(false);
            }
        });

    }



}