var MR_ID = 0;
$(document).ready(function () {

    $('#btnRetrieveMR').on('click', function () {

        $('#txtFirstWeight').val('');
        $('#txtSecondWeight').val('');
        $('#tblBopdyMrData').empty();
        retrieveMrHeader();
    });




    $('#tblMrHeader tbody').on('click', 'tr', function () {
        $(this).addClass('selected').siblings().removeClass('selected');
        MR_ID = $(this).find('td:first').html();
        retrieveMrData(MR_ID);
    });

});


function retrieveMrHeader() {

    $.ajax({
        type: "GET",
        url: "/sc/GoodsTransferMrRetrieveController/allMaterialRequisition",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            if (response.data.success) {

                console.log(response);
                $('#tblBodyMrHeader').empty();
                for (i = 0; i < response.data.result.length; i++) {
                    var id = response.data.result[i]['internal_id'];
                    var refferance_id = response.data.result[i]['external_id'];
                    var date = response.data.result[i]['trans_date'];
                    var store = response.data.result[i]['store'];
                    var department = response.data.result[i]['department'];

                    var row = '<tr><td hidden>' + id + '</td>';
                    row += '<td>' + date + '</td>';
                    row += '<td>' + refferance_id + '</td>';
                    row += '<td>' + store + '</td>';
                    row += '<td>' + department + '</td></tr>';
                    $('#tblBodyMrHeader').append(row);

                }


            }
        },

        error: function (error) {
            console.log(error);


        },
        complete: function () {
            $('#mrDataModal').modal('show');
        }

    });

}




function retrieveMrData(id) {

    $.ajax({
        type: "GET",
        url: "/sc/GoodsTransferMrRetrieveController/allMaterialRequisitionData/" + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            if (response.data.success) {

                console.log(response);
                $('#tblBopdyMrData').empty();
                for (i = 0; i < response.data.result.length; i++) {
                    var data_id = response.data.result[i]['mr_data_id'];
                    var product_id = response.data.result[i]['product_id'];
                    var product_name = response.data.result[i]['product_name'];
                    var quantity = response.data.result[i]['quantity'];
                    var unit = response.data.result[i]['unit'];

                    var str_id = "'" + id + "'";
                    var str_data_id = "'" + data_id + "'";

                    var row = '<tr><td>' + product_id + '</td>';
                    row += '<td>' + product_name + '</td>';
                    row += '<td>' + quantity + '</td>';
                    row += '<td>' + unit + '</td>';
                    row += '<td><button type="button" class="btn btn-primary" onclick="setSelectedMR(' + str_id + ',' + str_data_id + ')">Get Data</button></td></tr>';
                    $('#tblBopdyMrData').append(row);

                }


            }
        },

        error: function (error) {
            console.log(error);


        },
        complete: function () {
            $('#mrDataModal').modal('show');
        }

    });

}




function setSelectedMR(id, data_id) {
    $('#mrDataModal').modal('hide');

    $.ajax({
        type: "GET",
        url: "/sc/GoodsTransferMrRetrieveController/getSelectedMR/" + id + "/" + data_id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {
            progress(true);
        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            GOODS_TRANSFER_ID = res.internal_id
            //referanceID = res.external_id;
            //$('#txtExternal_id').val(res.external_id);
            //$('#txtGrnDate').val(res.trans_date);
            //setSelectedOption('cmbStoresFrom', res.store_from_id);
            setSelectedOption('cmbStoresTo', res.store_id);
            tableData.clear();
            var request_data = res.data;
            for (var i = 0; i < request_data.length; i++) {
                tableData.addRow(
                    [
                        { 'type': 'string', 'val': request_data[i].product_primary_id, 'align': 'left', 'width': '100px' },
                        { 'type': 'string', 'val': request_data[i].product_id, 'align': 'left', 'width': '100px' },
                        { 'type': 'text', 'val': request_data[i].product, 'align': 'left', 'width': '100%' },
                        {
                            'type': 'select', 'val': request_data[i].uom, 'align': 'left', 'width': '100px'
                        },
                        { 'type': 'text', 'val': getAvailableQty(request_data[i].product_primary_id, $('#cmbStoresTo').val()), 'align': 'right', 'width': '100px' },
                        { 'type': 'text', 'val': request_data[i].quantity, 'align': 'right', 'width': '100px' },
                        { 'type': 'text', 'val': request_data[i].comments, 'align': 'left', 'width': '200px' },
                        { 'type': 'remove', 'val': 'X', 'align': 'center', 'width': '50px' }]
                );
            }

        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {
            progress(false);
        }

    });
}