var ROW_ID = 0;
var SELECTED_ROW = 0;
var dataChooser = undefined;
var STATUS = 0;
const TABLE_ADD = 1;
const TABLE_CONSUME = 0;
var GRN_TABLE = undefined;
var ROW_TIME = undefined;
var RESET_LIMIT = ((1000 * 60) * 2);
var DOUBLE_ENTER = 0;
var ROW_COUNT = 0;
var gross_total = 0;
var net_total = 0;
var product_unit = [];
$(document).ready(function () {
    //allProductUnit();

    var column_def = undefined;
    var on_focus = undefined;
    /**Sampath perera GrnTable */
    (function ($) {
        $.fn.grnTable = function (property) {
            column_def = property.column_def;
            on_focus = property.on_focus;
            GRN_TABLE = this;
            return this;
        };
    })(jQuery);
    (function ($) {
        $.fn.addRow = function (values) {
            var row_val = $('#' + (ROW_ID - 1) + "_0").val();
            if (row_val == undefined || row_val != "") {

                var args = [
                    { val: '', name: 'product_id' },
                    { val: '', name: 'product_name' },
                    { val: '', name: 'unit_id' },
                    { val: '0.00', name: 'quantity' },
                    { val: '', name: 'comments' },
                    { val: '', name: 'delete' }];


                if (STATUS == TABLE_ADD) {
                    var row = this.createRow(column_def, args);
                    this.append(row);
                    if (on_focus != undefined) {
                        for (var i = 0; i < args.length; i++) {
                            if (on_focus == args[i].name) {
                                var id = ROW_ID + '_' + i;
                                $('#' + id).focus();
                                $('#' + id).select();
                                break;
                            }
                        }
                    }
                    //saveTemp();
                    for (var i = 0; i < args.length; i++) {
                        if (column_def[args[i].name].type == 'select') {
                            var id = ROW_ID + '_' + i;
                            appendProductUnit(id);
                        }
                    }

                    SELECTED_ROW = ROW_ID;
                    ROW_ID++;
                    ROW_COUNT++;
                    STATUS = TABLE_CONSUME;
                    DOUBLE_ENTER = 0;
                    if (ROW_TIME != undefined) {
                        clearTimeout(ROW_TIME);
                    }
                    //ROW_TIME = setTimeout(reset, RESET_LIMIT);
                }

            } else {
                $('#' + (ROW_ID - 1) + "_1").focus();
                SELECTED_ROW = (ROW_ID - 1);
            }
        }
    })(jQuery);
    (function ($) {
        $.fn.getSelectedRow = function () {
            return SELECTED_ROW;
        }
    })(jQuery);
    (function ($) {
        $.fn.setStatus = function (status) {
            STATUS = status;
        }
    })(jQuery);
    (function ($) {
        $.fn.reset = function () {
            ROW_COUNT = 0;
            ROW_ID = 0;
            this.empty();
            this.setStatus(TABLE_ADD);
            this.addRow();
        }
    })(jQuery);
    (function ($) {
        $.fn.rowCount = function () {
            return ROW_COUNT;
        }
    })(jQuery);
    (function ($) {
        $.fn.getVal = function (row, cell) {
            return this[0].rows[row].cells[cell].childNodes[0].value;
        }
    })(jQuery);
    (function ($) {
        $.fn.createRow = function (column_def, args) {
            row = '<tr id="' + ROW_ID + '">';
            for (var i = 0; i < args.length; i++) {

                var id = ROW_ID + '_' + i;
                var editable = "";
                var style = "style=";

                if (args[i].id != undefined) {
                    id = args[i].id;
                } else {
                    id = ROW_ID + '_' + i;
                }

                if (column_def[args[i].name].editable != undefined) {
                    if (column_def[args[i].name].editable) {
                        editable = "";
                    } else {
                        editable = "readonly";
                    }

                }
                if (column_def[args[i].name].align != undefined) {
                    style += 'text-align:' + column_def[args[i].name].align + ';';
                }
                if (column_def[args[i].name].width != undefined) {
                    style += 'width:' + column_def[args[i].name].width + ';';
                }

                if (column_def[args[i].name].type == 'text') {
                    row += '<td><input id="' + id + '" name="' + args[i].name + '" typ="text"  class="form-control form-control-sm" value="' + args[i].val + '" ' + style + ' ' + editable + ' datachooser="' + column_def[args[i].name].datachooser + '" autocomplete="off" onmousedown="mouseDownEvent(this,event)"  onmouseup="mouseUpEvent(this,event)" onkeypress="enterEvent(this,event)" oninput="keyTypedEvent(this,event)"onkeyup="keyUpEvent(this,event)"></td>';
                } else if (column_def[args[i].name].type == 'select') {
                    row += '<td><select id="' + id + '" name="' + args[i].name + '"  class="form-control form-control-sm" value="' + args[i].val + '" ' + style + ' ' + editable + ' datachooser="' + column_def[args[i].name].datachooser + '" autocomplete="off" onmousedown="mouseDownEvent(this,event)"  onmouseup="mouseUpEvent(this,event)"  oninput="keyTypedEvent(this,event)"onkeyup="keyUpEvent(this,event)"></select></td>';
                } else if (column_def[args[i].name].type == 'button') {
                    var str_id = "'" + ROW_ID + "'";
                    row += '<td><button id="' + id + '" name="' + args[i].name + '"  class="btn btn-danger form-control-sm"  ' + style + '   onclick="deleteRow(' + str_id + ')">X</button></td>';

                }
            }
            row += '</tr>';
            return row;
        }
    })(jQuery);



    dataChooser = $('#dataChooser').dataChooser({
        title: 'Product List',
        action: 'Select',

    });



    $("#dataChooser").on('select', function (event, id, value) {
        var row_id = tbl.getSelectedRow();
        $('#' + row_id + '_' + 0).val(id);
        $('#' + row_id + '_' + 1).val(value);
        $('#dataChooser').hideChooser();
        $('#' + row_id + '_' + 2).focus();
        $('#' + row_id + '_' + 2).select();
        tbl.setStatus(TABLE_ADD);
    });


    $("#dataChooser").on('shown.bs.modal', function (e) {
        $('#search_dataChooser').focus(); //datachooser modal search input
    });


    loadProduct();






});




function enterEvent(col, event) {

    if (event.keyCode == 13) {
        GRN_TABLE.addRow();
    }

}

function keyUpEvent(col, event) {
    if (event.keyCode == 9) {
        SELECTED_ROW = col.parentElement.parentElement.id;
    }
}

function mouseUpEvent(col, event) {
    col.select();
    mouseReleasedOnColumn(col, event);
}

function mouseDownEvent(col, event) {
    SELECTED_ROW = col.parentElement.parentElement.id;
    if (ROW_TIME != undefined) {
        clearTimeout(ROW_TIME);
    }
    mousePressedOnColumn(col, event);
}


function keyTypedEvent(col, event) {
    if (col.getAttribute('datachooser') == 'on') {
        $('#dataChooser').showChooser(event.target.value);
    }

    var row_id = SELECTED_ROW;
    /*if (col.getAttribute('name') == 'qty') {
        var qty = getQty($('#' + row_id + '_' + 0).val());
        if ($('#' + row_id + '_' + 2).val() > qty) {
            showAlert("Out of stock");
            tbl.setStatus(TABLE_CONSUME);
            $('#' + row_id + '_' + 2).css('color', 'red');
        } else if ($('#' + row_id + '_' + 2).val() == '') {
            tbl.setStatus(TABLE_CONSUME);
        } else {
            tbl.setStatus(TABLE_ADD);
            $('#' + row_id + '_' + 2).css('color', 'black');
            var qty = $('#' + row_id + '_' + 2).val();
            var unit_price = $('#' + row_id + '_' + 4).val();
            var cost = poCostPrice(qty, unit_price);
            $('#' + row_id + '_' + 6).val(cost);
        }
    }*/
}



function showAlert(message) {
    swal({
        title: message,
        //text: "Once deleted, you will not be able to recover this record!",
        icon: "warning",
        buttons: true,
        dangerMode: true,
    });

    $('.swal-button').on('click', function () {

    });

}




/*function getQty(id) {
    var qty = 0;
    $.ajax({
        type: "GET",
        url: "/sc/product/getQty/" + id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            qty = response.result;
        },
        error: function (error) {
            console.log(error);
        },
        complete: function () {

        }

    });
    return qty;
}*/


/*function getUnitPrice(id) {
    var price = 0;
    $.ajax({
        type: "GET",
        url: "/product/getUnitPrice/" + id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            price = response.result;
        },
        error: function (error) {
            console.log(error);
        },
        complete: function () {

        }

    });
    return price;
}*/


function loadProduct() {
    $.ajax({
        type: "GET",
        url: "/sc/grnHeaderController/allProduct",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            $('#dataChooser').setDatasource(response.result);
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}


function poCostPrice(qty, unit_price) {

    return (qty * unit_price).toFixed(2);
}


/*function saveTemp() {
    var id = SELECTED_ROW;
    $.ajax({
        type: "POST",
        url: "/sc/grnHeaderController/saveGrnHeaderTemp",
        data: {
            "rand_id": RAND_ID,
            "product_id": $('#' + id + '_0').val(),
            "qty": $('#' + id + '_2').val(),
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');

        },
        complete: function () {

        }

    });
}*/


/*function reset() {

    $.ajax({
        type: "GET",
        url: "/sc/grnHeaderController/reset/" + RAND_ID,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            GRN_TABLE.reset();
            location.reload();

        },
        error: function (error) {
            console.log(error);



        },
        complete: function () {

        }

    });

}*/






function mousePressedOnColumn(col, event) {

}

function mouseReleasedOnColumn(col, event) {

}


function appendProductUnit(id) {

    for (var i = 0; i < product_unit.length; i++) {
        $('#' + id).append('<option value="' + product_unit[i].id + '">' + product_unit[i].name + '</option>')
    }
}


function allProductUnit() {

    $.ajax({
        type: "GET",
        url: "/sc/grnHeaderController/allProductUnit",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response.data.result);
            product_unit = response.data.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}


function deleteRow(id) {
    $('#' + id).remove();
    ROW_COUNT--;
}





