
var ReportTitle = "";

var setting_array = {

    "producttype": null,
    "grouplevel1": null,
    "grouplevel2": null,
    "grouplevel3": null,

};

var REPORT_ID = 0;

$(document).ready(function () {
    allSettings();

    $('#selcProductType').prop("disabled", true);
    $('#selcProductGroupLevel1').prop("disabled", true);
    $('#selcProductGroupLevel2').prop("disabled", true);
    $('#selcProductGroupLevel3').prop("disabled", true);


    $('input[name="startDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });

    $('input[name="endDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });






    $('#checkProductTypeSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcProductType').prop("disabled", false);
            var value = $('#selcSection').val();
            setting_array.producttype = $('#selcProductType').val();
            //allSubsection(value);
        } else {
            $('#selcProductType').prop("disabled", true);
            setting_array.producttype = null;
        }
        //switch_settings('checkSectionSearch');
    });





    $('#checkProductGroupLevel1Search').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcProductGroupLevel1').prop("disabled", false);
            setting_array.grouplevel1 = $('#selcProductGroupLevel1').val();
        } else {
            $('#selcProductGroupLevel1').prop("disabled", true);
            setting_array.grouplevel1 = null;
        }
        //switch_settings('checkCompanySearch');
    });


    $('#checkProductGroupLevel2Search').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcProductGroupLevel2').prop("disabled", false);
            setting_array.grouplevel2 = $('#selcProductGroupLevel2').val();
        } else {
            $('#selcProductGroupLevel2').prop("disabled", true);
            setting_array.grouplevel2 = null;
        }
        //switch_settings('checkTeamSearch');

    });


    $('#checkProductGroupLevel3Search').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcProductGroupLevel3').prop("disabled", false);
            setting_array.grouplevel3 = $('#selcProductGroupLevel3').val();
        } else {
            $('#selcProductGroupLevel3').prop("disabled", true);
            setting_array.grouplevel3 = null;
        }
        //switch_settings('checkTeamSearch');

    });






    $('#selcProductType').change(function () {
        setting_array.producttype = $('#selcProductType').val();
        var title = $(this).find('option:selected').attr('name');

        if (ReportTitle.length == 0) {

            ReportTitle += " for Product Type ( " + title + " )";

        } else {
            ReportTitle += " , Product Type ( " + title + " )";
        }



    });

    $('#selcProductGroupLevel1').change(function () {
        setting_array.grouplevel1 = $('#selcProductGroupLevel1').val();
        var title = $(this).find('option:selected').attr('name');
        if (ReportTitle.length == 0) {

            ReportTitle += " for Group1 ( " + title + " )";

        } else {
            ReportTitle += " , Group1 ( " + title + " )";
        }
    });

    $('#selcProductGroupLevel2').change(function () {
        setting_array.grouplevel2 = $('#selcProductGroupLevel2').val();
        var title = $(this).find('option:selected').attr('name');

        if (ReportTitle.length == 0) {

            ReportTitle += " for Group2 (" + title + " )";

        } else {
            ReportTitle += " , Group2 (" + title + " )";
        }
    });

    $('#selcProductGroupLevel3').change(function () {
        setting_array.grouplevel3 = $('#selcProductGroupLevel3').val();
        var title = $(this).find('option:selected').attr('name');

        if (ReportTitle.length == 0) {

            ReportTitle += " for Group3 (" + title + " )";

        } else {
            ReportTitle += " , Group3 (" + title + " )";
        }
    });






    $('#cmbReport').change(function () {
        REPORT_ID = $(this).val();
        $('#lblEmployee').text('Employee');
        if (REPORT_ID == 1) {
            showDate('DATE_RANGE');
        } else {
            showDate('DATE_RANGE');
        }
    });

});





function allSettings() {

    $.ajax({
        type: "GET",
        url: "/sc/productListReport/allSettings",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var settings = response.data.result.settings;

                appendOption("selcProductType", settings.producttype);
                appendOption("selcProductGroupLevel1", settings.grouplevel1);
                appendOption("selcProductGroupLevel2", settings.grouplevel2);
                appendOption("selcProductGroupLevel3", settings.grouplevel3);


            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}





function appendOption(combobox, result) {

    $('#' + combobox).empty();
    $('#' + combobox).append('<option value="disabled" disabled selected>Select here</option>');
    for (i = 0; i < result.length; i++) {
        $('#' + combobox).append('<option value="' + result[i].id + '" name="' + result[i].value + '">' + result[i].value + '</option>');
    }
}








function settings() {

    return "producttype=" + setting_array.producttype + "&"
        + "grouplevel1=" + setting_array.grouplevel1 + "&"
        + "grouplevel2=" + setting_array.grouplevel2 + "&"
        + "grouplevel3=" + setting_array.grouplevel3;

}


function createReport(flag) {

    if (setting_array.producttype == null && setting_array.grouplevel1 == null && setting_array.grouplevel2 == null && setting_array.grouplevel3 == null) {
        showWarningMessage("Please select setting");
        return;
    }



    if (REPORT_ID == 0) {
        showWarningMessage("Please select Report title");
        return;
    }



    if (REPORT_ID == 1) {

        $.ajax({
            type: "GET",
            url: "/sc/productListReport/Report/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val() + "/" + $('#txtDateTo').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
            },
            success: function (response) {
                // console.log(response);
                var result = response.data.result;
                console.log(result);
                productListReport(result, flag, ReportTitle);
                //location.reload();


            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('.btn').prop("disabled", false);
            }

        });

    }

}









function productListReport(result, flag, reportTitle) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: 'Riococo  Lanka (Pvt) Ltd', fontSize: 16, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', border: [false, false, false, false] }],
                            [{ text: 'Product List Report', fontSize: 14, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', border: [false, false, false, false] }],
                            [{ text: reportTitle, fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [50, 150, 30, '*', '*', '*'],
                headerRows: 1,
                body: productListReportBody(result.body),

            },

        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }


}


function productListReportBody(result) {
    console.log(result);
    var font_size = 8;
    var body = [];
    body.push([{ text: 'Product ID', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Product Name', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Unit', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Group1', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Group2', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Group3', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] }
    ]);
    for (i = 0; i < result.length; i++) {
        body.push([
            { text: result[i].product_id, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].product_name, fontSize: font_size, alignment: 'left', border: [false, false, false, true] },
            { text: result[i].unit, fontSize: font_size, alignment: 'center', border: [false, false, false, true] },
            { text: result[i].group_level_1, fontSize: font_size, alignment: 'left', border: [false, false, false, true] },
            { text: result[i].group_level_2, fontSize: font_size, alignment: 'left', border: [false, false, false, true] },
            { text: result[i].group_level_3, fontSize: font_size, alignment: 'left', border: [false, false, false, true] },
        ]);
    }
    return body;
}







function showDate(args) {

    if (args == 'SINGLE_DATE') {
        $('#endDate').hide();
    } else {
        $('#endDate').show();
    }
}



function _export() {
    createReport('EXPORT');
}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}
