function showModalStores(action, data) {


    var id = "";
    var store = "";
    var prefix = "";
    var site = 0;
    var code = "";
    var button = "Save";

    if (action == 'edit') {
        id = data.id;
        store = data.name;
        prefix = data.prefix;
        site = data.site_id;
        code = data.store_code;
        button = "Update";
    }
    $('#settingsAddModalBody').empty();
    var content = '<div class="form-row">';
    content += '<div class="col-md-12 mb-3" id="divStore">';
    content += '<label for="txtName" id="lblStores">Stores</label>';
    content += '<input type="text" class="form-control" id="txtStore" name="Stores" placeholder="Stores" value="' + store + '" data-id="' + id + '">';
    content += '</div>';
    content += '<div class="col-md-12 mb-3" id="divPrefix">';
    content += '<label for="txtName" id="lblPrefix">Prefix</label>';
    content += '<input type="text" class="form-control" id="txtPrefix" name="Prefix" placeholder="Prefix" value="' + prefix + '">';
    content += '</div>';
    content += '<div class="col-md-12 mb-3">';
    content += '<label for="txtName">Site</label>';
    content += '<select class="form-control" id="txtSite" name="site" ></select>';
    content += '</div>';
    content += '<div class="col-md-12 mb-3" id="divCode">';
    content += '<label for="txtName" id="lblCode">Store Code</label>';
    content += '<input type="text" class="form-control" id="txtCode" name="Code" placeholder="Code" value="' + code + '">';
    content += '</div>';
    content += '</div>';
    $('#settingsAddModalBody').append(content);
    $('#settingsAddModalTitle').text('Stores');
    $('#btnDiv').empty();
    $('#btnDiv').append('<button type="button" class="btn btn-primary" id="btnStores">' + button + '</button');
    $("#settingsAddModal").modal('toggle');
    allSite();

    setSelectedOption('txtSite', site);


    $('#btnStores').on('click', function () {
        var action = $(this).text();

        if (action == 'Save') {
            saveStores();
        } else if (action == 'Update') {
            updateStores();
        }
    });

}



function showModalOrderType(action, data) {


    var id = "";
    var name = "";
    var button = "Save";

    if (action == 'edit') {
        id = data.order_type_id;
        name = data.order_type;
        button = "Update";
    }
    $('#settingsAddModalBody').empty();
    var content = '<div class="form-row">';
    content += '<div class="col-md-12 mb-3" id="divOrderType">';
    content += '<label for="txtName">Order Type</label>';
    content += '<input type="text" class="form-control" id="txtOrderType" name="orderType" placeholder="Order Type" value="' + name + '" data-id="' + id + '">';
    content += '</div>';
    content += '</div>';
    $('#settingsAddModalBody').append(content);
    $('#settingsAddModalTitle').text('Order Type');
    $('#btnDiv').empty();
    $('#btnDiv').append('<button type="button" class="btn btn-primary" id="btnOrderType">' + button + '</button');
    $("#settingsAddModal").modal('toggle');


    $('#btnOrderType').on('click', function () {
        var action = $(this).text();

        if (action == 'Save') {
            saveOrderType();
        } else if (action == 'Update') {
            updateOrderType();
        }
    });

}





function showMaterialRequestReason(action, data) {


    var id = "";
    var name = "";
    var button = "Save";

    if (action == 'edit') {
        id = data.material_request_reason_id;
        name = data.reason;
        button = "Update";
    }
    $('#settingsAddModalBody').empty();
    var content = '<div class="form-row">';
    content += '<div class="col-md-12 mb-3" id="divReason">';
    content += '<label for="txtName">Reason</label>';
    content += '<input type="text" class="form-control" id="txtReason" name="reason" placeholder="Reason" value="' + name + '" data-id="' + id + '">';
    content += '</div>';
    content += '</div>';
    $('#settingsAddModalBody').append(content);
    $('#settingsAddModalTitle').text('Material Request Reason');
    $('#btnDiv').empty();
    $('#btnDiv').append('<button type="button" class="btn btn-primary" id="btnReason">' + button + '</button');
    $("#settingsAddModal").modal('toggle');


    $('#btnReason').on('click', function () {
        var action = $(this).text();

        if (action == 'Save') {
            saveMaterialRequestReason();
        } else if (action == 'Update') {
            updateMaterialRequestReason();
        }
    });

}





function saveStores() {
    $.ajax({
        type: "POST",
        url: '/sc/settingController/saveStores',
        data: {
            'store': $('#txtStore').val(),
            'prefix': $('#txtPrefix').val(),
            'site': $('#txtSite').val(),
            'code': $('#txtCode').val(),
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
            $("#settingsAddModal").modal('hide');
        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                showSuccessMessage("Store has been saved successfully...");
                getAllStores();

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}




function saveOrderType() {
    $.ajax({
        type: "POST",
        url: '/sc/settingController/saveOrderType',
        data: { 'value': $('#txtOrderType').val() },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
            $("#settingsAddModal").modal('hide');
        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                showSuccessMessage("OrderType has been saved successfully...");
                getAllOrderType();

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}



function saveMaterialRequestReason() {
    $.ajax({
        type: "POST",
        url: '/sc/settingController/saveMaterialRequestReason',
        data: { 'value': $('#txtReason').val() },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
            $("#settingsAddModal").modal('hide');
        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                showSuccessMessage("Material Request Reason has been saved successfully...");
                getAllMaterialRequestReason();

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}




function getAllOrderType() {

    $.ajax({
        type: "GET",
        url: '/sc/stockController/getAllOrderType',
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                var result = response.data.result;
                appendTableOrderType(result);

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {
            $('.ti-settings').show();
            $('.spinner-border').hide();
        }

    });
}




function appendTableOrderType(result) {

    var disable = { 0: "", 1: "checked" }
    var tbody = "";


    for (i = 0; i < result.length; i++) {

        var row = "<tr>";
        var str_id = "'" + result[i].order_type_id + "'";
        row += '<td class="id" id="' + result[i].order_type_id + '">' + generateID(result[i].order_type_id) + '</td>';
        row += '<td>' + result[i].order_type + '</td>';
        row += '<td class="edit edit_order_type">';
        row += '<button type="button" class="btn btn-primary setting-edit-btn" id="' + result[i].order_type_id + '" onclick="editOrderType(' + str_id + ')">';
        row += '<i class="fa fa-pencil-square-o" aria-hidden="true"></button>';

        row += '</td>';
        row += '<td class="disable disable_town">';
        row += '<label class="switch">';
        row += '<input type="checkbox"  id="' + result[i].order_type_id + '" onchange="disableOrderType(event,' + str_id + ')" ' + disable[result[i].status] + '>';



        row += '<span class="slider round"></span>';
        row += '</label>';
        row += '</td>';
        row += '</tr>';
        tbody += row;
    }
    $('#tblOrderType').empty();
    $('#tblOrderType').append(tbody);
}






function getAllStores() {

    $.ajax({
        type: "GET",
        url: '/sc/stockController/getAllStores',
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                var result = response.data.result;
                appendTableStores(result);

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {
            $('.ti-settings').show();
            $('.spinner-border').hide();
        }

    });
}





function appendTableStores(result) {

    var disable = { 0: "", 1: "checked" }
    var tbody = "";


    for (i = 0; i < result.length; i++) {

        var row = "<tr>";
        var str_id = "'" + result[i].id + "'";
        row += '<td class="id" id="' + result[i].id + '">' + generateID(result[i].id) + '</td>';
        row += '<td>' + result[i].name + '</td>';
        row += '<td>' + result[i].prefix + '</td>';
        row += '<td class="edit edit_stores">';
        row += '<button type="button" class="btn btn-primary setting-edit-btn" id="' + result[i].id + '" onclick="editStores(' + str_id + ')">';
        row += '<i class="fa fa-pencil-square-o" aria-hidden="true"></button>';

        row += '</td>';
        row += '<td class="disable disable_town">';
        row += '<label class="switch">';
        row += '<input type="checkbox"  id="' + result[i].id + '" onchange="disableStores(event,' + str_id + ')" ' + disable[result[i].status] + '>';



        row += '<span class="slider round"></span>';
        row += '</label>';
        row += '</td>';
        row += '</tr>';
        tbody += row;
    }
    $('#tblStores').empty();
    $('#tblStores').append(tbody);
}





function getAllMaterialRequestReason() {

    $.ajax({
        type: "GET",
        url: '/sc/stockController/getAllMaterialRequestReason',
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                var result = response.data.result;
                appendMaterialRequestReason(result);

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {
            $('.ti-settings').show();
            $('.spinner-border').hide();
        }

    });
}




function appendMaterialRequestReason(result) {

    var disable = { 0: "", 1: "checked" }
    var tbody = "";


    for (i = 0; i < result.length; i++) {

        var row = "<tr>";
        var str_id = "'" + result[i].material_request_reason_id + "'";
        row += '<td class="id" id="' + result[i].order_type_id + '">' + generateID(result[i].material_request_reason_id) + '</td>';
        row += '<td>' + result[i].reason + '</td>';
        row += '<td class="edit edit_reason">';
        row += '<button type="button" class="btn btn-primary setting-edit-btn" id="' + result[i].material_request_reason_id + '" onclick="editMaterialRequestReason(' + str_id + ')">';
        row += '<i class="fa fa-pencil-square-o" aria-hidden="true"></button>';

        row += '</td>';
        row += '<td class="disable disable_town">';
        row += '<label class="switch">';
        row += '<input type="checkbox"  id="' + result[i].material_request_reason_id + '" onchange="disableMaterialRequestReason(event,' + str_id + ')" ' + disable[result[i].status] + '>';



        row += '<span class="slider round"></span>';
        row += '</label>';
        row += '</td>';
        row += '</tr>';
        tbody += row;
    }
    $('#tblMaterialRequestReason').empty();
    $('#tblMaterialRequestReason').append(tbody);
}





function editOrderType(id) {
    $.ajax({
        type: "GET",
        url: '/sc/stockController/getOrderType/' + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                var result = response.data.result;
                showModalOrderType('edit', result);


            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {
            $('.ti-settings').show();
            $('.spinner-border').hide();
        }

    });
}





function editStores(id) {
    $.ajax({
        type: "GET",
        url: '/sc/stockController/getStore/' + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                var result = response.data.result;
                showModalStores('edit', result);


            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {
            $('.ti-settings').show();
            $('.spinner-border').hide();
        }

    });
}





function editMaterialRequestReason(id) {
    $.ajax({
        type: "GET",
        url: '/sc/stockController/getMaterialRequestReason/' + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                var result = response.data.result;
                showMaterialRequestReason('edit', result);


            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {
            $('.ti-settings').show();
            $('.spinner-border').hide();
        }

    });
}




function updateOrderType() {

    $.ajax({
        type: "PUT",
        url: '/sc/stockController/updateOrderType/' + $('#txtOrderType').attr('data-id'),
        data: {
            'value': $('#txtOrderType').val()
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
            $("#settingsAddModal").modal('hide');
        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                showSuccessMessage("Order Type has been updated successfully...");
                getAllOrderType();


            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}







function updateStores() {

    $.ajax({
        type: "PUT",
        url: '/sc/stockController/updateStores/' + $('#txtStore').attr('data-id'),
        data: {
            'store': $('#txtStore').val(),
            'prefix': $('#txtPrefix').val(),
            'site': $('#txtSite').val(),
            'code': $('#txtCode').val(),
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
            $("#settingsAddModal").modal('hide');
        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                showSuccessMessage("Store has been updated successfully...");
                getAllStores();


            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}




function updateMaterialRequestReason() {

    $.ajax({
        type: "PUT",
        url: '/sc/stockController/updateMaterialRequestReason/' + $('#txtReason').attr('data-id'),
        data: {
            'value': $('#txtReason').val()
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
            $("#settingsAddModal").modal('hide');
        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                showSuccessMessage("Material Request Reason has been updated successfully...");
                getAllMaterialRequestReason();


            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}




function disableStores(event, id) {


    var status = event.target.checked;
    var bool = 0;
    if (status) bool = 1;

    $.ajax({
        type: "PUT",
        url: '/sc/stockController/disableStores/' + id,
        data: {
            'status': bool,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
            $("#settingsAddModal").modal('hide');
        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                if (status) showSuccessMessage("Data has been enabled successfully...");
                if (!status) showSuccessMessage("Data has been disabled successfully...");
                getAllStores();


            } else {
                var msg = response.data.message;
                var id = response.data.result;

                if (msg == "assigned") {//assigned settings cannot be disabled
                    showWarningMessage("Settings has been assigned...!");
                    getAllStores();
                } else if (msg == "error") {
                    showErrorMessage();
                }
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}






function disableOrderType(event, id) {


    var status = event.target.checked;
    var bool = 0;
    if (status) bool = 1;

    $.ajax({
        type: "PUT",
        url: '/sc/stockController/disableOrderType/' + id,
        data: {
            'status': bool,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
            $("#settingsAddModal").modal('hide');
        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                if (status) showSuccessMessage("Data has been enabled successfully...");
                if (!status) showSuccessMessage("Data has been disabled successfully...");
                getAllStores();


            } else {
                var msg = response.data.message;
                var id = response.data.result;

                if (msg == "assigned") {//assigned settings cannot be disabled
                    showWarningMessage("Settings has been assigned...!");
                    getAllStores();
                } else if (msg == "error") {
                    showErrorMessage();
                }
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}






function disableMaterialRequestReason(event, id) {


    var status = event.target.checked;
    var bool = 0;
    if (status) bool = 1;

    $.ajax({
        type: "PUT",
        url: '/sc/stockController/disableMaterialRequestReason/' + id,
        data: {
            'status': bool,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
            $("#settingsAddModal").modal('hide');
        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                if (status) showSuccessMessage("Data has been enabled successfully...");
                if (!status) showSuccessMessage("Data has been disabled successfully...");
                getAllMaterialRequestReason();


            } else {
                var msg = response.data.message;
                var id = response.data.result;

                if (msg == "assigned") {//assigned settings cannot be disabled
                    showWarningMessage("Settings has been assigned...!");
                    getAllMaterialRequestReason();
                } else if (msg == "error") {
                    showErrorMessage();
                }
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}











function allSite() {

    $.ajax({
        type: "GET",
        url: "/sc/settings/allSite",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var site = response.data.result;
                appendSiteOption("txtSite", site);

            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}



function appendSiteOption(combobox, result) {

    $('#' + combobox).empty();
    $('#' + combobox).append('<option value="disabled" disabled selected>Select here</option>');
    for (i = 0; i < result.length; i++) {
        $('#' + combobox).append('<option value="' + result[i].site_id + '">' + result[i].site + '</option>');
    }
}



function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}



/**
* generateID
* This function is used to generate id
* @param id This is the paramter to require id
*/
function generateID(id) {

    let pattern = {
        1: "0000",
        2: "000",
        3: "00",
        4: "0",
    };
    var length = Math.ceil(Math.log(id + 1) / Math.LN10);
    return pattern[length] + id;
}


/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {

    toastr.success(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}


/**
* showWarrningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {

    toastr.warning(message);
}
