var DATA_CHOOSER_HIDE_STATUS = false;
$(document).ready(function () {
    var TRANSACTION_DELAY = 0;
    (function ($) {
        $.fn.transactionTable = function (property) {
            this.ID = this[0].id;
            this.thead = property.thead;
            this.column_def = property.column_def;
            this.data_array = [];
            this.ROW_ID = 0;
            this.text_array = [];
            this.row_type = property.row_type;
            this.data_chooser_col = property.data_chooser;
            this.selected_row = undefined;
            this.auto_focus = property.auto_focus;
            this.selected_row_id = undefined;
            this.chooser = property.chooser;
            create_Thead(this, this.thead, this.column_def);
            setInterval(function () {
                TRANSACTION_DELAY++;
            }, 1);
            this.add_empty_row = function (event) {
                var row = [];
                for (var i = 0; i < this.row_type.length; i++) {
                    if (this.row_type[i].type == 'string') {
                        row.push({ type: 'string', val: this.row_type[i].value, align: this.row_type[i].align, width: this.row_type[i].width });
                    } else if (this.row_type[i].type == 'text') {
                        row.push({ type: 'text', val: this.row_type[i].value, align: this.row_type[i].align, width: this.row_type[i].width });
                    } else if (this.row_type[i].type == 'select') {
                        row.push({ type: 'select', val: this.row_type[i].value, align: this.row_type[i].align, width: this.row_type[i].width });
                    } else if (this.row_type[i].type == 'hidden') {
                        row.push({ type: 'hidden', val: this.row_type[i].value, align: this.row_type[i].align, width: 0 });
                    } else if (this.row_type[i].type == 'icon') {
                        row.push({ type: 'icon', val: this.row_type[i].value, align: this.row_type[i].align, width: this.row_type[i].width });
                    } else if (this.row_type[i].type == 'remove') {
                        row.push({ type: 'remove', val: this.row_type[i].value, align: this.row_type[i].align, width: this.row_type[i].width });
                    }
                }
                this.addRow(row);
                TRANSACTION_DELAY = 0;
            };
            this.setDataChooserHideStatus = function (status) {
                DATA_CHOOSER_HIDE_STATUS = status;
            };
            this.addRow = function (data) {
                this.data_array.push(data);
                add_row(this, data);
                addEnterEvent(this, this.text_array);
                $('#' + this.ID + ' td:nth-child(1),#' + this.ID + ' th:nth-child(1)').hide();
            };
            this.updateRow = function (data) {
                update_row(this, data);
            };
            this.getSelectedRow = function () {
                return this.selected_row;
            };
            this.reset = function () {
                $('#' + this.ID).empty();
                create_Thead(this, this.thead, this.column_def);
                this.add_empty_row();
            }
            this.clear = function () {
                $('#' + this.ID).empty();
                create_Thead(this, this.thead, this.column_def);
            }
            this.rowCount = function () {
                return $('#' + this.attr('id') + ' >tr').length;
            };
            this.getTransactionDelay = function () {
                return TRANSACTION_DELAY;
            };
            this.dataSource = function () {

                var row_count = $('#' + this.attr('id') + ' >tr').length;
                var data = [];
                for (var i = 1; i < row_count; i++) {
                    var col = [];
                    var head = this.thead;
                    for (var i2 = 0; i2 < head.length; i2++) {

                        col.push(this[0].rows[i].cells[i2].childNodes[0].value);
                    }

                    data.push(col);
                }
                return data;
            };
            return this;
        };
    })(jQuery);

});


function create_Thead(table, header, column_def) {


    var thead = '<tr>';
    for (var i = 0; i < header.length; i++) {
        if (column_def != undefined && column_def[i] != undefined) {
            if (table.row_type[i].type == 'hidden') {
                thead += '<th hidden>' + header[i] + '</th>';
            } else {
                thead += '<th>' + header[i] + '</th>';
            }
        } else {
            if (table.row_type[i].type == 'hidden') {
                thead += '<th hidden>' + header[i] + '</th>';
            } else {
                thead += '<th>' + header[i] + '</th>';
            }
        }

    }
    thead += '</tr>';
    table.append(thead);


}


function add_row(table, data) {

    table.ROW_ID += 1;
    table.selected_row_id = table.attr('id') + '_row_' + table.ROW_ID;
    var row = '<tr id="' + table.selected_row_id + '" style="padding:0px">';
    var table_id = "'" + table.ID + "'";
    var selected_row = "'" + table.selected_row + "'";
    for (var i = 0; i < data.length; i++) {

        if (data[i].type == 'string') {

            row += '<td id="' + table.attr('id') + '_row_' + table.ROW_ID + '_' + '_col_' + i + '" style="padding:2px;width:' + data[i].width + '"><input id="' + table.attr('id') + '_row_' + table.ROW_ID + '_' + '_col_' + i + '_string" class="form-control form-control-sm" type="text" value="' + data[i].val + '" readonly data_chooser ="false" style="text-align:' + data[i].align + ';width:' + data[i].width + '"></td>';

        } else if (data[i].type == 'text') {

            table.text_array.push(table.attr('id') + '_row_' + table.ROW_ID + '_' + '_col_' + i + '_text');
            row += '<td id="' + table.attr('id') + '_row_' + table.ROW_ID + '_' + '_col_' + i + '" style="padding:2px;width:' + data[i].width + '"><input id="' + table.attr('id') + '_row_' + table.ROW_ID + '_' + '_col_' + i + '_text" class="form-control form-control-sm" type="text" value="' + data[i].val + '" data_chooser ="false" style="text-align:' + data[i].align + ';width:' + data[i].width + '" oninput="triggerRowInputs(' + table_id + ',' + selected_row + ');"></td>';

        } else if (data[i].type == 'select') {

            var select_tag = '<select class="form-control form-control-sm" id="' + table.attr('id') + '_row_' + table.ROW_ID + '_' + '_col_' + i + '_select"  data_chooser ="false" style="text-align:' + data[i].align + ';width:' + data[i].width + '" disabled >';
            for (var i2 = 0; i2 < data[i].val.length; i2++) {
                select_tag += '<option  value="' + data[i].val[i2].value + '" style="text-align:' + data[i].align + ';width:' + data[i].width + '">' + data[i].val[i2].text + '</option>';
            }
            select_tag += '</select>';
            row += '<td id="' + table.attr('id') + '_row_' + table.ROW_ID + '_' + '_col_' + i + '" style="padding:2px;width:' + data[i].width + '">' + select_tag + '</td>';

        } else if (data[i].type == 'hidden') {

            row += '<td id="' + table.attr('id') + '_row_' + table.ROW_ID + '_' + '_col_' + i + '" style="padding:2px;width:' + data[i].width + '" hidden><input id="' + table.attr('id') + '_row_' + table.ROW_ID + '_' + '_col_' + i + '_hidden" class="form-control form-control-sm" type="text" value="' + data[i].val + '" readonly data_chooser ="false" style="text-align:' + data[i].align + ';width:' + data[i].width + '" hidden></td>';

        } else if (data[i].type == 'icon') {

            row += '<td id="' + table.attr('id') + '_row_' + table.ROW_ID + '_' + '_col_' + i + '" style="padding:2px;width:' + data[i].width + '">' + data[i].val + '</td>';

        } else if (data[i].type == 'remove') {

            var id = "'" + table.attr('id') + '_row_' + table.ROW_ID + "'";
            var tbl_id = "'" + table.attr('id') + "'";
            row += '<td id="' + table.attr('id') + '_row_' + table.ROW_ID + '_' + '_col_' + i + '" style="padding:2px"><button class="btn btn-danger form-control-sm" id="' + table.attr('id') + '_row_' + table.ROW_ID + '_' + '_col_' + i + '_remove" onclick="remove_row(' + tbl_id + ',' + id + ')" data_chooser ="false" style="text-align:' + data[i].align + ';width:' + data[i].width + '">' + data[i].val + '</button></td>';
        }


    }
    row += '</tr>';
    table.append(row);

    if (table.data_chooser_col != undefined) {
        var row_count = $('#' + table.attr('id') + ' >tr').length;
        for (var i = 1; i < row_count; i++) {
            for (var i2 = 0; i2 < table.data_chooser_col.length; i2++) {
                var id = table[0].rows[i].cells[table.data_chooser_col[i2].col].childNodes[0].id;
                $('#' + id).attr('data_chooser', true);
            }
        }
    }


    if (table.auto_focus != undefined) {

        document.getElementById(table.selected_row_id).childNodes[table.auto_focus].childNodes[0].focus();
        table.selected_row = document.getElementById(table.selected_row_id);
        triggerRowInputs(table.ID, table.selected_row);

    }



}



function update_row(table, data) {


}



function addEnterEvent(table, text) {


    for (var i = 0; i < text.length; i++) {
        var input = document.getElementById(text[i]);

        // Execute a function when the user presses a key on the keyboard
        if (input) {
            input.addEventListener("keypress", textEventListener);
            input.addEventListener("keyup", textKeyUpEvent);
            input.chooser = table.chooser;
            input.closest("tr").onclick = function (event) {
                table.selected_row = event.currentTarget.closest('tr');
                // triggerRowInputs(table.ID, table.selected_row);
            };
            input.addEventListener('focus', (event) => {
                table.selected_row = event.currentTarget.closest('tr');
                //triggerRowInputs(table.ID, table.selected_row);
                return;
            });
            input.table = table;
        }
    }
}



function textEventListener(event) {

    console.log(event.keyCode);
    if (event.keyCode == 13) {
        textKeyEnterEvent(event);
    } else {
        //textKeyUpEvent(event);

    }


}



function textKeyEnterEvent(event) {
    var table = event.currentTarget.table;
    table.add_empty_row();
    for (var i = 0; i < table.row_type.length; i++) {
        if (table.row_type[i] == 'text') {
            $('#' + table.attr('id') + '_row_' + table.ROW_ID + '_' + '_col_' + i + '_text').focus();
            break;
        }
    }
}




function textKeyUpEvent(event) {


    if (event.keyCode != 13) {
        var id = event.target.id;
        var obj = $('#' + id);
        if (obj.attr('data_chooser') == "true") {
            if (event.currentTarget.chooser) {
                if (!DATA_CHOOSER_HIDE_STATUS) {
                    event.currentTarget.chooser.showChooser(obj);
                }
            }
        }
    }

    textKeyTyped(event);

}


function remove_row(table_id, id) {
    $('#' + id).remove();
    TRANSACTION_DELAY = 0;
    transactionTableUpdate(table_id);
}




function transactionTableUpdate(table_id) { }







