<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMiHeadersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sc_mi_headers', function (Blueprint $table) {
            $table->id('internal_id');
            $table->string('external_id', 100);
            $table->string('ref_internal_id',100);
            $table->string('ref_external_id',100);
            $table->date('trans_date');
            $table->integer('dept_id');
            $table->integer('machine_id')->nullable();
            $table->integer('store_id');
            $table->integer('supervisor_id');
            $table->string('employee_name',100);
            $table->string('mr_internal_id',30);
            $table->string('mr_extenal_id',30);
            $table->string('document_no',30);
            $table->integer('mi_type');
            $table->integer('schedule_customer_order_plan_id')->nullable();
            $table->string('manufacturing_order_number',100)->nullable();
            $table->string('vehicle_no', 45)->nullable();
            $table->string('project_code', 100)->nullable();
            $table->string('remarks',200)->nullable();
            $table->integer('status');
            $table->integer('user_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mi_headers');
    }
}
