<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGoodsReceivedMrsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sc_goods_received_mrs', function (Blueprint $table) {
            $table->id('internal_id');
            $table->string('refferance_no',100);
            $table->date('trans_date');
            $table->string('supplier_id',50);
            $table->string('received_by',50);
            $table->integer('site_id');
            $table->integer('store_id');
            $table->string('supplier_reff_no',50)->nullable();
            $table->string('po_no',50)->nullable();
            $table->string('vehicle_no',50)->nullable();
            $table->string('driver_name',50)->nullable();
            $table->string('weigh_bill_no',50)->nullable();
            $table->integer('product_primary_id');
            $table->string('first_weight',50)->nullable();
            $table->dateTime('first_weight_time')->nullable();
            $table->string('second_weight',50)->nullable();
            $table->dateTime('second_weight_time')->nullable();
            $table->string('net_weight',50)->nullable();
            $table->string('comment',50)->nullable();
            $table->string('wastage',50)->nullable();
            $table->string('moisture',50)->nullable();
            $table->string('sand',50)->nullable();
            $table->string('ec_level',50)->nullable();
            $table->integer('status');
            $table->integer('document_no');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('goods_received_mrs');
    }
}
