<?php

namespace Modules\Sc\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class BagCuttingCenter extends Model
{
    use HasFactory,LogsActivity;
    protected $table = 'sc_bags_cutting_centers';
    protected $primaryKey = 'bags_cutting_centers_id';
    protected $fillable = [];
    protected static $logAttributes = [
        'bags_cutting_centers_id',
        'name',
        'status',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "sc_bags_cutting_centers";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
