<?php

namespace Modules\Sc\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class BagCuttingDispatchData extends Model
{
    use HasFactory,LogsActivity;
    protected $table = 'sc_bags_cutting_dispatch_data';
    protected $primaryKey = 'bags_cutting_dispatch_data_id';
    protected $fillable = [];
    protected static $logAttributes = [
        'bags_cutting_dispatch_data_id',
        'internal_id',
        'external_id',
        'product_id',
        'unit_id',
        'quantity',
        'comments'
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "sc_bags_cutting_dispatch_data";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
    
   
}
