<?php

namespace Modules\Sc\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class BagGoodsTransferHeader extends Model
{
    use HasFactory,LogsActivity;

    protected $fillable = [];
    protected $table = 'sc_bags_goods_transfer_headers';
    protected $primaryKey = 'internal_id';
    protected static $logAttributes = [
        'internal_id',
        'external_id',
        'ref_internal_id',
        'ref_external_id',
        'trans_date',
        'store_from_id',
        'store_to_id',
        'mr_internal_id',
        'customer_order_plan_data_id',
        'status',
        'document_no',
        'user_id',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "sc_bags_goods_transfer_headers";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
    // protected static function newFactory()
    // {
    //     return \Modules\Sc\Database\factories\BagGoodsTransferHeaderFactory::new();
    // }
}
