<?php

namespace Modules\Sc\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class Department extends Model
{
    use HasFactory,LogsActivity;
    protected $table = 'sc_departments';
    protected $fillable = [];
    protected static $logAttributes = [
        'id',
        'department',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "sc_departments";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
    
    /*protected static function newFactory()
    {
        return \Modules\Sc\Database\factories\DepartmentFactory::new();
    }*/
}
