<?php

namespace Modules\Sc\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class GoodsReceivedMr extends Model
{
    use HasFactory,LogsActivity;
    protected $table = 'sc_goods_received_mrs';
    protected $primaryKey = 'internal_id';
    protected $fillable = [];
    protected static $logAttributes = [
        'internal_id',
        'refferance_no',
        'trans_date',
        'supplier_id',
        'material_plant_id',
        'received_by',
        'site_id',
        'store_id',
        'supplier_reff_no',
        'po_no',
        'vehicle_no',
        'finders',
        'volume',
        'no_of_empty_bags',
        'driver_name',
        'weigh_bill_no',
        'product_primary_id',
        'first_weight',
        'first_weight_time',
        'second_weight',
        'second_weight_time',
        'net_weight',
        'comment',
        'wastage',
        'moisture',
        'sand',
        'ec_level',
        'status',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "sc_goods_received_mrs";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }

}
