<?php

namespace Modules\Sc\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class GoodsTransferHeaderMR extends Model
{
    use HasFactory,LogsActivity;
    protected $table = 'sc_goods_transfer_header_m_rs';
    protected $primaryKey = 'internal_id';
    protected $fillable = [];
    protected static $logAttributes = [
        'internal_id',
        'external_id',
        'ref_internal_id',
        'ref_external_id',
        'trans_date',
        'store_from_id',
        'store_to_id',
        'mr_internal_id',
        'status',
        'document_no',
        'first_weight',
        'first_weight_time',
        'second_weight',
        'second_weight_time',
        'net_weight',
        'po_no',
        'customer_order_plan_id',
        'vehicle_no',
        'finders',
        'volume',
        'no_of_bags',
        'driver_name',
        'weigh_bill_no',
        'wastage',
        'moisture',
        'sand',
        'ec_level',
        'comment',
        'user_id'
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "sc_goods_transfer_header_m_rs";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
    
    /*protected static function newFactory()
    {
        return \Modules\Sc\Database\factories\GoodsTransferHeaderMRFactory::new();
    }*/
}
