<?php

namespace Modules\Sc\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class MaterialRequisitionHeader extends Model
{
    use HasFactory,LogsActivity;
    protected $table = 'sc_material_requisition_headers';
    protected $primaryKey = 'internal_id';
    protected $fillable = [];
    protected static $logAttributes = [
        'internal_id',
        'external_id',
        'ref_internal_id',
        'ref_external_id',
        'trans_date',
        'dept_id',
        'machine_id',
        'store_id',
        'supervisor_id',
        'employee_name',
        'mi_type',
        'customer_order_plan_data_id',
        'manufacturing_order_number',
        'vehicle_no',
        'material_request_reason_id',
        'project_code',
        'remarks'
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "sc_material_requisition_headers";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
    
    /*protected static function newFactory()
    {
        return \Modules\Sc\Database\factories\MaterialRequisitionHeaderFactory::new();
    }*/
}
