<?php

namespace Modules\Sc\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class ProductHistorySetoff extends Model
{
    use HasFactory,LogsActivity;
    protected $table = 'sc_product_history_setoffs';
    protected $primaryKey = 'transaction_id';
    protected $fillable = [];
    protected static $logAttributes = [
        'transaction_id',
        'document_no',
        'internal_id',
        'external_id',
        'ref_internal_id',
        'ref_external_id',
        'ref_document_no',
        'quantity',
        'setoff_quantity',
        'cost_price',
        'grn_internal_id',
        'grn_external_id',
        'product_id',
        'store_id',
	'store_type',
        'user_id',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "sc_product_history_setoffs";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
    /*protected static function newFactory()
    {
        return \Modules\Sc\Database\factories\ProductHistorySetoffFactory::new();
    }*/
}
