<?php

namespace Modules\Sc\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class PurchaseOrderAttachment extends Model
{
    use HasFactory,LogsActivity;
    protected $table = 'sc_purchase_order_attachments';
    protected $primaryKey = 'purchase_order_attachment_id';
    protected $fillable = [];
    protected static $logAttributes = [
        'purchase_order_attachment_id',
        'purchase_order_id',
        'path',
        'token',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "sc_purchase_order_attachments";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
    
}
