<?php

namespace Modules\Sc\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class RawMaterialPlant extends Model
{
    use HasFactory,LogsActivity;
    protected $table = 'sc_raw_material_plants';
    protected $primaryKey = 'raw_material_plant_id';
    protected $fillable = [];
    protected static $logAttributes = [
        'raw_material_plant_id',
        'name',
        'status',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "sc_raw_material_plants";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
