<?php

namespace Modules\Sc\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Fm\Entities\SupplierInvoiceData;
use Modules\Hr\Entities\Employee;
use Modules\Pp\Entities\Machinary;
use Modules\Sc\Entities\Department;
// use Modules\Sc\Entities\BagGrnData;
// use Modules\Sc\Entities\BagGrnHeader;
use Modules\Sc\Entities\BagCuttingReturnHeader;
use Modules\Sc\Entities\BagCuttingReturnData;
use Modules\Sc\Entities\BagCuttingCenter;
use Modules\Sc\Entities\ProductHistorySetoff;
use Modules\Sc\Entities\StoreLocation;
use Modules\St\Entities\Product;
use Modules\St\Entities\ProductUnit;
use Modules\St\Entities\Suppliers;
use Modules\St\Entities\Uom;
use PDO;

class BagsCuttingReturnListController extends Controller
{


    public function allCuttingReturn()
    {
        try {
            $grnList = BagCuttingReturnHeader::where('document_no', '=', '350')->orderBy('internal_id', 'DESC')->get();
            foreach ($grnList as $grn) {
                $grn->cutting_center = "";
                $cutting_center = BagCuttingCenter::find($grn->cutting_center_id);
                if ($cutting_center) {
                    $grn->cutting_center = $cutting_center->name;
                }

                $grn->supplier = "";
                $supplier = Suppliers::find($grn->supplier_Id);
                if ($supplier) {
                    $grn->supplier = $supplier->supplier_name;
                }
            }
            $responseBody = $this->responseBody(true, "BagsCuttingReturnListController", "allCuttingReturn", $grnList);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "BagsCuttingReturnListController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function bagsCuttingReturnReport($id)
    {
        try {
            $grn = BagCuttingReturnHeader::find($id);

            $header = [
                "referance_no" => "",
                "date" => "",
                "supplier" => "",
                "cutting_center" => "",
                "received_by" => "",
                "store" => "",
                "supplier_ref_no" => "",
                "po_no" => "",
                "transport_by" => "",
                "vehicle_no" => "",
                "no_of_items" => "0.00",
                "printing_damage" => "",
                "seal_damage" => "",
                "gazzet_isses" => "",
                "other_damage" => "",
                "company_damage" => "",
                "cutting_damage" => "",
                "total_damage" => "",
                "remarks" => "",              
            ];


            if ($grn) {

                if ($grn->external_id) {
                    $header["referance_no"] = $grn->external_id;
                }
                if ($grn->trans_date) {
                    $header["date"] = $grn->trans_date;
                }
                if ($grn->trans_date) {
                    $header["date"] = $grn->trans_date;
                }
                if ($this->getCuttingCenter($grn->cutting_center_id)) {
                    $header["cutting_center"] = $this->getCuttingCenter($grn->cutting_center_id);
                }
                if ($this->getSupplier($grn->supplier_Id)) {
                    $header["supplier"] = $this->getSupplier($grn->supplier_Id);
                }
                if ($this->getReceivedBy($grn->received_by)) {
                    $header["received_by"] = $this->getReceivedBy($grn->received_by);
                }
                if ($this->getStore($grn->store_id)) {
                    $header["store"] = $this->getStore($grn->store_id);
                }
                if ($grn->supplier_ref_no) {
                    $header["supplier_ref_no"] = $grn->supplier_ref_no;
                }
                if ($grn->purchase_order_no) {
                    $header["po_no"] = $grn->purchase_order_no;
                }
                if ($grn->transport_by) {
                    $header["transport_by"] = $grn->transport_by;
                }
                if ($grn->vehicle_no) {
                    $header["vehicle_no"] = $grn->vehicle_no;
                }
                if ($grn->printing_damage) {
                    $header["printing_damage"] = $grn->printing_damage;
                }
                if ($grn->seal_damage) {
                    $header["seal_damage"] = $grn->seal_damage;
                }
                if ($grn->gazzet_isses) {
                    $header["gazzet_isses"] = $grn->gazzet_isses;
                }
                if ($grn->other_damage) {
                    $header["other_damage"] = $grn->other_damage;
                }
                if ($grn->company_damage) {
                    $header["company_damage"] = $grn->company_damage;
                }
                if ($grn->cutting_damage) {
                    $header["cutting_damage"] = $grn->cutting_damage;
                }
                if ($grn->total_damage) {
                    $header["total_damage"] = $grn->total_damage;
                }
                if ($grn->remarks) {
                    $header["remarks"] = $grn->remarks;
                }
            }

            $data = BagCuttingReturnData::where('internal_id', '=', $id)->get();
            $total_value = 0.0;
            foreach ($data as $dd) {
                $dd->cost_price = 0.00;
                $product = Product::find($dd->product_id);
                $dd->product_id = $product->product_id;
                $dd->product = $product->product_name;
                $uom = ProductUnit::find($dd->unit_id);

                if ($uom) {
                    $dd->unit = $uom->name;
                } else {
                    $dd->unit = '';
                }
                $product_history = ProductHistorySetoff::where('internal_id', '=', $dd->internal_id)->first();
                if ($product_history) {
                    $dd->cost_price = $product_history->cost_price;
                }
                //$price = 0;
                //$value = 0;
                //$supplier_invoice_data = SupplierInvoiceData::where([['grn_internal_id', '=', $dd->internal_id], ['product_id', '=', $product->product_primary_id],['grn_data_id','=',$dd->grn_data_id]])->first();
                //dd($data->product_id);

                /*if ($supplier_invoice_data) {
                    $price  =  $supplier_invoice_data->price;
                    $value  =  $supplier_invoice_data->value;
                }
                $dd->price = $price;*/
                $dd->value = ($dd->price *  $dd->quantity);
                $total_value += $dd->value;
            }
            $header["total_value"] = $total_value;


            $responseBody = $this->responseBody(true, "BagsCuttingReturnListController", "bagsCuttingReturnReport", ["header" => $header, "body" => ["data" => $data]]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "BagsCuttingReturnListController", "bagsCuttingReturnReport", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    private function getCuttingCenter($id)
    {
        $cutting_center = BagCuttingCenter::find($id);
        if ($cutting_center) {
            return $cutting_center->name;
        }
        return "";
    }



    private function getSupplier($id)
    {

        $supplier = Suppliers::find($id);
        if ($supplier) {
            return $supplier->supplier_name;
        }
        return "";
    }


    private function getReceivedBy($id)
    {

        $received = Employee::find($id);
        if ($received) {
            return $received->name_withinitial;
        }
        return "";
    }



    private function getDepartment($id)
    {

        $department = Department::find($id);
        if ($department) {
            return $department->department;
        }
        return "";
    }


    private function getStore($id)
    {
        $store = StoreLocation::find($id);
        if ($store) {
            return $store->name;
        }
        return "";
    }



    private function getType($id)
    {
        if ($id == 0) {
            return "General";
        } else if ($id == 1) {
            return "Production";
        } else if ($id == 2) {
            return "Maintenance";
        }
        return "";
    }



    private function getMachine($id)
    {
        $machine = Machinary::find($id);
        if ($machine) {
            return $machine->machinery_no;
        }
        return "";
    }

    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
