<?php

namespace Modules\Sc\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Sc\Entities\GoodsReceivedMr;
use Modules\St\Entities\Product;
use Modules\Sc\Entities\ProductHistorySetoff;
use Modules\St\Entities\ProductUnit;
use Modules\Sc\Entities\StoreLocation;
use Modules\Hr\Entities\Employee;
use Modules\Sc\Entities\Department;
use Modules\St\Entities\Suppliers;
use Modules\St\Entities\Uom;

class GoodsReceivedMrListController extends Controller
{


    public function allGoodsReceivedMR()
    {
        try {
            $gr_mr =  DB::select('SELECT sc_goods_received_mrs.internal_id,
            sc_goods_received_mrs.refferance_no,
            sc_goods_received_mrs.status,
            st_suppliers.supplier_name,
            sc_raw_material_plants.name AS material_plant_name,
            sc_goods_received_mrs.trans_date,
            st_products.product_name,
            sc_goods_received_mrs.wastage
            FROM sc_goods_received_mrs 
            LEFT JOIN st_suppliers ON sc_goods_received_mrs.supplier_id = st_suppliers.supplier_id
            LEFT JOIN sc_raw_material_plants ON sc_goods_received_mrs.material_plant_id = sc_raw_material_plants.raw_material_plant_id
            INNER JOIN st_products ON sc_goods_received_mrs.product_primary_id = st_products.product_primary_id  
            ORDER BY sc_goods_received_mrs.internal_id DESC');
            $responseBody = $this->responseBody(true, "GoodsReceivedMrListController", "allGoodsReceivedMR", $gr_mr);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsReceivedMrListController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function delete($id)
    {
        try {
            $gr_mr = GoodsReceivedMr::find($id);
            if ($gr_mr) {
                $gr_mr->delete();
            }
            $responseBody = $this->responseBody(true, "GoodsReceivedMrListController", "delete", true);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsReceivedMrListController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function goodsReceivedMRReport($id)
    {
        
       
        try {
            $grn = GoodsReceivedMr::find($id);

            $header = [
                "referance_no" => "",
                "date" => "",
                "supplier" => "",
                "received_by" => "",
                "store" => "",
                "store_from" => "",
                "store_to" => "",
                "supplier_ref_no" => "",
                "po_no" => "",
                "order_no" => "",
                "transport_by" => "",
                "vehicle_no" => "",
                "no_of_items" => "0.00",
                "first_weight" => "0.00",
                "first_weight_time" => "",
                "second_weight" => "0.00",
                "second_weight_time" => "",
                "net_weight" => "0.00",
                "finders" => "",
                "volume" => "0.00",
                "no_of_bags" => "0.00",
                "driver_name" => "",
                "weigh_bill_no" => "",
                "wastage" => "0.00",
                "moisture" => "0.00",
                "sand" => "0.00",
                "ec_level" => "0.00",
                "comment" => "",
            ];

            if ($grn) {

                if ($grn->refferance_no) {
                    $header["referance_no"] = $grn->refferance_no;
                }
                if ($grn->trans_date) {
                    $header["date"] = $grn->trans_date;
                }
                if ($this->getSupplier($grn->supplier_id)) {
                    $header["supplier"] = $this->getSupplier($grn->supplier_id);
                }
                if ($grn->received_by) {
                    $header["received_by"] = $grn->received_by;
                }
                if ($this->getStore($grn->store_id)) {
                    $header["store"] = $this->getStore($grn->store_id);
                }
                if ($this->getStore($grn->store_from_id)) {
                    $header["store_from"] = $this->getStore($grn->store_from_id);
                }
                if ($this->getStore($grn->store_to_id)) {
                    $header["store_to"] = $grn->store_to_id;
                }
                if ($grn->supplier_reff_no) {
                    $header["supplier_ref_no"] = $grn->supplier_reff_no;
                }
                if ($grn->po_no) {
                    $header["po_no"] = $grn->po_no;
                }
                if ($grn->customer_order_plan_id) {
                    $header["order_no"] = $grn->customer_order_plan_id;
                }
                if ($grn->driver_name) {
                    $header["transport_by"] = $grn->driver_name;
                }
                if ($grn->vehicle_no) {
                    $header["vehicle_no"] = $grn->vehicle_no;
                }

                if ($grn->first_weight) {
                    $header["first_weight"] = $grn->first_weight;
                }
                if ($grn->first_weight_time) {
                    $header["first_weight_time"] = $grn->first_weight_time;
                }
                if ($grn->second_weight) {
                    $header["second_weight"] = $grn->second_weight;
                }
                if ($grn->second_weight_time) {
                    $header["second_weight_time"] = $grn->second_weight_time;
                }
                if ($grn->net_weight) {
                    $header["net_weight"] = $grn->net_weight;
                }
                if ($grn->finders) {
                    $header["finders"] = $grn->finders; 
                }
                if ($grn->volume) {
                    $header["volume"] = $grn->volume;   
                }
                if ($grn->no_of_bags) {
                    $header["no_of_bags"] = $grn->no_of_bags;
                }   
                if ($grn->driver_name) {
                    $header["driver_name"] = $grn->driver_name;
                }
                if ($grn->weigh_bill_no) {
                    $header["weigh_bill_no"] = $grn->weigh_bill_no;
                }
                if ($grn->wastage) {
                    $header["wastage"] = $grn->wastage;
                }
                if ($grn->moisture) {
                    $header["moisture"] = $grn->moisture;
                }
                if ($grn->sand) {
                    $header["sand"] = $grn->sand;
                }
                if ($grn->ec_level) {
                    $header["ec_level"] = $grn->ec_level;
                }
                if ($grn->comment) {
                    $header["comment"] = $grn->comment;
                }

            }

            $data = GoodsReceivedMr::where('internal_id', '=', $id)->get();
            $total_value = 0.0;
            foreach ($data as $dd) {
                $dd->cost_price = 0.00;
                $product = Product::find($dd->product_primary_id);
                $dd->product_id = $product->product_id;
                $dd->product = $product->product_name;

                $uom = ProductUnit::find($dd->unit_id);

                if ($uom) {
                    $dd->unit = $uom->name;
                } else {
                    $dd->unit = '';
                }
                $product_history = ProductHistorySetoff::where('internal_id', '=', $dd->internal_id)->first();
                if ($product_history) {
                    $dd->cost_price = $product_history->cost_price;
                }
               
                $dd->value = ($dd->price *  $dd->quantity);
                $total_value += $dd->value;
            }
            $header["total_value"] = $total_value;
            

            $responseBody = $this->responseBody(true, "GoodsReceivedMrListController", "goodsReceivedReport", ["header" => $header, "body" => ["data" => $data]]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsReceivedMrListController", "goodsReceivedReport", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    private function getSupplier($id){        
        $supplier = Suppliers::find($id);
        if ($supplier){
            return $supplier->supplier_name;
        }
        return "";
    }

    private function getReceivedBy($id)
    {
        $received = Employee::find($id);
        if ($received) {
            return $received->name_withinitial;
        }
        return "";
    }

    private function getDepartment($id)
    {
        $department = Department::find($id);
        if ($department) {
            return $department->department;
        }
        return "";
    }

    private function getStore($id)
    {
        $store = StoreLocation::find($id);
        if ($store) {
            return $store->name;
        }
        return "";
    }




    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
