<?php

namespace Modules\Sc\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Sc\Entities\GoodsTransferDataMR;
use Modules\Sc\Entities\GoodsTransferHeaderMR;
use Modules\Sc\Entities\StoreLocation;
use Modules\St\Entities\Product;
use Modules\Sc\Entities\ProductHistorySetoff;
use Modules\St\Entities\ProductUnit;
use Modules\Pp\Entities\CustomerPlan;

class GoodsTransferMRListController extends Controller
{
    public function allGoodsTransfer()
    {
        try {
            $goods_transfers = GoodsTransferHeaderMR::select('*')->orderBy('internal_id', 'DESC')->get();
            foreach ($goods_transfers as $goods_transfer) {
                $store_from = StoreLocation::find($goods_transfer->store_from_id);
                //$store_to = StoreLocation::find($goods_transfer->store_to_id);
                $goods_transfer->store_from = $store_from->name;
                $goods_transfer->store_to = $goods_transfer->store_to_id;
            }
            $responseBody = $this->responseBody(true, "GoodsTransferMRListController", "allGoodsTransfer", $goods_transfers);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsTransferMRListController", "allGoodsTransfer", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }

    public function goodsTransferMRReport($id)
    {
        
       
        try {
            $grn = GoodsTransferHeaderMR::find($id);

            $header = [
                "referance_no" => "",
                "date" => "",
                "supplier" => "",
                "received_by" => "",
                "store" => "",
                "store_from" => "",
                "store_to" => "",
                "supplier_ref_no" => "",
                "po_no" => "",
                "order_no" => "",
                "transport_by" => "",
                "vehicle_no" => "",
                "no_of_items" => "0.00",
                "first_weight" => "0.00",
                "first_weight_time" => "",
                "second_weight" => "0.00",
                "second_weight_time" => "",
                "net_weight" => "0.00",
                "finders" => "",
                "volume" => "0.00",
                "no_of_bags" => "0.00",
                "driver_name" => "",
                "weigh_bill_no" => "",
                "wastage" => "0.00",
                "moisture" => "0.00",
                "sand" => "0.00",
                "ec_level" => "0.00",
                "comment" => "",
            ];

            if ($grn) {

                if ($grn->external_id) {
                    $header["referance_no"] = $grn->external_id;
                }
                if ($grn->trans_date) {
                    $header["date"] = $grn->trans_date;
                }
                // if ($this->getSupplier($grn->supplier_id)) {
                //     $header["supplier"] = $this->getSupplier($grn->supplier_id);
                // }
                // if ($grn->received_by) {
                //     $header["received_by"] = $grn->received_by;
                // }
                // if ($this->getStore($grn->store_id)) {
                //     $header["store"] = $this->getStore($grn->store_id);
                // }
                if ($this->getStore($grn->store_from_id)) {
                    $header["store_from"] = $this->getStore($grn->store_from_id);
                }
                if ($grn->store_to_id) {
                    $header["store_to"] = $grn->store_to_id;
                }
                // if ($grn->supplier_reff_no) {
                //     $header["supplier_ref_no"] = $grn->supplier_reff_no;
                // }
                if ($grn->po_no) {
                    $header["po_no"] = $grn->po_no;
                }
                if ($this->getCustomerOrder($grn->customer_order_plan_id)) {
                    $header["order_no"] = $this->getCustomerOrder($grn->customer_order_plan_id);
                }
                if ($grn->driver_name) {
                    $header["transport_by"] = $grn->driver_name;
                }
                if ($grn->vehicle_no) {
                    $header["vehicle_no"] = $grn->vehicle_no;
                }

                if ($grn->first_weight) {
                    $header["first_weight"] = $grn->first_weight;
                }
                if ($grn->first_weight_time) {
                    $header["first_weight_time"] = $grn->first_weight_time;
                }
                if ($grn->second_weight) {
                    $header["second_weight"] = $grn->second_weight;
                }
                if ($grn->second_weight_time) {
                    $header["second_weight_time"] = $grn->second_weight_time;
                }
                if ($grn->net_weight) {
                    $header["net_weight"] = $grn->net_weight;
                }
                if ($grn->finders) {
                    $header["finders"] = $grn->finders; 
                }
                if ($grn->volume) {
                    $header["volume"] = $grn->volume;   
                }
                if ($grn->no_of_bags) {
                    $header["no_of_bags"] = $grn->no_of_bags;
                }   
                if ($grn->driver_name) {
                    $header["driver_name"] = $grn->driver_name;
                }
                if ($grn->weigh_bill_no) {
                    $header["weigh_bill_no"] = $grn->weigh_bill_no;
                }
                if ($grn->wastage) {
                    $header["wastage"] = $grn->wastage;
                }
                if ($grn->moisture) {
                    $header["moisture"] = $grn->moisture;
                }
                if ($grn->sand) {
                    $header["sand"] = $grn->sand;
                }
                if ($grn->ec_level) {
                    $header["ec_level"] = $grn->ec_level;
                }
                if ($grn->comment) {
                    $header["comment"] = $grn->comment;
                }

            }
           
            $data = GoodsTransferDataMR::where('internal_id', '=', $id)->get();
            $total_value = 0.0;
            foreach ($data as $dd) {
                $dd->cost_price = 0.00;
                $product = Product::find($dd->product_id);
                $dd->product_id = $product->product_id;
                $dd->product = $product->product_name;

                $uom = ProductUnit::find($dd->unit_id);

                if ($uom) {
                    $dd->unit = $uom->name;
                } else {
                    $dd->unit = '';
                }
                $product_history = ProductHistorySetoff::where('internal_id', '=', $dd->internal_id)->first();
                if ($product_history) {
                    $dd->cost_price = $product_history->cost_price;
                }
               
                $dd->value = ($dd->price *  $dd->quantity);
                $total_value += $dd->value;
            }
           
            $header["total_value"] = $total_value;
            

            $responseBody = $this->responseBody(true, "GoodsTransferMRListController", "goodsTransferMRReport", ["header" => $header, "body" => ["data" => $data]]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsTransferMRListController", "goodsTransferMRReport", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }

    public function delete($id)
    {
        try {
            GoodsTransferDataMR::where('internal_id', '=', $id)->delete();
            GoodsTransferHeaderMR::find($id)->delete();
            $responseBody = $this->responseBody(true, "GoodsTransferMRListController", "delete", true);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsTransferMRListController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    private function getCustomerOrder($id)
    {
        $order = CustomerPlan::find($id);
        if ($order) {
            return $order->manufacturing_order_number;
        }
        return "";
    }


    private function getStore($id)
    {
        $store = StoreLocation::find($id);
        if ($store) {
            return $store->name;
        }
        return "";
    }

    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
