<?php

namespace Modules\Sc\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\Employee;
use Modules\Sc\Entities\MaterialRequisitionData;
use Modules\Sc\Entities\RawMaterialRequisitionHeader;
use Modules\St\Entities\Product;
use Modules\St\Entities\ProductUnit;

class GoodsTransferMrRetrieveController extends Controller
{
    public function allMaterialRequisition()
    {
        try {

            // $query = 'SELECT 
            // sc_raw_material_requisition_headers.trans_date,
            // sc_raw_material_requisition_headers.external_id,
            // sc_raw_material_requisition_headers.internal_id,
            // (SELECT sc_store_locations.`name` 
            // FROM sc_store_locations 
            // WHERE sc_store_locations.id = sc_raw_material_requisition_headers.store_id) AS store,
            // (SELECT hr_employee_departments.department 
            // FROM hr_employee_departments 
            // WHERE hr_employee_departments.department_id = sc_raw_material_requisition_headers.dept_id) AS department
            // FROM sc_raw_material_requisition_headers
            // WHERE internal_id IN (SELECT sc_raw_material_requisition_data.internal_id FROM sc_raw_material_requisition_data
            // INNER JOIN st_products ON sc_raw_material_requisition_data.product_id = st_products.product_primary_id
            // WHERE (sc_raw_material_requisition_data.quantity) - (sc_raw_material_requisition_data.transfer_quantity+sc_raw_material_requisition_data.issues_quantity) > 0 
            // -- AND st_products.product_type_id = "1" 
            // AND sc_raw_material_requisition_headers.status = "1" 
            // GROUP BY sc_raw_material_requisition_data.internal_id) 
            // ORDER BY sc_raw_material_requisition_headers.trans_date 
            // ASC LIMIT 40';

            $query = 'SELECT
                sc_raw_material_requisition_headers.trans_date,
                sc_raw_material_requisition_headers.external_id,
                sc_raw_material_requisition_headers.internal_id,
                sc_store_locations.`name` AS store,
                hr_employee_departments.department 
            FROM sc_raw_material_requisition_headers
                LEFT JOIN sc_store_locations ON sc_store_locations.id = sc_raw_material_requisition_headers.store_id
                LEFT JOIN hr_employee_departments ON hr_employee_departments.department_id = sc_raw_material_requisition_headers.dept_id 
            WHERE internal_id IN ( SELECT sc_raw_material_requisition_data.internal_id 
                FROM sc_raw_material_requisition_data
                INNER JOIN st_products ON sc_raw_material_requisition_data.product_id = st_products.product_primary_id 
                -- 	WHERE ( sc_raw_material_requisition_data.quantity ) - ( sc_raw_material_requisition_data.transfer_quantity + sc_raw_material_requisition_data.issues_quantity ) > 0
                WHERE sc_raw_material_requisition_headers.STATUS = "1" 
                GROUP BY sc_raw_material_requisition_data.internal_id ) 
            ORDER BY sc_raw_material_requisition_headers.trans_date 
            ASC LIMIT 40';

            $data = DB::select($query);

            $responseBody = $this->responseBody(true, "GoodsTransferMrRetrieveController", "allMaterialRequisition", $data);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsTransferMrRetrieveController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    private function checkInValiedRetriveHeader($id)
    {

        $result = DB::select('SELECT SUM(quantity) - SUM(transfer_quantity+issues_quantity) AS quantity FROM sc_material_requisition_data WHERE internal_id = "' . $id . '" GROUP BY internal_id');
        if ($result) {
            $quantity = $result[0]->quantity;
            if ($quantity > 0) {
                return true;
            }
        }
        return false;
    }


    public function allMaterialRequisitionData($id)
    {
        try {
            $query = 'SELECT st_products.product_id,
            sc_raw_material_requisition_data.mr_data_id,
            st_products.product_name,
            (sc_raw_material_requisition_data.quantity-(sc_raw_material_requisition_data.transfer_quantity+sc_raw_material_requisition_data.issues_quantity)) AS quantity,
            st_product_units.`name` AS unit
            FROM sc_raw_material_requisition_data 
            INNER JOIN st_products ON sc_raw_material_requisition_data.product_id = st_products.product_primary_id
            INNER JOIN st_product_units ON sc_raw_material_requisition_data.unit_id = st_product_units.id
            WHERE sc_raw_material_requisition_data.internal_id = "' . $id . '" AND (sc_raw_material_requisition_data.quantity- (sc_raw_material_requisition_data.issues_quantity+sc_raw_material_requisition_data.transfer_quantity)) != 0  AND st_products.product_type_id = "1"';
            $data = DB::select($query);
            $responseBody = $this->responseBody(true, "GoodsTransferMrRetrieveController", "allMaterialRequisitionData", $data);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsTransferMrRetrieveController", "allMaterialRequisitionData", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    public function getSelectedMR($id)
    {
        try {
            $grn = RawMaterialRequisitionHeader::find($id);
            //$grn_data = MaterialRequisitionData::where('internal_id', '=', $id)->get();
            $query = 'SELECT * FROM sc_raw_material_requisition_data 
            WHERE sc_raw_material_requisition_data.internal_id = "' . $id . '" 
            AND (sc_raw_material_requisition_data.quantity- (sc_raw_material_requisition_data.issues_quantity+sc_raw_material_requisition_data.transfer_quantity)) != 0';
            $grn_data = DB::select($query);
            foreach ($grn_data as $data) {
                $product = Product::find($data->product_id);
                $data->product = $product->product_name;
                $uom = ProductUnit::find($data->unit_id);
                $uom_arr = [];
                if ($uom) {
                    array_push($uom_arr, ["value" => $uom->id, "text" => $uom->name]);
                }
                $data->quantity = ($data->quantity - ($data->transfer_quantity + $data->issues_quantity));
                $data->uom = $uom_arr;
                $data->product_primary_id = $product->product_primary_id;
                $data->product_id = $product->product_id;
            }
            $grn->data = $grn_data;
            $responseBody = $this->responseBody(true, "GoodsTransferController", "getGrn", $grn);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsTransferController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    // public function getSelectedMR($id, $data_id)
    // {
    //     try {
    //         $grn = RawMaterialRequisitionHeader::find($id);
    //         //$grn_data = MaterialRequisitionData::where('internal_id', '=', $id)->get();
    //         $query = 'SELECT * FROM sc_raw_material_requisition_data 
    //         WHERE sc_raw_material_requisition_data.mr_data_id = "' . $data_id . '" 
    //         AND (sc_raw_material_requisition_data.quantity- (sc_raw_material_requisition_data.issues_quantity+sc_raw_material_requisition_data.transfer_quantity)) != 0';
    //         $grn_data = DB::select($query);
    //         foreach ($grn_data as $data) {
    //             $product = Product::find($data->product_id);
    //             $data->product = $product->product_name;
    //             $uom = ProductUnit::find($data->unit_id);
    //             $uom_arr = [];
    //             if ($uom) {
    //                 array_push($uom_arr, ["value" => $uom->id, "text" => $uom->name]);
    //             }
    //             $data->quantity = ($data->quantity - ($data->transfer_quantity + $data->issues_quantity));
    //             $data->uom = $uom_arr;
    //             $data->product_primary_id = $product->product_primary_id;
    //             $data->product_id = $product->product_id;
    //         }
    //         $grn->data = $grn_data;
    //         $responseBody = $this->responseBody(true, "GoodsTransferController", "getGrn", $grn);
    //     } catch (Exception $exception) {
    //         $responseBody = $this->responseBody(false, "GoodsTransferController", "error", $exception);
    //     }
    //     return response()->json(["data" => $responseBody]);
    // }

    public function getSelectedMRHeader($id)
    {
        try {
            $mr_header = RawMaterialRequisitionHeader::find($id);
            $responseBody = $this->responseBody(true, "GoodsTransferController", "getGrn", $mr_header);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsTransferController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
