<?php

namespace Modules\Sc\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Modules\Fm\Entities\SupplierInvoiceData;
use Modules\Hr\Entities\Employee;
use Modules\Sc\Entities\DocumentNumber;
use Modules\Sc\Entities\GrnAttachment;
use Modules\Sc\Entities\GrnData;
use Modules\Sc\Entities\GrnHeader;
use Modules\Sc\Entities\GrnDataOther;
use Modules\Sc\Entities\ProductHistory;
use Modules\Sc\Entities\ProductHistorySetoff;
use Modules\Sc\Entities\PurchaseOrderHeader;
use Modules\Sc\Entities\StoreLocation;
use Modules\St\Entities\Product;
use Modules\St\Entities\ProductUnit;
use Modules\St\Entities\Suppliers;
use Modules\St\Entities\Uom;

class GrnHeaderController extends Controller
{



    public function allEmployees()
    {
        try {
            $employees = Employee::all();
            $result = array();
            foreach ($employees as $emp) {
                array_push($result, [
                    "img" => "",
                    "id" => $emp->employee_id,
                    "value" => $emp->name_withinitial,
                ]);
            }
            $responseBody = $this->responseBody(true, "GrnHeaderController", "allEmployees", $result);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnHeaderController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function allSuppliers()
    {
        try {
            $products =  Suppliers::select('supplier_id As id', 'supplier_name As value0')->get();
            return $this->responseBody(true, "GrnHeaderController", "allSuppliers", $products);
        } catch (Exception $exception) {
            return $this->responseBody(false, "GrnHeaderController", "error", $exception);
        }
    }


    public function allProduct()
    {
        try {
            $products =  Product::select('product_primary_id As id', 'product_id As value0', 'product_name As value1')->get();
            return $this->responseBody(true, "GrnHeaderController", "allProduct", $products);
        } catch (Exception $exception) {
            return $this->responseBody(false, "GrnHeaderController", "error", $exception);
        }
    }


    public function maxID($store_id, $document_no)
    {
        try {
            $grn = GrnHeader::where('document_no', '=', $document_no)->get();
            $id = $grn[count($grn) - 1]['internal_id'] + 1;
            $store = StoreLocation::find($store_id);
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
            }
            $responseBody = $this->responseBody(true, "GrnHeaderController", "allProductUnit", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnHeaderController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function allStores()
    {
        try {
            $stores =  StoreLocation::all();
            $responseBody = $this->responseBody(true, "GrnHeaderController", "allStores", $stores);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnHeaderController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function save(Request $request)
    {
        try {
            $prefix = $this->getPrefix('100');

            $grn = new GrnHeader();
            $grn->external_id = $prefix . "" . $request->get('external_id');
            $grn->ref_external_id = $prefix . "" . $request->get('ref_extenal_id');
            $grn->trans_date = $request->get('trans_date');
            $grn->supplier_Id = $request->get('supplier_Id');
            $grn->received_by = 0;
            $grn->employee_name = $request->get('received_by');
            $grn->store_id = $request->get('store_id');
            $grn->supplier_ref_no = $request->get('supplier_ref_no');
            $grn->purchase_order_no = $request->get('purchase_order_no');
            $grn->transport_by = $request->get('transport_by');
            $grn->vehicle_no = $request->get('vehicle_no');
            $grn->remarks = $request->get('remarks');
            $grn->document_no = 100;
            $grn->user_id = Auth::user()->id;
            $grn->Status = 0;
            if ($grn->save()) {
                $grn = GrnHeader::find($grn->internal_id);
                $grn->ref_internal_id = $grn->internal_id;
                $grn->update();
                $grn_arr = $request->get("grn_data");
                for ($i = 0; $i < count($grn_arr); $i++) {
                    $grnData = json_decode($grn_arr[$i]);
                    $grn_data = new GrnData();
                    $grn_data->internal_id = $grn->internal_id;
                    $grn_data->external_id = $grn->external_id;
                    $grn_data->product_id =  $grnData->product_id;
                    $grn_data->unit_id =  $grnData->unit_id;
                    $grn_data->quantity =  $grnData->qty;
                    $grn_data->comments =  $grnData->comments;
                    $grn_data->save();
                }

                $grn_other_arr = $request->get("order_other");
                if ($grn_other_arr) {
                    for ($i = 0; $i < count($grn_other_arr); $i++) {
                        $description = $grn_other_arr[$i]["description"];
                        $qty = $grn_other_arr[$i]["quantity"];
                        $price = $grn_other_arr[$i]["price"];
                        $discount = $grn_other_arr[$i]["discount"];
                        $value = $grn_other_arr[$i]["value"];

                        if ($description == null) {$description = "";}
                        if ($qty == null) {$qty = "";}
                        if ($price == null) {$price = "";}
                        if ($discount == null) {$discount = "";}
                        if ($value == null) {$value = "";}

                        $prh_other = new GrnDataOther();
                        $prh_other->internal_id = $grn->internal_id;
                        $prh_other->external_id = $grn->external_id;
                        $prh_other->description = $description;
                        $prh_other->quantity = $qty;
                        $prh_other->price =  $price;
                        $prh_other->discount =  $discount;
                        $prh_other->value =  $value;
                        $prh_other->save();
                    }
                }


                $attachmnet_token = $request->get("attachment_token");
                $attachments = GrnAttachment::where('token', '=', $attachmnet_token)->get();
                foreach ($attachments as $attachmnet) {
                    if ($attachmnet) {
                        $attachmnet->grn_id = $grn->internal_id;
                        $attachmnet->update();
                    }
                }
            }
            $responseBody = $this->responseBody(true, "GrnHeaderController", "saveGrnHeaderTemp", $grn_arr);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnHeaderController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }






    public function getGrn($id)
    {
        try {
            $grn = GrnHeader::find($id);
            if (count(array_filter(explode("-", $grn->external_id))) == 2) {
                $grn->external_id = explode("-", $grn->external_id)[1];
            }
            $supplier = Suppliers::find($grn->supplier_Id);
            //$received = Employee::find($grn->received_by);
            //$grn->received = $received->name_withinitial;
            $grn->supplier = $supplier->supplier_name;
            $grn_data = GrnData::where('internal_id', '=', $id)->get();
            foreach ($grn_data as $data) {
                $product = Product::find($data->product_id);
                $data->product = $product->product_name;
                $uom = ProductUnit::find($data->unit_id);
                $uom_arr = [];
                if ($uom) {
                    array_push($uom_arr, ["value" => $uom->id, "text" => $uom->name]);
                }
                $data->uom = $uom_arr;
                $data->product_primary_id = $product->product_primary_id;
                $data->product_id = $product->product_id;
                
                $price = 0;
                $value = 0;
                $supplier_invoice_data = SupplierInvoiceData::where([['grn_internal_id','=',$data->internal_id],['product_id','=',$product->product_primary_id]])->first();
                //dd($data->product_id);
                
                if($supplier_invoice_data){
                    $price  =  $supplier_invoice_data->price;
                    $value  =  $supplier_invoice_data->value;
                }
                $data->price = $price;
                $data->value = $value;
            }
            $grn->data = $grn_data;

            $grn_data_other = GrnDataOther::where('internal_id', '=', $id)->get();
            
            $grn->request_other = $grn_data_other;

            

            $responseBody = $this->responseBody(true, "GrnHeaderController", "getGrn", $grn);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnHeaderController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function update(Request $request, $id)
    {

        try {
            $prefix = $this->getPrefix('100');
            if ($this->delete($id)) {
                $grn = GrnHeader::find($id);
                $grn->external_id = $prefix . "" . $request->get('external_id');
                $grn->ref_external_id = $prefix . "" . $request->get('ref_extenal_id');
                $grn->trans_date = $request->get('trans_date');
                $grn->supplier_Id = $request->get('supplier_Id');
                //$grn->received_by = $request->get('received_by');
                $grn->employee_name = $request->get('received_by');
                $grn->store_id = $request->get('store_id');
                $grn->supplier_ref_no = $request->get('supplier_ref_no');
                $grn->purchase_order_no = $request->get('purchase_order_no');
                $grn->transport_by = $request->get('transport_by');
                $grn->vehicle_no = $request->get('vehicle_no');
                $grn->remarks = $request->get('remarks');
                if ($grn->update()) {
                    $grn_arr = $request->get("grn_data");
                    if ($grn_arr) {
                        for ($i = 0; $i < count($grn_arr); $i++) {
                            $grnData = json_decode($grn_arr[$i]);
                            $grn_data = new GrnData();
                            $grn_data->internal_id = $grn->internal_id;
                            $grn_data->external_id = $grn->external_id;
                            $grn_data->product_id =  $grnData->product_id;
                            $grn_data->unit_id =  $grnData->unit_id;
                            $grn_data->quantity =  $grnData->qty;
                            $grn_data->comments =  $grnData->comments;
                            $grn_data->save();
                        }
                    }

                    $grn_other_arr = $request->get("order_other");
                    if ($grn_other_arr) {
                        for ($i = 0; $i < count($grn_other_arr); $i++) {
                            $description = $grn_other_arr[$i]["description"];
                            $qty = $grn_other_arr[$i]["quantity"];
                            $price = $grn_other_arr[$i]["price"];
                            $discount = $grn_other_arr[$i]["discount"];
                            $value = $grn_other_arr[$i]["value"];

                            if ($description == null) {$description = "";}
                            if ($qty == null) {$qty = "";}
                            if ($price == null) {$price = "";}
                            if ($discount == null) {$discount = "";}
                            if ($value == null) {$value = "";}

                            $prh_other = new GrnDataOther();
                            $prh_other->internal_id = $grn->internal_id;
                            $prh_other->external_id = $grn->external_id;
                            $prh_other->description = $description;
                            $prh_other->quantity = $qty;
                            $prh_other->price =  $price;
                            $prh_other->discount =  $discount;
                            $prh_other->value =  $value;
                            $prh_other->save();
                        }
                    }

                }


                $attachmnet_token = $request->get("attachment_token");
                $attachments = GrnAttachment::where('token', '=', $attachmnet_token)->get();
                foreach ($attachments as $attachmnet) {
                    if ($attachmnet) {
                        $attachmnet->grn_id = $grn->internal_id;
                        $attachmnet->update();
                    }
                }
            }

            $responseBody = $this->responseBody(true, "GrnHeaderController", "update", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnHeaderController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    public function change_status(Request $request, $id)
    {

        try {

            $grn_header = GrnHeader::find($id);
            $grn_header->status = $request->get('status');
            if ($grn_header->update()) {
                $this->addProductToSetoff($id);
            }

            $responseBody = $this->responseBody(true, "GrnHeaderController", "change_status", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnHeaderController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function delete($id)
    {
        try {
            $grn_data = GrnData::where('internal_id', '=', $id)->get();
            foreach ($grn_data as $data) {
                $data->delete();
            }
            $grn_data_other = GrnDataOther::where('internal_id', '=', $id)->get();
            if ($grn_data_other) {
                foreach ($grn_data_other as $data) {
                    $data->delete();
                }
            }
            return true;
        } catch (Exception $exception) {
            return false;
        }
    }



    private function addProductToSetoff($id)
    {
        $query = "SELECT sc_grn_headers.document_no,
                    sc_grn_headers.trans_date,
                    sc_grn_headers.store_id,
                    sc_grn_data.*
                    FROM sc_grn_data 
                    INNER JOIN sc_grn_headers
                    ON sc_grn_data.internal_id = sc_grn_headers.internal_id 
                    WHERE sc_grn_data.internal_id = '" . $id . "' AND sc_grn_headers.document_no = '100'";

        $result = DB::select($query);
        foreach ($result as $data) {

            // Check if already exists in product history
            $existing = ProductHistory::where('external_id', $data->external_id)
                ->where('product_id', $data->product_id)
                ->first();

            if ($existing) {
                continue; // Skip if already added
            }

            $product_history = new ProductHistory();
            $product_history->internal_id = $data->internal_id;
            $product_history->external_id = $data->external_id;
            $product_history->document_no = $data->document_no;
            $product_history->description = "Goods Received";
            $product_history->product_id = $data->product_id;
            $product_history->unit_id = $data->unit_id;
            $product_history->quantity = $data->quantity;
            $product_history->set_off = 0;
            $product_history->cost_price = 0;
            $product_history->store_id = $data->store_id;
            $product_history->user_id = Auth::user()->id;
            $product_history->transaction_date = $data->trans_date;
            $product_history->save();

            // Also check for duplicate setoff
            $setoffExists = ProductHistorySetoff::where('external_id', $product_history->external_id)
                ->where('product_id', $product_history->product_id)
                ->exists();

            if (!$setoffExists) {
                $product_history_setoff = new ProductHistorySetOffController();
                $product_history_setoff->saveGoodsReceived($product_history);
            }
            
        }
    }



    private function removeProductFromSetoff($id)
    {
        $product_histories = ProductHistory::where('internal_id', '=', $id)->get();
        foreach ($product_histories as $data) {
            $data->delete();
        }
    }



    public function isApproved($id)
    {
        try {
            $grn = GrnHeader::find($id);
            if ($grn) {
                $responseBody = $this->responseBody(true, "GrnHeaderController", "isApproved", $grn->status);
            }
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnHeaderController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function getUom($id)
    {
        try {
            $product =  Product::where('product_primary_id', '=', $id)->first();

            $data = [
                "id" => "0",
                "value" => "",
            ];
            if ($product) {
                $uom =  ProductUnit::find($product->uom_id);
                if ($uom) {
                    $data["id"] = $uom->id;
                    $data["value"] = $uom->name;
                }
            }

            $responseBody = $this->responseBody(true, "PurchaseRequestController", "getUom", $data);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseRequestController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }





    public function uploadAttachment(Request $request)
    {

        $id = $request->get('grn_id');
        $token = $request->get('attachmnet_token');
        $file = $request->file('file');
        $file_name = $file->getClientOriginalName();
        $filename = uniqid() . '_' . time() . '.' . $file_name;
        $filename = str_replace(' ','',str_replace('\'','',$filename));
        $file->move(public_path('grn'), $filename);

        $grn_attachment = new GrnAttachment();
        $grn_attachment->grn_id = 0;
        $grn_attachment->path = $filename;
        $grn_attachment->token = $token;
        return $grn_attachment->save();
    }



    public function allAttachment($id, $token)
    {
        try {

            $attachment = DB::select('SELECT *FROM sc_grn_attachments WHERE  grn_id = "' . $id . '" OR token = "' . $token . '"');
            $responseBody = $this->responseBody(true, "allAttachment", "found", $attachment);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "allAttachment", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function getPoFromSupplier($id)
    {
        try {

            $po = PurchaseOrderHeader::where('supplier_id', '=', $id)->get();
            $responseBody = $this->responseBody(true, "getPoFromSupplier", "found", $po);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "getPoFromSupplier", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    private function getPrefix($document_no)
    {
        $document_no = DocumentNumber::where('document_number', '=', $document_no)->first();
        $prefix = "";
        if ($document_no) {
            $prefix = $document_no->prefix;
        }

        return $prefix;
    }


    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
