<?php

namespace Modules\Sc\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\Employee;
use Modules\PJ\Entities\Project;
use Modules\Sc\Entities\DocumentNumber;
use Modules\Sc\Entities\BagGrnData;
use Modules\Sc\Entities\BagGrnHeader;
use Modules\Sc\Entities\ProductHistory;
use Modules\Sc\Entities\ProductHistorySetoff;
use Modules\Sc\Entities\StoreLocation;
use Modules\St\Entities\Product;
use Modules\St\Entities\ProductUnit;
use Modules\St\Entities\Suppliers;
use Modules\St\Entities\Uom;

class GrnReturnBagsController extends Controller
{

    public function allEmployees()
    {
        try {
            $employees = Employee::all();
            $result = array();
            foreach ($employees as $emp) {
                array_push($result, [
                    "img" => "",
                    "id" => $emp->employee_id,
                    "value" => $emp->name_withinitial,
                ]);
            }
            $responseBody = $this->responseBody(true, "GrnReturnBagsController", "allEmployees", $result);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnReturnBagsController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }

    public function allProjects()
    {
        try {
            $projects = Project::all();
            $responseBody = $this->responseBody(true, "GrnReturnBagsController", "allProjects", $projects);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnReturnBagsController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }

    public function allSuppliers()
    {
        try {
            $products =  Suppliers::select('supplier_id As id', 'supplier_name As value0')->get();
            return $this->responseBody(true, "GrnReturnBagsController", "allSuppliers", $products);
        } catch (Exception $exception) {
            return $this->responseBody(false, "GrnReturnBagsController", "error", $exception);
        }
    }

    public function allProduct()
    {
        try {
            $products =  Product::select('product_primary_id As id', 'product_id As value0', 'product_name As value1')
                                ->where('product_type_id', '=', 4)
                                ->orWhere('product_type_id', '=', 5)
                                ->get();
            return $this->responseBody(true, "GrnReturnBagsController", "allProduct", $products);
        } catch (Exception $exception) {
            return $this->responseBody(false, "GrnReturnBagsController", "error", $exception);
        }
    }


    public function allGrn()
    {
        try {
            $grns =  BagGrnHeader::where([['document_no', '=', '100'], ['status', '=', '1']])->get();
            foreach ($grns as $grn) {
                $supplier = Suppliers::find($grn->supplier_Id);
                $grn->id = $grn->external_id;
                $grn->value0 = "";
                $grn->value1 = "";
                if ($supplier) {
                    $grn->value0 = $supplier->supplier_name;
                    $grn->value1 = $supplier->supplier_name;
                }
            }
            return $this->responseBody(true, "GrnReturnBagsController", "allProduct", $grns);
        } catch (Exception $exception) {
            return $this->responseBody(false, "GrnReturnBagsController", "error", $exception);
        }
    }


    public function allProductUnit()
    {
        try {
            $products =  ProductUnit::all();
            $responseBody = $this->responseBody(true, "GrnReturnBagsController", "allProductUnit", $products);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnReturnBagsController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    public function allStores()
    {
        try {
            $stores =  StoreLocation::all();
            $responseBody = $this->responseBody(true, "GrnReturnBagsController", "allStores", $stores);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnReturnBagsController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    public function allProductCustomer()
    {
        try {
            $query = 'SELECT pp_customer_order_plans.customer_order_plan_id,
            pp_customer_orders.factory_po_num,
            st_products.product_name,
            pp_customer_order_plans_data.customer_order_plan_data_id
            FROM pp_customer_order_plans
            LEFT JOIN pp_customer_orders ON pp_customer_order_plans.order_id = pp_customer_orders.order_id
            LEFT JOIN pp_customer_order_plans_data ON pp_customer_order_plans.customer_order_plan_id = pp_customer_order_plans_data.customer_order_plan_id
            LEFT JOIN st_products ON pp_customer_order_plans_data.product_id = st_products.product_primary_id
			ORDER BY pp_customer_order_plans.customer_order_plan_id DESC';
            $orderPlan =  DB::select($query);
            $responseBody = $this->responseBody(true, "GrnReturnBagsController", "allProductCustomer", $orderPlan);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnReturnBagsController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function maxID($storeID)
    {
        try {
            $grn = BagGrnHeader::where('document_no', '=', '100')->get();
            $id = $grn[count($grn) - 1]['internal_id'] + 1;
            $store = StoreLocation::find($storeID);

            $responseBody = $this->responseBody(true, "GrnReturnBagsController", "maxID", ["id" => $id, "prefix" => $store->prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnReturnBagsController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function save(Request $request)
    {
        try {
            $grn = new BagGrnHeader();
            $prefix = $this->getPrefix('110');
            //$grn->internal_id = $request->get('internal_id');
            $grn->external_id = $prefix . "" . $request->get('external_id');
            $grn->ref_external_id = $prefix . "" . $request->get('ref_external_id');
            $grn->trans_date = $request->get('trans_date');
            $grn->supplier_Id = $request->get('supplier_Id');
            $grn->received_by = "0";
            $grn->employee_name = $request->get('received_by');
            $grn->store_id = $request->get('store_id');
            $grn->supplier_ref_no = $request->get('supplier_ref_no');
            $grn->purchase_order_no = $request->get('purchase_order_no');
            $grn->customer_order_plan_data_id = $request->get('customer_order_plan_data_id');
            $grn->transport_by = $request->get('transport_by');
            $grn->vehicle_no = $request->get('vehicle_no');
            $grn->remarks = "";
            $grn->Status = 0;
            $grn->document_no = 110;
            $grn->user_id = Auth::user()->id;
            if ($grn->save()) {
                $grn_arr = $request->get("grn_data");
                for ($i = 0; $i < count($grn_arr); $i++) {
                    $grnData = json_decode($grn_arr[$i]);
                    if ($request->get('internal_id') == 0) {
                        $grn = BagGrnHeader::find($grn->internal_id);
                        $grn->ref_internal_id = $grn->internal_id;
                        $grn->update();
                    } else {
                        $grn = BagGrnHeader::find($grn->internal_id);
                        $grn->ref_internal_id = $request->get('internal_id');
                        $grn->update();
                    }
                    $grn_data = new BagGrnData();
                    $grn_data->internal_id = $grn->internal_id;
                    $grn_data->external_id = $grn->external_id;
                    $grn_data->product_id =  $grnData->product_id;
                    $grn_data->unit_id =  $grnData->unit_id;
                    $grn_data->quantity =  ($grnData->qty * -1);
                    $grn_data->comments =  $grnData->comments;
                    if ($grn_data->save()) {
                        $this->addReturnToSetoff($grn_data->internal_id, $grn_data->external_id, $grn->ref_internal_id, $grn->ref_external_id, $grn_data->product_id, $grn_data->quantity, $grn->store_id);
                    }
                }
                $this->addProductToSetoff($grn->internal_id);
            }
            $responseBody = $this->responseBody(true, "GrnReturnBagsController", "saveGrnHeaderTemp", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnReturnBagsController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }






    public function getGrn($id)
    {
        try {
            $grn = BagGrnHeader::where([['external_id', '=', $id], ['document_no', '=', '100']])->first();
           
            $grn_data = BagGrnData::where('internal_id', '=', $grn->internal_id)->get();
            foreach ($grn_data as $data) {
                $product = Product::find($data->product_id);
                $data->product = $product->product_name;
                $uom = ProductUnit::find($product->uom_id);
                $uom_arr = [];
                if ($uom) {
                    array_push($uom_arr, ["value" => $uom->id, "text" => $uom->name]);
                }
                $data->uom = $uom_arr;
                $data->product_primary_id = $product->product_primary_id;
                $data->product_id = $product->product_id;
                $product_history = ProductHistory::where([['internal_id', '=', $grn->internal_id], ['product_id', '=', $data->product_id]])->first();
                $data->quantity = 0;
                if ($product_history) {
                    $data->quantity = ($product_history->quantity - $product_history->set_off);
                }
            }
            $grn->data = $grn_data;
           
            $responseBody = $this->responseBody(true, "GrnReturnBagsController", "getGrn", $grn);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnReturnBagsController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    public function getGoodsReturn($id)
    {
        try {
            $grn = BagGrnHeader::where([['internal_id', '=', $id],['document_no','=','110']])->first();
            if (count(array_filter(explode("-", $grn->external_id))) == 2) {
                $grn->external_id = explode("-", $grn->external_id)[1];
            }
            $grn_data = BagGrnData::where('internal_id', '=', $grn->internal_id)->get();
            foreach ($grn_data as $data) {
                $product = Product::find($data->product_id);
                $data->product = $product->product_name;
                $uom = ProductUnit::find($product->uom_id);
                $uom_arr = [];
                if ($uom) {
                    array_push($uom_arr, ["value" => $uom->id, "text" => $uom->name]);
                }
                $data->uom = $uom_arr;
                $data->product_primary_id = $product->product_primary_id;
                $data->product_id = $product->product_id;
                $product_history = ProductHistory::where([['internal_id', '=', $grn->internal_id], ['product_id', '=', $data->product_primary_id]])->first();
                $data->quantity = 0;
                if ($product_history) {
                    $data->quantity = abs($product_history->quantity - $product_history->set_off);
                }
            }
            $grn->data = $grn_data;



            $responseBody = $this->responseBody(true, "GrnReturnBagsController", "getGrn", $grn);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnReturnBagsController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function update(Request $request, $id)
    {

        try {
            $grn_header = BagGrnHeader::find($id);
            if ($this->delete($grn_header->internal_id)) {
                if ($grn_header->delete()) {
                    $bool =  $this->save($request);
                }
            }
            $responseBody = $this->responseBody(true, "GrnReturnBagsController", "saveGrnHeaderTemp", $bool);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnReturnBagsController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }

    public function delete($id)
    {
        try {
            $grn_data = BagGrnData::where('internal_id', '=', $id)->delete();
            $responseBody = $this->responseBody(true, "GrnReturnBagsController", "delete", true);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnReturnBagsController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    private function addReturnToSetoff($internal_id, $external_id, $ref_internal_id, $ref_external_id, $product_id, $quantity, $store_id)
    {
        $product_history = ProductHistory::where([['internal_id', '=', $ref_internal_id], 
                                                    ['product_id', '=', $product_id], 
                                                    ['store_type', '=', 3],
                                                    ['store_id', '=', $store_id]])->first();

        $setoff = new ProductHistorySetoff();
        $setoff->internal_id = $internal_id;
        $setoff->external_id = $external_id;
        $setoff->ref_internal_id = $ref_internal_id;
        $setoff->ref_external_id = $ref_external_id;
        //$setoff->product_history_transaction_id = $product_history->transaction_id;
        $setoff->product_id = $product_id;
        $setoff->setoff_quantity = abs($quantity);
        $setoff->cost_price = 0;
        $setoff->store_id = $store_id;
        $setoff->store_type = 3; // Store type 3 is for Bags
        $setoff->user_id = Auth::user()->id;
        if ($setoff->save()) {
            $this->updateProductHistory($setoff->ref_internal_id, $setoff->product_id, $setoff->store_id, $setoff->setoff_quantity);
        }
    }



    private function updateProductHistory($ref_internal_id, $product_id, $store_id, $setoff_quantity)
    {
        $product_history = ProductHistory::where([['internal_id', '=', $ref_internal_id], 
                                                ['product_id', '=', $product_id], 
                                                ['store_id', '=', $store_id], 
                                                ['store_type', '=', 3],
                                                ['document_no', '=', '100']])->first();

        $product_history->set_off = ($product_history->set_off + $setoff_quantity);
        $product_history->update();
       
    }



    private function addProductToSetoff($id)
    {
        $query = "SELECT sc_bags_grn_headers.document_no,
        sc_bags_grn_headers.trans_date,
        sc_bags_grn_headers.store_id,
        sc_bags_grn_data.*
        FROM sc_bags_grn_data 
        INNER JOIN sc_bags_grn_headers
        ON sc_bags_grn_data.internal_id = sc_bags_grn_headers.internal_id 
        WHERE sc_bags_grn_data.internal_id = '" . $id . "' AND sc_bags_grn_headers.document_no = '110'";

        $result = DB::select($query);
        foreach ($result as $data) {
            $product_history = new ProductHistory();
            $product_history->internal_id = $data->internal_id;
            $product_history->external_id = $data->external_id;
            $product_history->document_no = $data->document_no;
            $product_history->description = "Goods Return Bags";
            $product_history->product_id = $data->product_id;
            $product_history->unit_id = $data->unit_id;
            $product_history->quantity = $data->quantity;
            $product_history->set_off = 0;
            $product_history->cost_price = 0;
            $product_history->store_id = $data->store_id;
            $product_history->store_type = 3; // Store type 3 is for Bags
            $product_history->user_id = Auth::user()->id;
            $product_history->transaction_date = $data->trans_date;
            $product_history->save();
        }
    }



    public function getQty($product_id, $store_id)
    {
        try {
            $query = "SELECT SUM(quantity) AS quantity FROM sc_product_histories WHERE product_id = '" . $product_id . "' AND store_id = '" . $store_id . "'";
            $result = DB::select($query);
            $quantity = 0;
            foreach ($result as $data) {
                if ($data->quantity) {
                    $quantity = $data->quantity;
                }
            }
            $responseBody = $this->responseBody(true, "GrnReturnBagsController", "getQty", $quantity);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnReturnBagsController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function getUom($id)
    {
        try {
            $product =  Product::find($id);

            $data = [
                "id" => "0",
                "value" => "",
            ];
            if ($product) {
                $uom =  ProductUnit::find($product->uom_id);
                if ($uom) {
                    $data["id"] = $uom->id;
                    $data["value"] = $uom->name;
                }
            }

            $responseBody = $this->responseBody(true, "GrnReturnBagsController", "getUom", $data);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnReturnBagsController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    private function removeProductHistory($header)
    {
        ProductHistory::where([['document_no', '=', '210'], ['internal_id', '=', $header->internal_id]])->delete();
    }

    private function getPrefix($document_no)
    {
        $document_no = DocumentNumber::where('document_number', '=', $document_no)->first();
        $prefix = "";
        if ($document_no) {
            $prefix = $document_no->prefix;
        }

        return $prefix;
    }


    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
