<?php

namespace Modules\Sc\Http\Controllers;

use App\Models\User;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\Employee;
use Modules\Hr\Entities\EmployeeDepartment;
use Modules\Pp\Entities\Machinary;
use Modules\Sc\Entities\Department;
use Modules\Sc\Entities\MaterialRequisitionData;
use Modules\Sc\Entities\MaterialRequisitionHeader;
use Modules\Sc\Entities\StoreLocation;
use Modules\St\Entities\Product;
use Modules\St\Entities\ProductUnit;
use Modules\St\Entities\Uom;

class MaterialRequisitionPendingListController extends Controller
{
    public function allMaterialRequisitionPending($department_id, $status)
    {
        try {
            $query = "SELECT 
                H.internal_id,
                    H.external_id,
                    H.employee_name,
                    ED.department,
                    H.trans_date,
                    H.remarks,
                CASE 
                    WHEN SUM(CASE WHEN D.issues_quantity > 0 AND D.issues_quantity < D.quantity THEN 1 ELSE 0 END) > 0 THEN 'partial'
                    WHEN SUM(CASE WHEN IFNULL(D.issues_quantity, 0) > 0 THEN 1 ELSE 0 END) = 0 THEN 'pending'
                    ELSE 'completed'
                END AS req_status
            FROM sc_material_requisition_headers H
            INNER JOIN sc_material_requisition_data D ON D.internal_id = H.internal_id
            LEFT JOIN hr_employee_departments ED ON ED.department_id = H.dept_id
            WHERE IFNULL(D.issues_quantity, 0) = 0 OR (D.issues_quantity > 0 AND D.issues_quantity < D.quantity)
            GROUP BY H.internal_id, H.external_id, H.employee_name, H.trans_date, H.remarks";

            $mrqList = DB::select($query);    

            // if ($department_id != 'any' && $status == 'any') {
            //     $mrqList = MaterialRequisitionHeader::select('*')->where('dept_id', '=', $department_id)->orderBy('internal_id', 'DESC')->get();
            // } else if ($department_id == 'any' && $status != 'any') {
            //     $mrqList = MaterialRequisitionHeader::select('*')->where('status', '=', $status)->orderBy('internal_id', 'DESC')->get();
            // } else if ($department_id != 'any' && $status != 'any') {
            //     $mrqList = MaterialRequisitionHeader::select('*')->where([['dept_id', '=', $department_id], ['status', '=', $status]])->orderBy('internal_id', 'DESC')->get();
            // } else {
            //     $mrqList = MaterialRequisitionHeader::select('*')->orderBy('internal_id', 'DESC')->get();
            // }
            // foreach ($mrqList as $mrq) {
            //     $mrq->department = '';
            //     $mrq->type = '';
            //     $department = EmployeeDepartment::find($mrq->dept_id);
            //     if ($department) {$mrq->department = $department->department;}
            //     if ($mrq->mi_type == 0) {$mrq->type = 'General';} 
            //     else if ($mrq->mi_type == 1) {$mrq->type = 'Production';} 
            //     else if ($mrq->mi_type == 2) {$mrq->type = 'Project';} 
            //     else if ($mrq->mi_type == 3) {$mrq->type = 'Transport';}
            // }

            $responseBody = $this->responseBody(true, "MaterialRequisitionPendingListController", "allMaterialRequisitionPending", $mrqList);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialRequisitionPendingListController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function allMaterialApprovalRequisition()
    {
        try {
            $user = User::find(Auth::user()->id);
            if ($user) {
                $query = "SELECT sc_material_requisition_headers.* FROM sc_material_requisition_headers 
            INNER JOIN sc_transaction_approvals ON sc_material_requisition_headers.dept_id = sc_transaction_approvals.department_id
            WHERE sc_transaction_approvals.requisition = '" . $user->user_id. "' AND sc_material_requisition_headers.status = '0'";

                $mrqList = DB::select($query);

                foreach ($mrqList as $mrq) {
                    $mrq->department = '';
                    $mrq->type = '';
                    $department = EmployeeDepartment::find($mrq->dept_id);
                    if ($department) {
                        $mrq->department = $department->department;
                    }
                    if ($mrq->mi_type == 0) {
                        $mrq->type = 'General';
                    } else if ($mrq->mi_type == 1) {
                        $mrq->type = 'Production';
                    } else if ($mrq->mi_type == 2) {
                        $mrq->type = 'Project';
                    } else if ($mrq->mi_type == 3) {
                        $mrq->type = 'Transport';
                    }
                }
                $responseBody = $this->responseBody(true, "MaterialRiquisitionListController", "allMaterialRequisition", $mrqList);
            }else{
                $responseBody = $this->responseBody(true, "MaterialRiquisitionListController", "allMaterialRequisition", []);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialRiquisitionListController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }

    public function materialRequisitionReport($id)
    {
        try {
            $material_requisition_header = MaterialRequisitionHeader::find($id);

            $header = [
                "referance_no" => "",
                "date" => "",
                "department" => "",
                "store" => "",
                "type" => "",
                "manufacturing_order" => "",
                "machine_no" => "",
                "supervisor" => "",
            ];


            if ($material_requisition_header) {
                $header["referance_no"] = $material_requisition_header->external_id;
                $header["date"] = $material_requisition_header->trans_date;
                $header["supervisor"] = $this->getSupervisor($material_requisition_header->supervisor_id);
                $header["department"] = $this->getDepartment($material_requisition_header->dept_id);
                $header["store"] = $this->getStore($material_requisition_header->store_id);
                $header["type"] = $this->getType($material_requisition_header->mi_type);
                $header["manufacturing_order"] = $material_requisition_header->manufacturing_order_number;
                $header["machine_no"] = $this->getMachine($material_requisition_header->machine_id);
            }

            $data = MaterialRequisitionData::where('internal_id', '=', $id)->get();
            foreach ($data as $dd) {
                $product = Product::find($dd->product_id);
                $dd->product_id = $product->product_id;
                $dd->product = $product->product_name;
                $uom = ProductUnit::find($dd->unit_id);
                if ($uom) {
                    $dd->unit = $uom->name;
                } else {
                    $dd->unit = "";
                }
            }


            $responseBody = $this->responseBody(true, "MaterialRiquisitionListController", "materialRequisitionReport", ["header" => $header, "body" => ["data" => $data]]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialRiquisitionListController", "materialRequisitionReport", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }

    private function getSupervisor($id)
    {
        $supervisor = Employee::find($id);
        if ($supervisor) {
            return $supervisor->name_withinitial;
        }
        return "";
    }

    private function getDepartment($id)
    {
        $department = Department::find($id);
        if ($department) {
            return $department->department;
        }
        return "";
    }

    private function getStore($id)
    {
        $store = StoreLocation::find($id);
        if ($store) {
            return $store->name;
        }
        return "";
    }

    private function getType($id)
    {
        if ($id == 0) {
            return "General";
        } else if ($id == 1) {
            return "Production";
        } else if ($id == 2) {
            return "Maintenance";
        }
        return "";
    }

    private function getMachine($id)
    {
        $machine = Machinary::find($id);
        if ($machine) {
            return $machine->machinery_no;
        }
        return "";
    }

    public function change_status(Request $request, $id)
    {

        try {

            $mr_header = MaterialRequisitionHeader::find($id);
            $mr_header->status = $request->get('status');
            $mr_header->update();

            $responseBody = $this->responseBody(true, "MaterialRiquisitionListController", "approve", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialRiquisitionListController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }

    public function loadDepartments()
    {
        try {

            $departments = EmployeeDepartment::all();

            $responseBody = $this->responseBody(true, "MaterialRiquisitionListController", "loadDepartments", $departments);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialRiquisitionListController", "loadDepartments", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }

    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
