<?php

namespace Modules\Sc\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\Employee;
use Modules\Pp\Entities\Machinary;
use Modules\Sc\Entities\Department;
use Modules\Sc\Entities\MiData;
use Modules\Sc\Entities\MiHeader;
use Modules\Sc\Entities\StoreLocation;
use Modules\St\Entities\Product;
use Modules\St\Entities\ProductUnit;
use Modules\St\Entities\Uom;

class MiListController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        return view('sc::index');
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('sc::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('sc::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('sc::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
    }

    public function allMaterialIssue()
    {
        try {
            $query = 'SELECT sc_mi_headers.*,hr_employee_departments.department FROM sc_mi_headers
            INNER JOIN hr_employee_departments ON sc_mi_headers.dept_id = hr_employee_departments.department_id';
            //$miList = MiHeader::select('*')->orderBy('internal_id', 'DESC')->get();
            $miList = DB::select($query);
            $responseBody = $this->responseBody(true, "MiListController", "allGrn", $miList);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "MiListController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function materialIssueReport($id)
    {
        try {
            $mi_header = MiHeader::find($id);

            $header = [
                "referance_no" => "",
                "date" => "",
                "department" => "",
                "store" => "",
                "type" => "",
                "manufacturing_order" => "",
                "machine_no" => "",
                "supervisor" => "",
                "no_of_items" => "0.00",
            ];


            if ($mi_header) {
                if ($mi_header->external_id) {
                    $header["referance_no"] = $mi_header->external_id;
                }
                if ($mi_header->trans_date) {
                    $header["date"] = $mi_header->trans_date;
                }
                if ($this->getSupervisor($mi_header->supervisor_id)) {
                    $header["supervisor"] = $this->getSupervisor($mi_header->supervisor_id);
                }
                if ($this->getDepartment($mi_header->dept_id)) {
                    $header["department"] = $this->getDepartment($mi_header->dept_id);
                }
                if ($this->getStore($mi_header->store_id)) {
                    $header["store"] = $this->getStore($mi_header->store_id);
                }
                if ($this->getType($mi_header->mi_type)) {
                    $header["type"] = $this->getType($mi_header->mi_type);
                }
                if ($mi_header->manufacturing_order_number) {
                    $header["manufacturing_order"] = $mi_header->manufacturing_order_number;
                }
                if ($this->getMachine($mi_header->machine_id)) {
                    $header["machine_no"] = $this->getMachine($mi_header->machine_id);
                }
            }

            $data = MiData::where('internal_id', '=', $id)->get();
            $no_of_items = 0;
            foreach ($data as $dd) {
                $product = Product::find($dd->product_id);
                $dd->product_id = $product->product_id;
                $dd->product = $product->product_name;
                $uom = ProductUnit::find($dd->unit_id);
                $no_of_items+= $dd->quantity;
                if ($uom) {
                    $dd->unit = $uom->name;
                } else {
                    $dd->unit = "";
                }
            }
            $header["no_of_items"] = $no_of_items;


            $responseBody = $this->responseBody(true, "MaterialRiquisitionListController", "materialRequisitionReport", ["header" => $header, "body" => ["data" => $data]]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialRiquisitionListController", "materialRequisitionReport", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    private function getSupervisor($id)
    {

        $supervisor = Employee::find($id);
        if ($supervisor) {
            return $supervisor->name_withinitial;
        }
        return "";
    }



    private function getDepartment($id)
    {

        $department = Department::find($id);
        if ($department) {
            return $department->department;
        }
        return "";
    }


    private function getStore($id)
    {
        $store = StoreLocation::find($id);
        if ($store) {
            return $store->name;
        }
        return "";
    }



    private function getType($id)
    {
        if ($id == 0) {
            return "General";
        } else if ($id == 1) {
            return "Production";
        } else if ($id == 2) {
            return "Maintenance";
        }
        return "";
    }



    private function getMachine($id)
    {
        $machine = Machinary::find($id);
        if ($machine) {
            return $machine->machinery_no;
        }
        return "";
    }




    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
