<?php

namespace Modules\Sc\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Sc\Entities\StoreLocation;
use Modules\St\Entities\GroupLevel1;
use Modules\St\Entities\GroupLevel2;
use Modules\St\Entities\Product;
use Modules\St\Entities\ProductType;

class ProductHistoryController extends Controller
{



    public function allSettings()
    {

        try {
            $settings = [
                "stores" => $this->stores(),
                "producttype" => $this->producttype(),
                "productname" => $this->productname(),
                "grouplevel1" => $this->grouplevel1(),
                "grouplevel2" => $this->grouplevel2(),
            ];
            $responseBody = $this->responseBody(true, "AllSettings", "all", ["settings" => $settings]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "AllSettings", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function stores()
    {

        try {
            $store = StoreLocation::all();
            $collection = [];
            for ($i = 0; $i < count($store); $i++) {
                array_push($collection, ["id" => $store[$i]['id'], "value" => $store[$i]['name']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }

    public function producttype()
    {

        try {
            $type = ProductType::all();
            $collection = [];
            for ($i = 0; $i < count($type); $i++) {
                array_push($collection, ["id" => $type[$i]['product_type_id'], "value" => $type[$i]['product_type']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }


    public function productname()
    {

        try {
            $product = Product::all();
            $result = array();
            foreach ($product as $pr) {
                array_push($result, [
                    "img" => "",
                    "id" => $pr->product_primary_id,
                    "value" => $pr->product_id . " - " . $pr->product_name,
                ]);
            }
            return $result;
        } catch (\Exception $exception) {
            return $exception;
        }
    }


    public function grouplevel1()
    {

        try {
            $groupLevel = GroupLevel1::all();
            $collection = [];
            for ($i = 0; $i < count($groupLevel); $i++) {
                array_push($collection, ["id" => $groupLevel[$i]['group_level_1_id'], "value" => $groupLevel[$i]['group_level_1']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }


    public function grouplevel2()
    {

        try {
            $groupLevel = GroupLevel2::all();
            $collection = [];
            for ($i = 0; $i < count($groupLevel); $i++) {
                array_push($collection, ["id" => $groupLevel[$i]['group_level_2_id'], "value" => $groupLevel[$i]['group_level_2']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }




    public function productHistoryReport($setting, $date_form, $date_to)
    {
        try {
            $title = '';
            $setting_aaray =  json_decode($setting);

            $stores = $setting_aaray->stores;
            $producttype = $setting_aaray->producttype;
            $productname = $setting_aaray->productname;
            $grouplevel1 = $setting_aaray->grouplevel1;
            $grouplevel2 = $setting_aaray->grouplevel2;
            $openingBalance = $this->getOpeningBalance($setting, $date_form, $date_to);

            ini_set('max_execution_time', '0'); // for infinite time of execution

            $query = "SELECT DATE(sc_product_histories.created_at)AS date,
            sc_product_histories.external_id,
            st_products.product_name,
            sc_product_histories.description,
            sc_product_histories.quantity AS quantity,
            0 AS balance 
            FROM  sc_product_histories 
            INNER JOIN st_products ON sc_product_histories.product_id = st_products.product_primary_id 
            WHERE ";

            if ($producttype != '') {
                $query .= "st_products.product_type_id = '" . $producttype . "' AND ";
                $title = '';
            }

            if ($stores != '') {
                $query .= "sc_product_histories.store_id = '" . $stores . "' AND ";
                $title = '';
            }

            if ($productname != '') {
                $query .= "sc_product_histories.product_id = '" . $productname . "' AND ";
                $title = '';
            }
            if ($grouplevel1 != '') {
                $query .= "st_products.group_id_level_1 = '" . $grouplevel1 . "' AND ";
                $title = '';
            }

            if ($grouplevel2 != '') {
                $query .= "st_products.group_id_level_2 = '" . $grouplevel2 . "' AND ";
                $title = '';
            }


            $query = preg_replace('/\W\w+\s*(\W*)$/', '$1', $query);
            $query .= " AND DATE(sc_product_histories.created_at) BETWEEN '" . $date_form . "' AND '" . $date_to . "' ";

            $sproductHistory = DB::select($query);
            $balance = $openingBalance;
            foreach ($sproductHistory as $product) {
                $balance = $product->quantity + $balance;
                $product->balance = ($product->balance + $balance);
                $product->quantity = abs($product->quantity);
            }
            $responseBody = $this->responseBody(true, $query, "Report", [
                'opening_balance' => $openingBalance,
                'body' => $sproductHistory,
                'title' => $title,
                "report_date" => " From " . $date_form  . "  to " . $date_to . "",
                "query" => $query,
            ]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "StockReportController", "Report", $query);
        }
        return response()->json(["data" => $responseBody]);
    }



    private function getOpeningBalance($setting, $date_form, $date_to)
    {


        $setting_aaray =  json_decode($setting);
        $stores = $setting_aaray->stores;
        $productname = $setting_aaray->productname;
        $grouplevel1 = $setting_aaray->grouplevel1;
        $grouplevel2 = $setting_aaray->grouplevel2;

        ini_set('max_execution_time', '0'); // for infinite time of execution

        $query = "SELECT SUM(sc_product_histories.quantity)AS quantity,0 AS balance FROM  sc_product_histories INNER JOIN st_products ON sc_product_histories.product_id = st_products.product_primary_id WHERE ";



        if ($stores != '') {
            $query .= "sc_product_histories.store_id = '" . $stores . "' AND ";
        }

        if ($productname != '') {
            $query .= "sc_product_histories.product_id = '" . $productname . "' AND ";
        }

        if ($grouplevel1 != '') {
            $query .= "st_products.group_id_level_1 = '" . $grouplevel1 . "' AND ";
        }

        if ($grouplevel2 != '') {
            $query .= "st_products.group_id_level_2 = '" . $grouplevel2 . "' AND ";
        }



        $query = preg_replace('/\W\w+\s*(\W*)$/', '$1', $query);
        //
        $previous_date = date('Y-m-d', strtotime($date_form . ' -1 day'));
        
        $query .= " AND DATE(sc_product_histories.created_at) BETWEEN '" . $this->getMinimumDate() . "'  AND '" . $previous_date . "' GROUP BY sc_product_histories.document_no";

        $sproductHistory = DB::select($query);
        $openingBalance = 0;
        if ($this->getMinimumDate() != $date_form) {
            foreach ($sproductHistory as $product) {
                $openingBalance = $product->quantity + $openingBalance;
            }
        }

        return $openingBalance;
    }


    private function getMinimumDate()
    {

        $query = "SELECT MIN(DATE(sc_product_histories.created_at)) AS min_date FROM sc_product_histories";
        return DB::select($query)[0]->min_date;
    }



    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
