<?php

namespace Modules\Sc\Http\Controllers;

use App\Http\Controllers\MailController;
use App\Mail\MailData;
use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\Employee;
use Modules\Pp\Entities\CustomerPlan;
use Modules\Sc\Entities\Department;
use Modules\Sc\Entities\DocumentNumber;
use Modules\Sc\Entities\OrderType;
use Modules\Sc\Entities\PayTerm;
use Modules\Sc\Entities\PurchaseOrderAttachment;
use Modules\Sc\Entities\PurchaseOrderData;
use Modules\Sc\Entities\PurchaseOrderDataOther;
use Modules\Sc\Entities\PurchaseOrderHeader;
use Modules\Sc\Entities\StoreLocation;
use Modules\St\Entities\Currency;
use Modules\St\Entities\Product;
use Modules\St\Entities\ProductUnit;
use Modules\St\Entities\Suppliers;
use Modules\St\Entities\Uom;

class PurchaseOrderController extends Controller
{
    public function allEmployees()
    {
        try {
            $employees = Employee::all();
            $result = array();
            foreach ($employees as $emp) {
                array_push($result, [
                    "img" => "",
                    "id" => $emp->employee_id,
                    "value" => $emp->name_withinitial,
                ]);
            }
            $responseBody = $this->responseBody(true, "PurchaseRequestController", "allEmployees", $result);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseRequestController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function allDepartment()
    {
        try {
            $department =  Department::all();
            $responseBody = $this->responseBody(true, "PurchaseRequestController", "allDepartment", $department);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseRequestController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }





    public function allProduct()
    {
        try {
            $products =  Product::select('product_primary_id As id', 'product_id As value0', 'product_name As value1')->get();
            return $this->responseBody(true, "PurchaseRequestController", "allProduct", $products);
        } catch (Exception $exception) {
            return $this->responseBody(false, "PurchaseRequestController", "error", $exception);
        }
    }




    public function allProductUnit()
    {
        try {
            $products =  ProductUnit::all();
            $responseBody = $this->responseBody(true, "PurchaseRequestController", "allProductUnit", $products);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseRequestController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    public function allStores()
    {
        try {
            $stores =  StoreLocation::all();
            $responseBody = $this->responseBody(true, "PurchaseRequestController", "allStores", $stores);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseRequestController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function allPayTerms()
    {
        try {
            $payTerms =  PayTerm::all();
            $responseBody = $this->responseBody(true, "PurchaseRequestController", "allPayTerms", $payTerms);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseRequestController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function allOrderType()
    {
        try {
            $orderType =  OrderType::all();
            $responseBody = $this->responseBody(true, "PurchaseRequestController", "allPayTerms", $orderType);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseRequestController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function allCurrency()
    {
        try {
            $currency =  Currency::all();
            $responseBody = $this->responseBody(true, "PurchaseRequestController", "allCurrency", $currency);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseRequestController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function allProductCustomer()
    {
        try {
            $orderPlan =  CustomerPlan::all();
            $responseBody = $this->responseBody(true, "PurchaseRequestController", "allProductCustomer", $orderPlan);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseRequestController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function save(Request $request)
    {
        try {
            $prefix = $this->getPrefix('310');
            $purchase = new PurchaseOrderHeader();
            $purchase->external_id = $prefix . "" . $request->get('external_id');
            $purchase->ref_external_id = $prefix . "" . $request->get('ref_external_id');
            $purchase->ref_pr_id = $request->get('purchase_request_no');
            $purchase->trans_date = $request->get('trans_date');
            $purchase->supplier_id = $request->get('supplier_id');
            $purchase->store_id = $request->get('store_id');
            $purchase->order_by = "0";
            $purchase->employee_name = $request->get('order_by');
            $purchase->deliver_before = $request->get('deliver_before');
            $purchase->pay_term_id = $request->get('pay_term');
            $purchase->order_type_id = $request->get('order_type');
            $purchase->mr_internal_id = $request->get('mr_internal_id');
            $purchase->mr_extenal_id = $request->get('mr_extenal_id');
            $purchase->remarks = $request->get('remarks');
            $purchase->discount_overall = $request->get('discount_overall');
            $purchase->gross_value = $request->get('gross_value');
            $purchase->discount = $request->get('discount');
            $purchase->net_value = $request->get('net_value');
            $purchase->currency_id = $request->get('currency');
            $purchase->exchange_rate = $request->get('exchange_rate');
            $purchase->Status = 0;
            $purchase->user_id = Auth::user()->id;
            if ($purchase->save()) {
                $purchase = PurchaseOrderHeader::find($purchase->internal_id);
                $purchase->ref_internal_id = $purchase->internal_id;
                $purchase->update();
                $purchase_arr = $request->get("order_data");
                if ($purchase_arr) {
                    for ($i = 0; $i < count($purchase_arr); $i++) {
                        $prh_data = new PurchaseOrderData();
                        $prh_data->internal_id = $purchase->internal_id;
                        $prh_data->external_id = $purchase->external_id;
                        $prh_data->product_id =  $purchase_arr[$i]["product_id"];
                        $prh_data->unit_id =  $purchase_arr[$i]["unit_id"];
                        $prh_data->quantity =  $purchase_arr[$i]["qty"];
                        $prh_data->price =  $purchase_arr[$i]["price"];
                        $prh_data->discount =  $purchase_arr[$i]["discount"];
                        $prh_data->value =  $purchase_arr[$i]["value"];
                        $prh_data->save();
                    }
                }


                $purchase__other_arr = $request->get("order_other");
                if ($purchase__other_arr) {
                    for ($i = 0; $i < count($purchase__other_arr); $i++) {
                        $description = $purchase__other_arr[$i]["description"];
                        $qty = $purchase__other_arr[$i]["quantity"];
                        $price = $purchase__other_arr[$i]["price"];
                        $discount = $purchase__other_arr[$i]["discount"];
                        $value = $purchase__other_arr[$i]["value"];

                        if ($description == null) {
                            $description = "";
                        }
                        if ($qty == null) {
                            $qty = "";
                        }
                        if ($price == null) {
                            $price = "";
                        }
                        if ($discount == null) {
                            $discount = "";
                        }
                        if ($value == null) {
                            $value = "";
                        }
                        $prh_other = new PurchaseOrderDataOther();
                        $prh_other->internal_id = $purchase->internal_id;
                        $prh_other->external_id = $purchase->external_id;
                        $prh_other->description = $description;
                        $prh_other->quantity = $qty;
                        $prh_other->price =  $price;
                        $prh_other->discount =  $discount;
                        $prh_other->value =  $value;
                        $prh_other->save();
                    }
                }


                $attachmnet_token = $request->get("attachment_token");
                $attachments = PurchaseOrderAttachment::where('token', '=', $attachmnet_token)->get();
                //$email_body = "PO : " . $purchase->external_id . "<br> Created By : " . Auth::user()->name;
                //$attachment_no = 1;
                foreach ($attachments as $attachmnet) {
                    if ($attachmnet) {
                        $attachmnet->purchase_order_id = $purchase->internal_id;
                        $attachmnet->update();
                        //$email_body .= "<br> Attachment" . $attachment_no . " : http://127.0.0.1:8000/purchase_order/" . $attachmnet->path;
                        //$attachment_no += 1;
                    }
                }
                /*$recievers = MailData::getRecievers();
                foreach ($recievers as $address) {
                    MailController::createMail($email_body, MailData::getSender(), $address);
                }*/
            }
            $responseBody = $this->responseBody(true, "PurchaseRequestController", "saveGrnHeaderTemp", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseRequestController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }






    public function getPurchaseOrder($id)
    {
        try {
            $purchase = PurchaseOrderHeader::find($id);
            if (count(array_filter(explode("-", $purchase->external_id))) == 2) {
                $purchase->external_id = explode("-", $purchase->external_id)[1];
            }
            $supplier = Suppliers::find($purchase->supplier_id);
            $purchase->supplier = $supplier->supplier_name;
            $purchase_data = PurchaseOrderData::where('internal_id', '=', $id)->get();
            foreach ($purchase_data as $data) {
                $product = Product::where('product_primary_id', '=', $data->product_id)->first();
                $data->product = $product->product_name;
                $uom = ProductUnit::find($product->uom_id);
                $uom_arr = [];
                if ($uom) {
                    array_push($uom_arr, ["value" => $uom->id, "text" => $uom->name]);
                }
                $data->uom = $uom_arr;
                $data->product_primary_id = $product->product_primary_id;
                $data->product_id = $product->product_id;
            }
            $purchase->request_data = $purchase_data;
            $purchase_other = PurchaseOrderDataOther::where('internal_id', '=', $id)->get();
            $purchase->request_other = $purchase_other;
            $responseBody = $this->responseBody(true, "PurchaseOrderController", "getPurchaseOrder", $purchase);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseOrderController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function getPurchaseOrderByExternalID($id){
        
        try {
            $purchase = PurchaseOrderHeader::where('external_id', '=', $id)->first();
            if (count(array_filter(explode("-", $purchase->external_id))) == 2) {
                $purchase->external_id = explode("-", $purchase->external_id)[1];
            }
            $supplier = Suppliers::find($purchase->supplier_id);

            $purchase->supplier = $supplier->supplier_name;
            $purchase_data = PurchaseOrderData::where('external_id', '=', $id)->get();

            foreach ($purchase_data as $data) {
                $product = Product::where('product_primary_id', '=', $data->product_id)->first();
                $data->product = $product->product_name;
                $uom = ProductUnit::find($product->uom_id);
                $uom_arr = [];
                if ($uom) {
                    array_push($uom_arr, ["value" => $uom->id, "text" => $uom->name]);
                }
                $data->uom = $uom_arr;
                $data->product_primary_id = $product->product_primary_id;
                $data->product_id = $product->product_id;
            }
            $purchase->request_data = $purchase_data;
            $purchase_other = PurchaseOrderDataOther::where('external_id', '=', $id)->get();
            $purchase->request_other = $purchase_other;
           
            $responseBody = $this->responseBody(true, "PurchaseOrderController", "getPurchaseOrder", $purchase);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseOrderController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function update(Request $request, $id)
    {

        try {
            if ($this->delete($id)) {
                $prefix = $this->getPrefix('310');
                $purchase = PurchaseOrderHeader::find($id);
                $purchase->external_id = $prefix . "" . $request->get('external_id');
                $purchase->ref_external_id = $prefix . "" . $request->get('ref_external_id');
                $purchase->trans_date = $request->get('trans_date');
                $purchase->supplier_id = $request->get('supplier_id');
                $purchase->store_id = $request->get('store_id');
                $purchase->employee_name = $request->get('order_by');
                $purchase->deliver_before = $request->get('deliver_before');
                $purchase->pay_term_id = $request->get('pay_term');
                $purchase->order_type_id = $request->get('order_type');
                $purchase->mr_internal_id = $request->get('mr_internal_id');
                $purchase->mr_extenal_id = $request->get('mr_extenal_id');
                $purchase->remarks = $request->get('remarks');
                $purchase->discount_overall = $request->get('discount_overall');
                $purchase->gross_value = $request->get('gross_value');
                $purchase->discount = $request->get('discount');
                $purchase->net_value = $request->get('net_value');
                $purchase->currency_id = $request->get('currency');
                $purchase->exchange_rate = $request->get('exchange_rate');
                $purchase->update();

                $purchase_arr = $request->get("order_data");
                if ($purchase_arr) {
                    for ($i = 0; $i < count($purchase_arr); $i++) {
                        $prh_data = new PurchaseOrderData();
                        $prh_data->internal_id = $purchase->internal_id;
                        $prh_data->external_id = $purchase->external_id;
                        $prh_data->product_id =  $purchase_arr[$i]["product_id"];
                        if ($purchase_arr[$i]["unit_id"]) {
                            $prh_data->unit_id =  $purchase_arr[$i]["unit_id"];
                        }
                        $prh_data->quantity =  $purchase_arr[$i]["qty"];
                        $prh_data->price =  $purchase_arr[$i]["price"];
                        $prh_data->discount =  $purchase_arr[$i]["discount"];
                        $prh_data->value =  $purchase_arr[$i]["value"];
                        $prh_data->save();
                    }
                }


                $purchase__other_arr = $request->get("order_other");
                if ($purchase__other_arr) {
                    for ($i = 0; $i < count($purchase__other_arr); $i++) {
                        $description = $purchase__other_arr[$i]["description"];
                        $qty = $purchase__other_arr[$i]["quantity"];
                        $price = $purchase__other_arr[$i]["price"];
                        $discount = $purchase__other_arr[$i]["discount"];
                        $value = $purchase__other_arr[$i]["value"];

                        if ($description == null) {
                            $description = "";
                        }
                        if ($qty == null) {
                            $qty = "";
                        }
                        if ($price == null) {
                            $price = "";
                        }
                        if ($discount == null) {
                            $discount = "";
                        }
                        if ($value == null) {
                            $value = "";
                        }
                        $prh_other = new PurchaseOrderDataOther();
                        $prh_other->internal_id = $purchase->internal_id;
                        $prh_other->external_id = $purchase->external_id;
                        $prh_other->description = $description;
                        $prh_other->quantity = $qty;
                        $prh_other->price =  $price;
                        $prh_other->discount =  $discount;
                        $prh_other->value =  $value;
                        $prh_other->save();
                    }
                }


                $attachmnet_token = $request->get("attachment_token");
                $attachments = PurchaseOrderAttachment::where('token', '=', $attachmnet_token)->get();
                foreach ($attachments as $attachmnet) {
                    if ($attachmnet) {
                        $attachmnet->purchase_order_id = $purchase->internal_id;
                        $attachmnet->update();
                    }
                }
            }
            $responseBody = $this->responseBody(true, "PurchaseRequestController", "update", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseRequestController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function delete($id)
    {
        try {
            $purchase_data = PurchaseOrderData::where('internal_id', '=', $id)->get();
            foreach ($purchase_data as $data) {
                $data->delete();
            }
            $purchase_other = PurchaseOrderDataOther::where('internal_id', '=', $id)->get();
            foreach ($purchase_other as $data) {
                $data->delete();
            }
            return true;
        } catch (Exception $exception) {
            return false;
        }
    }



    public function getUom($id)
    {
        try {
            $product =  Product::where('product_primary_id', '=', $id)->first();

            $data = [
                "id" => "0",
                "value" => "",
            ];
            if ($product) {
                $uom =  ProductUnit::find($product->uom_id);
                if ($uom) {
                    $data["id"] = $uom->id;
                    $data["value"] = $uom->name;
                }
            }

            $responseBody = $this->responseBody(true, "PurchaseRequestController", "getUom", $data);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseRequestController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }





    public function uploadAttachment(Request $request)
    {

        $id = $request->get('purcahse_order_id');
        $token = $request->get('attachmnet_token');
        $file = $request->file('file');
        $file_name = $file->getClientOriginalName();
        $filename = uniqid() . '_' . time() . '.' . $file_name;
        $filename = str_replace(' ','',str_replace('\'','',$filename));
        $file->move(public_path('purchase_order'), $filename);

        $purchase_order_attachment = new PurchaseOrderAttachment();
        $purchase_order_attachment->purchase_order_id = 0;
        $purchase_order_attachment->path = $filename;
        $purchase_order_attachment->token = $token;
        return $purchase_order_attachment->save();
    }



    public function allAttachment($id, $token)
    {
        try {

            $attachment = DB::select('SELECT *FROM sc_purchase_order_attachments WHERE  purchase_order_id = "' . $id . '" OR token = "' . $token . '"');
            $responseBody = $this->responseBody(true, "allAttachment", "found", $attachment);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "allAttachment", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    private function getPrefix($document_no)
    {
        $document_no = DocumentNumber::where('document_number', '=', $document_no)->first();
        $prefix = "";
        if ($document_no) {
            $prefix = $document_no->prefix;
        }

        return $prefix;
    }

    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
