<?php

namespace Modules\Sc\Http\Controllers;

use App\Http\Controllers\MailController;
use App\Mail\MailData;
use App\Models\User;
use App\Notifications\UserNotification;
use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\Employee;
use Modules\Hr\Entities\EmployeeDepartment;
use Modules\Pd\Entities\ScheduleCustomerOrderPlan;
use Modules\Pd\Entities\ScheduleCustomerOrderPlanData;
use Modules\Pd\Entities\ScheduleOrderResourceBom;
use Modules\PJ\Entities\Project;
use Modules\Pp\Entities\CustomerOrder;
use Modules\Pp\Entities\CustomerPlan;
use Modules\Pp\Entities\CustomerPlanData;
use Modules\Pp\Entities\Machinary;
use Modules\Sc\Entities\DocumentNumber;
use Modules\Sc\Entities\MaterialRequestReason;


use Modules\Sc\Entities\RawMaterialRequisitionHeader;
use Modules\Sc\Entities\RawMaterialRequisitionData;
use Modules\Sc\Entities\RawMaterialRequisitionDataOther;

// use Modules\Sc\Entities\MaterialRequisitionDataOther;
// use Modules\Sc\Entities\MaterialRequisitionHeader;
// use Modules\Sc\Entities\MaterialRequisitionData;

use Modules\Sc\Entities\StoreLocation;
use Modules\Sc\Entities\Department;
use Modules\Sc\Entities\TransactionApproval;
use Modules\St\Entities\Product;
use Modules\St\Entities\ProductUnit;
use Modules\St\Entities\UnitOfMesurement;
use Modules\St\Entities\Uom;



class RawMaterialRequisitionController extends Controller
{


    public function allRawMaterialRequisition($department_id, $status)
    {
        try {
            if ($department_id != 'any' && $status == 'any') {
                $mrqList = RawMaterialRequisitionHeader::select('*')->where('dept_id', '=', $department_id)->orderBy('internal_id', 'DESC')->get();
            } else if ($department_id == 'any' && $status != 'any') {
                $mrqList = RawMaterialRequisitionHeader::select('*')->where('status', '=', $status)->orderBy('internal_id', 'DESC')->get();
            } else if ($department_id != 'any' && $status != 'any') {
                $mrqList = RawMaterialRequisitionHeader::select('*')->where([['dept_id', '=', $department_id], ['status', '=', $status]])->orderBy('internal_id', 'DESC')->get();
            } else {
                $mrqList = RawMaterialRequisitionHeader::select('*')->orderBy('internal_id', 'DESC')->get();
            }
            foreach ($mrqList as $mrq) {
                $mrq->department = '';
                $mrq->type = '';
                $department = EmployeeDepartment::find($mrq->dept_id);
                if ($department) {
                    $mrq->department = $department->department;
                }
                if ($mrq->mi_type == 0) {
                    $mrq->type = 'General';
                } else if ($mrq->mi_type == 1) {
                    $mrq->type = 'Production';
                } else if ($mrq->mi_type == 2) {
                    $mrq->type = 'Project';
                } else if ($mrq->mi_type == 3) {
                    $mrq->type = 'Transport';
                }
            }
            $responseBody = $this->responseBody(true, "MaterialRiquisitionListController", "allMaterialRequisition", $mrqList);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialRiquisitionListController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }
    
    


    public function allProduct()
    {
        try {
            $products =  Product::select('product_primary_id As id', 'product_id As value0', 'product_name As value1')
                        ->where('product_type_id', '=', 1)
                        ->get();            
             
            return $this->responseBody(true, "MaterialRequisitionController", "allProduct", $products);
        } catch (Exception $exception) {
            return $this->responseBody(false, "MaterialRequisitionController", "error", $exception);
        }
    }

    public function allEmployees()
    {
        try {
            $employees = Employee::all();
            $result = array();
            foreach ($employees as $emp) {
                array_push($result, [
                    "img" => "",
                    "id" => $emp->employee_id,
                    "value" => $emp->name_withinitial,
                ]);
            }
            $responseBody = $this->responseBody(true, "MaterialRequisitionController", "allEmployees", $result);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialRequisitionController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function allProjects()
    {
        try {
            $projects = Project::all();
            $responseBody = $this->responseBody(true, "MaterialRequisitionController", "allProjects", $projects);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnReturnController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function allDepartment()
    {
        try {
            $department =  EmployeeDepartment::all();
            $responseBody = $this->responseBody(true, "MaterialRequisitionController", "allDepartment", $department);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialRequisitionController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function allMachinery()
    {
        try {
            $machinery =  Machinary::all();
            $responseBody = $this->responseBody(true, "MaterialRequisitionController", "allMachinery", $machinery);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialRequisitionController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function allMaterialRequestReason()
    {
        try {
            $reasons =  MaterialRequestReason::all();
            $responseBody = $this->responseBody(true, "MaterialRequisitionController", "allMaterialRequestReason", $reasons);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialRequisitionController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    


    public function maxID($store_id)
    {
        try {
            $id = DB::select('SELECT AUTO_INCREMENT  AS id FROM information_schema.TABLES WHERE TABLE_SCHEMA = "erp_riococo_salary3" AND TABLE_NAME = "sc_grn_headers"')[0]->id;
            $store = StoreLocation::find($store_id);
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
            }
            $responseBody = $this->responseBody(true, "MaterialRequisitionController", "allProductUnit", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialRequisitionController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function allProductUnit()
    {
        try {
            $products =  ProductUnit::all();
            $responseBody = $this->responseBody(true, "MaterialRequisitionController", "allProductUnit", $products);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialRequisitionController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    public function allStores()
    {
        try {
            $stores =  StoreLocation::all();
            $responseBody = $this->responseBody(true, "MaterialRequisitionController", "allStores", $stores);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialRequisitionController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function allProductCustomer()
    {
        try {
            $orderPlan =  CustomerPlan::all();
            $responseBody = $this->responseBody(true, "MaterialRequisitionController", "allProductCustomer", $orderPlan);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialRequisitionController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    public function rawMaterialRequisitionReport($id)
    {
        try {
            $material_requisition_header = RawMaterialRequisitionHeader::find($id);
            
            $header = [
                "referance_no" => "",
                "date" => "",
                "department" => "",
                "store" => "",
                "type" => "",
                "manufacturing_order" => "",
                "machine_no" => "",
                "supervisor" => "",
            ];


            if ($material_requisition_header) {
                $header["referance_no"] = $material_requisition_header->external_id;
                $header["date"] = $material_requisition_header->trans_date;
                $header["supervisor"] = $this->getSupervisor($material_requisition_header->supervisor_id);
                $header["department"] = $this->getDepartment($material_requisition_header->dept_id);
                $header["store"] = $this->getStore($material_requisition_header->store_id);
                $header["type"] = $this->getType($material_requisition_header->mi_type);
                $header["manufacturing_order"] = $material_requisition_header->manufacturing_order_number;
                $header["machine_no"] = $this->getMachine($material_requisition_header->machine_id);
            }

            

            $data = RawMaterialRequisitionData::where('internal_id', '=', $id)->get();
            foreach ($data as $dd) {
                $product = Product::find($dd->product_id);
                $dd->product_id = $product->product_id;
                $dd->product = $product->product_name;
                $uom = ProductUnit::find($dd->unit_id);
                if ($uom) {
                    $dd->unit = $uom->name;
                } else {
                    $dd->unit = "";
                }
            }


            $responseBody = $this->responseBody(true, "MaterialRiquisitionListController", "materialRequisitionReport", ["header" => $header, "body" => ["data" => $data]]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialRiquisitionListController", "materialRequisitionReport", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }

        private function getSupervisor($id)
    {

        $supervisor = Employee::find($id);
        if ($supervisor) {
            return $supervisor->name_withinitial;
        }
        return "";
    }



    private function getDepartment($id)
    {

        $department = Department::find($id);
        if ($department) {
            return $department->department;
        }
        return "";
    }


    private function getStore($id)
    {
        $store = StoreLocation::find($id);
        if ($store) {
            return $store->name;
        }
        return "";
    }



    private function getType($id)
    {
        if ($id == 0) {
            return "General";
        } else if ($id == 1) {
            return "Production";
        } else if ($id == 2) {
            return "Maintenance";
        }
        return "";
    }



    private function getMachine($id)
    {
        $machine = Machinary::find($id);
        if ($machine) {
            return $machine->machinery_no;
        }
        return "";
    }




    public function save(Request $request)
    {

        try {
            $prefix = $this->getPrefix('20');
            $customer_order_plan_id = $request->get('customer_order_plan_id');
            $customer_order_plan_data = CustomerPlanData::where('customer_order_plan_id', '=', $customer_order_plan_id)->first();
            
            $mrq = new RawMaterialRequisitionHeader();
            
            $mrq->external_id = $prefix . "" . $request->get('external_id');
            $mrq->ref_external_id = $prefix . "" . $request->get('ref_external_id');
            $mrq->trans_date = $request->get('trans_date');
            $mrq->dept_id = $request->get('dept_id');
            $mrq->machine_id = $request->get('machine_id');
            $mrq->store_id = $request->get('store_id');
            $mrq->supervisor_id = "0";
            $mrq->employee_name = $request->get('employee_name');
            $mrq->mi_type = $request->get('mi_type');
            $mrq->manufacturing_order_number = $request->get('manufacturing_order_number');
            if ($customer_order_plan_data) {
                $mrq->customer_order_plan_data_id = $customer_order_plan_data->customer_order_plan_data_id;
            }
            $mrq->material_request_reason_id = $request->get('reason');
            $mrq->project_code = $request->get('project_code');
            $mrq->remarks = $request->get('remarks');
            $mrq->vehicle_no = $request->get('vehicle_no');
            $mrq->first_weight = $request->get('first_weight');
            $mrq->first_weight_time = $request->get('first_weight_time');
            $mrq->second_weight = $request->get('second_weight');
            $mrq->second_weight_time = $request->get('second_weight_time');
            $mrq->Status = 0;
            $mrq->user_id = Auth::user()->id;
            $mrq->save();
            
            if ($mrq->save()) {
                $mrq_arr = $request->get("mrq_data");
                for ($i = 0; $i < count($mrq_arr); $i++) {
                    $mrqData = json_decode($mrq_arr[$i]);
                    $mrq_data = new RawMaterialRequisitionData();
                    $mrq_data->internal_id = $mrq->internal_id;
                    $mrq_data->external_id = $mrq->external_id;
                    $mrq_data->product_id =  $mrqData->product_id;
                    $mrq_data->unit_id =  $mrqData->unit_id;
                    $mrq_data->quantity =  $mrqData->qty;
                    $mrq_data->transfer_quantity =  0;
                    $mrq_data->issues_quantity =  0;
                    $mrq_data->comments =  $mrqData->comments;
                    $mrq_data->save();
                }


                $purchase__other_arr = $request->get("request_other");
                for ($i = 0; $i < count($purchase__other_arr); $i++) {
                    $material_requisition_other = new RawMaterialRequisitionDataOther();
                    $material_requisition_other->internal_id = $mrq->internal_id;
                    $material_requisition_other->external_id = $mrq->external_id;
                    $material_requisition_other->description = $purchase__other_arr[$i]["description"];
                    $material_requisition_other->quantity = $purchase__other_arr[$i]["quantity"];
                    $material_requisition_other->save();
                }


                // $this->sendNotification($mrq_data->created_at);
                // $this->sendMail($mrq_data->created_at);
            }
            $responseBody = $this->responseBody(true, "RawMaterialRequisitionController", "save", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "RawMaterialRequisitionController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }






    public function getRawMaterialRequisition($id)
    {
        try {
            $mrq = RawMaterialRequisitionHeader::find($id);
            if (count(array_filter(explode("-", $mrq->external_id))) == 2) {
                $mrq->external_id = explode("-", $mrq->external_id)[1];
            }
            //$supervisor = Employee::find($mrq->supervisor_id);
            //$mrq->supervisor = $supervisor->name_withinitial;
            //$received = Employee::find($mrq->received_by);

            $mi_data = RawMaterialRequisitionData::where('internal_id', '=', $id)->get();
            foreach ($mi_data as $data) {
                $product = Product::where('product_primary_id', '=', $data->product_id)->first();
                $data->product = $product->product_name;
                $uom = ProductUnit::find($product->uom_id);
                $uom_arr = [];
                if ($uom) {
                    array_push($uom_arr, ["value" => $uom->id, "text" => $uom->name]);
                }
                $data->uom = $uom_arr;
                $data->product_primary_id = $product->product_primary_id;
                $data->product_id = $product->product_id;
            }
            $customer_order_plan_data = CustomerPlanData::find($mrq->customer_order_plan_data_id);
            if ($customer_order_plan_data) {
                $mrq->customer_order_plan_id = $customer_order_plan_data->customer_order_plan_id;
            }
            $mrq->data = $mi_data;
            $material_request_other = RawMaterialRequisitionDataOther::where('internal_id', '=', $id)->get();
            $mrq->request_other = $material_request_other;
            $responseBody = $this->responseBody(true, "MaterialRequisitionController", "getGrn", $mrq);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialRequisitionController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function getQty($product_id, $store_id)
    {
        try {
            $query = "SELECT SUM(quantity) AS quantity FROM sc_product_histories WHERE product_id = '" . $product_id . "' AND store_id = '" . $store_id . "'";
            $result = DB::select($query);
            $quantity = 0;
            foreach ($result as $data) {
                if ($data->quantity) {
                    $quantity = $data->quantity;
                }
            }
            $responseBody = $this->responseBody(true, "MaterialRequisitionController", "getQty", $quantity);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialRequisitionController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function update(Request $request, $id)
    {

        try {
            $mi_header = RawMaterialRequisitionHeader::find($id);
            if ($mi_header) {
                if ($this->delete($mi_header->external_id)) {
                    if ($mi_header->delete()) {
                        $bool =  $this->save($request);
                    }
                }
            }
            $responseBody = $this->responseBody(true, "MaterialRequisitionController", "update", $bool);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialRequisitionController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function delete($id)
    {
        try {
            $mrq_data = RawMaterialRequisitionData::where('external_id', '=', $id)->get();
            foreach ($mrq_data as $data) {
                $data->delete();
            }
            $responseBody = $this->responseBody(true, "MaterialRequisitionController", "delete", true);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialRequisitionController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function getUom($id)
    {
        try {
            $product =  Product::where('product_primary_id', '=', $id)->first();

            $data = [
                "id" => "0",
                "value" => "",
            ];
            if ($product) {
                $uom =  ProductUnit::find($product->uom_id);
                if ($uom) {
                    $data["id"] = $uom->id;
                    $data["value"] = $uom->name;
                }
            }

            $responseBody = $this->responseBody(true, "PurchaseRequestController", "getUom", $data);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseRequestController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function getScheduledFactoryPO()
    {
        try {
            $query = 'SELECT pp_customer_order_plans.customer_order_plan_id,
            pp_customer_orders.factory_po_num,
            st_products.product_name,
            pp_customer_order_plans_data.customer_order_plan_data_id
            FROM pp_customer_order_plans
            LEFT JOIN pp_customer_orders ON pp_customer_order_plans.order_id = pp_customer_orders.order_id
            LEFT JOIN pp_customer_order_plans_data ON pp_customer_order_plans.customer_order_plan_id = pp_customer_order_plans_data.customer_order_plan_id
            LEFT JOIN st_products ON pp_customer_order_plans_data.product_id = st_products.product_primary_id
			ORDER BY pp_customer_order_plans.customer_order_plan_id DESC';
            $orderPlan =  DB::select($query);

            $responseBody = $this->responseBody(true, "PurchaseRequestController", "getScheduledFactoryPO", $orderPlan);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseRequestController", "getScheduledFactoryPO", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function getProductFromOrder($id)
    {
        try {
            $query = 'SELECT
            st_products.product_primary_id,
            st_products.product_id,
            st_products.product_name
            FROM pd_schedule_customer_order_plans
            INNER JOIN pd_schedule_customer_order_plan_data ON pd_schedule_customer_order_plans.customer_order_plan_id=pd_schedule_customer_order_plan_data.customer_order_plan_id
            INNER JOIN st_products ON pd_schedule_customer_order_plan_data.product_id = st_products.product_primary_id WHERE pd_schedule_customer_order_plans.order_id = "' . $id . '"';
            $data = DB::select($query);

            $responseBody = $this->responseBody(true, "PurchaseRequestController", "getProductFromOrder", $data);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseRequestController", "getProductFromOrder", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function getBomHeader($order_id)
    {
        try {

            $plan = CustomerOrder::find($order_id);
            $schedulePlan = CustomerPlan::find($order_id);
            $bomData = [];
            $order_plan_data_id = '';
            $product_primary_id = '';
            if ($schedulePlan) {

                $plan_data = CustomerPlanData::where('customer_order_plan_id', '=', $schedulePlan->customer_order_plan_id)->first();
                if ($plan_data) {
                    $order_plan_data_id = $plan_data->customer_order_plan_data_id;
                    $product_primary_id = $plan_data->product_id;
                    $bomData = $this->getBOMData($plan_data->customer_order_plan_data_id, $plan_data->product_id);
                }
            }

            $product = Product::find($product_primary_id);
            $product_name = '';
            if ($product) {
                $product_name = $product->product_name;
            }
            $allocated_qty = $this->getAllocatedQuantity($schedulePlan->order_id, $product_primary_id, '');
            $bom_header_qty = $this->getBomHeaderQuantityProduct($product_primary_id);

            $responseBody = $this->responseBody(true, "CustomerPlanData", "getSelectedProductData", ["allocated_quantity" => $allocated_qty, "bom_header_quantity" => $bom_header_qty, "customer_po" => $plan->purchase_order, "bom_data" =>  $bomData, "customer_order_plan_data_id" => $order_plan_data_id, "product_id" => $product_primary_id, "product_name" => $product_name]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "AllocateMachineController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    public function setScheduleBom($order_plan_data_id, $fg_product_id)
    {
        try {

            $bomdata = $this->getBOMData($order_plan_data_id, $fg_product_id);
            foreach ($bomdata as $plan) {
                $plan->product_primary_id = "";
                $plan->product_id = "";
                $plan->product_name = "";
                //$plan->uom = [];
                $product = Product::find($plan->rm_product_id);
                if ($product) {
                    $plan->product_primary_id = $product->product_primary_id;
                    $plan->product_id = $product->product_id;
                    $plan->product_name = $product->product_name;
                }

                $uom = ProductUnit::find($plan->uom);
                $uom_arr = [];
                if ($uom) {
                    array_push($uom_arr, ["value" => $uom->id, "text" => $uom->name]);
                    $plan->uom = $uom_arr;
                }
            }
            $responseBody = $this->responseBody(true, "MaterialRequisitionController", "setScheduleBom", $bomdata);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialRequisitionController", "setScheduleBom", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    function getAllocatedQuantity($order_id, $product_id)
    {

        $plan = ScheduleCustomerOrderPlan::where('order_id', '=', $order_id)->first();

        $quantity = 0;

        if ($plan) {
            $plan_data = CustomerPlanData::where('customer_order_plan_id', '=', $plan->customer_order_plan_id)->first();
            if ($plan_data) {
                $query = 'SELECT SUM(pp_machinery_plans.quantity) AS quantity FROM pp_machinery_plans 
                WHERE pp_machinery_plans.customer_order_plan_data_id = "' . $plan_data->customer_order_plan_data_id . '" AND pp_machinery_plans.product_primary_id = "' . $product_id . '"';
                $result = DB::select($query);
                foreach ($result as $res) {
                    $quantity = $res->quantity;
                }
                if (!$quantity) {
                    $quantity = 0;
                }
            }
        }
        return $quantity;
    }



    function getBomHeaderQuantityProduct($product_id)
    {

        $quantity = 0;
        $query = 'SELECT pp_order_resource_boms.quantity FROM pp_order_resource_boms WHERE pp_order_resource_boms.rm_product_id = "' . $product_id . '"';
        $result = DB::select($query);
        foreach ($result as $res) {
            $quantity = $res->quantity;
        }
        if (!$quantity) {
            $quantity = 0;
        }
        return $quantity;
    }




    function getBOMData($customer_order_plan_data_id, $fg_product_id)
    {

        $query = 'SELECT st_product_units.name AS uom_name,
        st_products.product_primary_id,
        st_products.product_id,
        st_products.product_name,
        SUM(sc_product_histories.quantity) AS stock_in_h,
        pp_order_resource_boms.* 
        FROM pp_order_resource_boms
        INNER JOIN st_products ON pp_order_resource_boms.rm_product_id = st_products.product_primary_id
        INNER JOIN st_product_units ON pp_order_resource_boms.uom = st_product_units.id
        LEFT JOIN sc_product_histories ON pp_order_resource_boms.rm_product_id = sc_product_histories.product_id
        WHERE  pp_order_resource_boms.customer_order_plan_data_id = "' . $customer_order_plan_data_id . '" 
        AND pp_order_resource_boms.fg_product_id = "' . $fg_product_id . '" 
        GROUP BY pp_order_resource_boms.order_resource_bom_id';
        $result = DB::select($query);

        return $result;
    }


    private function getPrefix($document_no)
    {
        $document_no = DocumentNumber::where('document_number', '=', $document_no)->first();
        $prefix = "";
        if ($document_no) {
            $prefix = $document_no->prefix;
        }

        return $prefix;
    }


    private function sendNotification($date)
    {
        $approval_users = TransactionApproval::all();
        foreach ($approval_users as $approval_user) {
            $notificationData = [
                'data' => "Material request approval",
                'link' => "/sc/material_requisition_approval_list"
            ];
            $user = User::where('user_id', '=', $approval_user->requisition)->first();
            if ($user) {
                $user->notify(new UserNotification($notificationData));
            }
        }
    }


    private function sendMail($date)
    {
        $approval_users = TransactionApproval::all();
        foreach ($approval_users as $approval_user) {
 
            $employee = Employee::find($approval_user->requisition);
            if($employee){
                if($employee->email_alert){
                    if($employee->email){
                        MailController::createMail("Material request approval","You have a  material request approval", MailData::getSender(),$employee->email);
                    }
                }
            }
        }
    }



    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
